unit View.SetStatus;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls, Vcl.StdCtrls, WEBLib.ExtCtrls,
  WEBLib.StdCtrls, Utils;

type
  TFSetStatus = class(TWebForm)
    wlcbStatus: TWebLookupComboBox;
    dtpDate: TWebDateTimePicker;
    lblStatus1: TWebLabel;
    WebLabel1: TWebLabel;
    btnConfirm: TWebButton;
    btnCancel: TWebButton;
    WebLabel2: TWebLabel;
    edtOrderID: TWebEdit;
    edtJobName: TWebEdit;
    WebLabel3: TWebLabel;
    WebLabel4: TWebLabel;
    dtpShipDue: TWebDateTimePicker;
    WebLabel5: TWebLabel;
    dtpNewShipDue: TWebDateTimePicker;
    lblMount: TWebLabel;
    dtpMountDue: TWebDateTimePicker;
    lblMountNew: TWebLabel;
    dtpNewMountDue: TWebDateTimePicker;
    lblPlate: TWebLabel;
    dtpPlateDue: TWebDateTimePicker;
    lblPlateNew: TWebLabel;
    dtpNewPlateDue: TWebDateTimePicker;
    lblArt: TWebLabel;
    dtpArtDue: TWebDateTimePicker;
    lblArtNew: TWebLabel;
    dtpNewArtDue: TWebDateTimePicker;
    procedure WebFormShow(Sender: TObject);
    procedure btnConfirmClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    { Private declarations }
    function Verify(): boolean;
  public
    { Public declarations }
    confirm: boolean;
    OrderID, JobName, OrderType: string;
    ShipDue, MountDue, PlateDue, ArtDue: TDateTime;
  end;

var
  FSetStatus: TFSetStatus;

implementation

{$R *.dfm}

procedure TFSetStatus.btnCancelClick(Sender: TObject);
begin
  Close;
end;

function TFSetStatus.Verify: Boolean;
var
  input: TJSHTMLElement;
begin
  result := true;

  input := TJSHTMLElement(document.getElementById('dtpdate'));
  if dtpDate.Date = 0 then
  begin
    input.style.setProperty('background-color', 'yellow');
    result := false;
  end
  else
    input.style.setProperty('background-color', 'white');

  input := TJSHTMLElement(document.getElementById('wlc_status'));
  if wlcbStatus.Value = '' then
  begin
    input.style.setProperty('background-color', 'yellow');
    result := false;
  end
  else
    input.style.setProperty('background-color', 'white');

end;


procedure TFSetStatus.btnConfirmClick(Sender: TObject);
var
  el: tjshtmlElement;
begin
  if ( not Verify() ) then
  begin
    ShowToast('Failure: Please fill in all highlighted information')
  end
  else if ( ( OrderType = 'web plate' ) and ( wlcbStatus.Value = 'MOUNT' ) ) then
    ShowToast('Failure: Web Plate Orders do not have Mount Due/Done dates')
  else if ( ( OrderType = 'cutting die' ) and ( ( wlcbStatus.Value = 'MOUNT' ) or ( wlcbStatus.Value = 'ART' ) or (wlcbStatus.Value = 'PLATE') ) ) then
    ShowToast('Failure: Cutting Die Orders do not have Art/Plate/Mount Due or Done Dates')
  else
  begin
    confirm := true;
    ShowToast('Success: Status updated!');
    Close;
  end;
end;

procedure TFSetStatus.WebFormShow(Sender: TObject);
var
  ItemsToRemove: TStringList;
  i: integer;
  filteredItems: TJSArray;
begin
  edtOrderID.Text := OrderID;
  dtpDate.Date := 0;
  edtJobName.Text := JobName;
  dtpShipDue.Date := ShipDue;
  dtpMountDue.Date := MountDue;
  dtpPlateDue.Date := PlateDue;
  dtpArtDue.Date := ArtDue;
  dtpNewShipDue.Date := 0;
  dtpNewMountDue.Date := 0;
  dtpNewPlateDue.Date := 0;
  dtpNewArtDue.Date := 0;
  ItemsToRemove := TStringList.Create;
  console.log(orderType);
  if orderType = 'web plate' then
  begin
    dtpNewMountDue.Visible := false;
    dtpMountDue.Visible := false;
    lblMount.Visible := false;
    lblMountNew.Visible := false;
    wlcbStatus.LookupValues.AddPair('PROOF', 'Proof Done');
    wlcbStatus.LookupValues.AddPair('ART', 'Art Done');
    wlcbStatus.LookupValues.AddPair('PLATE', 'Plate Done');
    wlcbStatus.LookupValues.AddPair('SHIP', 'Ship Done');
  end
  else if orderType = 'cutting die' then
  begin
    dtpNewMountDue.Visible := false;
    dtpMountDue.Visible := false;
    lblMount.Visible := false;
    lblMountNew.Visible := false;

    dtpPlateDue.Visible := false;
    dtpNewPlateDue.Visible := false;
    lblPlate.Visible := false;
    lblPlateNew.Visible := false;

    dtpArtDue.Visible := false;
    dtpNewArtDue.Visible := false;
    lblArt.Visible := false;
    lblArtNew.Visible := false;

    wlcbStatus.LookupValues.AddPair('PROOF', 'Proof Done');
    wlcbStatus.LookupValues.AddPair('SHIP', 'Ship Done');
  end
  else
  begin
  wlcbStatus.LookupValues.AddPair('PROOF', 'Proof Done');
    wlcbStatus.LookupValues.AddPair('ART', 'Art Done');
    wlcbStatus.LookupValues.AddPair('PLATE', 'Plate Done');
     wlcbStatus.LookupValues.AddPair('MOUNT', 'Mount Done');
    wlcbStatus.LookupValues.AddPair('SHIP', 'Ship Done');
  end;
end;


end.