unit View.UserProfile;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls, Vcl.StdCtrls, WEBLib.StdCtrls,
  XData.Web.Client, WEBLib.ExtCtrls, DB, XData.Web.JsonDataset,
  XData.Web.Dataset, XData.Web.Connection, Vcl.Forms, ConnectionModule,
  WEBLib.Toast;

type
  TFViewUserProfile = class(TWebForm)
    WebLabel1: TWebLabel;
    WebLabel3: TWebLabel;
    edtUsername: TWebEdit;
    WebLabel2: TWebLabel;
    edtUserId: TWebEdit;
    edtFullName: TWebEdit;
    WebLabel4: TWebLabel;
    WebLabel5: TWebLabel;
    chkAdminUser: TWebCheckBox;
    edtEmail: TWebEdit;
    btnConfirm: TWebButton;
    lblResult: TWebLabel;
    XDataWebClient1: TXDataWebClient;
    btnCancel: TWebButton;
    procedure WebFormShow(Sender: TObject);
    procedure btnConfirmClick(Sender: TObject);
    [async] procedure EditUser();
    [async] procedure GetUser();
    procedure btnCancelClick(Sender: TObject);
  end;

var
  FViewUserProfile: TFViewUserProfile;

implementation

uses
  Auth.Service,
  XData.Model.Classes,
  Utils,
  View.Main;

{$R *.dfm}


procedure TFViewUserProfile.btnConfirmClick(Sender: TObject);
var
  FormEl: TJSHTMLFormElement;
begin
  FormEl := TJSHTMLFormElement(document.querySelector('form'));
  if not FormEl.checkValidity then
  begin
    FormEl.classList.add('was-validated');
    Exit;
  end;

  ShowConfirmationModal(
    'Are you sure you want to save changes to your profile?',
    'Save',
    'Cancel',
    procedure(confirmed: Boolean)
    begin
      if confirmed then
        EditUser;
    end
  );
end;


[async] procedure TFViewUserProfile.EditUser;
var
  xdcResponse: TXDataClientResponse;
  responseString: TJSObject;
  editOptions, resultMsg: string;
begin
  try
    editOptions := '&username=' + edtUsername.Text +
                   '&fullname=' + edtFullName.Text +
                   '&email=' + edtEmail.Text;

    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.EditUser', [editOptions]));
    responseString := TJSObject(xdcResponse.Result);
    resultMsg := string(responseString['value']);

    Utils.ShowToast(resultMsg);

    if resultMsg.ToLower.StartsWith('success:') then
      FViewMain.ViewOrders('');
  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
    on E: Exception do
      Utils.ShowErrorModal('Unexpected error: ' + E.Message);
  end;
end;


procedure TFViewUserProfile.btnCancelClick(Sender: TObject);
begin
  ShowConfirmationModal(
    'Are you sure you want to cancel all your changes?',
    'Yes',
    'No',
    procedure(confirmed: Boolean)
    begin
      if confirmed then
      begin
        GetUser();
        ShowToast('Changes discarded', 'danger');
      end;
    end
  );
end;


procedure TFViewUserProfile.WebFormShow(Sender: TObject);
begin
  GetUser();
  //edtJwt.Text := TJSJSON.stringify(AuthService.TokenPayload);
  // View.UserProfile.WebFormShow
  chkAdminUser.Checked := SameText(string(AuthService.TokenPayload.Properties['user_admin']), 'true');
end;


procedure TFViewUserProfile.GetUser;
var
  xdcResponse: TXDataClientResponse;
  userList: TJSObject;
  data: TJSArray;
  user: TJSObject;
begin
  try
    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetUsers',
          [JS.toString(AuthService.TokenPayload.Properties['user_name'])]));
    userList :=  TJSObject(xdcResponse.Result);
    data := TJSArray(userList['data']);
    user := TJSObject(data[0]);
    edtUsername.Text := string(user['username']);
    edtFullName.Text := string(user['full_name']);
    edtEmail.Text := string(user['email_address']);
    edtUserId.Text := string(user['userID']);
    chkAdminUser.Checked := boolean(user['admin']);
  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
end;


end.
