unit View.Main;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, WEBLib.ExtCtrls, Vcl.Controls, Vcl.StdCtrls,
  WEBLib.StdCtrls, Data.DB, XData.Web.JsonDataset, XData.Web.Dataset,
  App.Types, ConnectionModule, XData.Web.Client, WEBLib.Menus, Utils;

type
  TFViewMain = class(TWebForm)
    lblUsername: TWebLabel;
    wllblUserProfile: TWebLinkLabel;
    wllblLogout: TWebLinkLabel;
    WebPanel1: TWebPanel;
    lblHome: TWebLinkLabel;
    WebMessageDlg1: TWebMessageDlg;
    lblAppTitle: TWebLabel;
    WebMemo1: TWebMemo;
    XDataWebClient: TXDataWebClient;
    lblItemsList: TWebLinkLabel;
    lblUsers: TWebLinkLabel;
    lblorders: TWebLabel;
    lblCustomers: TWebLabel;
    lblVersion: TWebLabel;
    procedure WebFormCreate(Sender: TObject);
    procedure mnuLogoutClick(Sender: TObject);
    procedure wllblUserProfileClick(Sender: TObject);
    procedure wllblLogoutClick(Sender: TObject);
    procedure lblHomeClick(Sender: TObject);
    procedure lblItemsListClick(Sender: TObject);
    procedure lblUsersClick(Sender: TObject);
    procedure lblordersClick(Sender: TObject);
    procedure lblCustomersClick(Sender: TObject);
    procedure lblQuickbooksClick(Sender: TObject);
  private
    { Private declarations }
    FUserInfo: string;
    FSearchSettings: string;
    FChildForm: TWebForm;
    FLogoutProc: TLogoutProc;
    FSearchProc: TSearchProc;
    procedure ShowCrudForm( AFormClass: TWebFormClass );
    //procedure EditUser( AParam, BParam, CParam, DParam, EParam: string);
    function GetUserInfo: string;
    procedure setActive(page: string);
    procedure ConfirmLogout;
  public
    { Public declarations }
    class procedure Display(LogoutProc: TLogoutProc);
    procedure ShowForm( AFormClass: TWebFormClass );
    procedure EditUser(  Mode, Username, Password, Name, Status, Email, Access, Rights, QB: string);
    procedure ViewOrderEntryCorrugated(orderInfo, customerInfo, mode, info: string);
    procedure ViewOrderEntryWeb(orderInfo, customerInfo, mode, info: string);
    procedure ViewOrderEntryCuttingDie(orderInfo, customerInfo, mode, info: string);
    procedure ViewOrders(info: string);
    procedure ViewCustomerList(info: string);
    procedure ShowUserForm(Info: string);
    procedure ViewAddCustomer(customerInfo, info: string);
    var
      search: string;
      change: boolean;
  end;

var
  FViewMain: TFViewMain;

implementation

uses
  Auth.Service,
  View.Login,
  View.UserProfile,
  View.Home,
  View.Items,
  View.Users,
  View.EditUser,
  View.Orders,
  View.OrderEntryCorrugated,
  View.OrderEntryCuttingDie,
  View.OrderEntryWeb,
  View.Customers, AddCustomer;

{$R *.dfm}

procedure TFViewMain.WebFormCreate(Sender: TObject);
var
  userName: string;
  test: boolean;
begin
  FUserInfo := GetUserInfo;
  userName := JS.toString(AuthService.TokenPayload.Properties['user_name']);
  lblUsername.Caption := ' ' + userName.ToLower + ' ';
  FChildForm := nil;
  change := false;
  console.log(JS.toBoolean(AuthService.TokenPayload.Properties['user_access_type']));
  if (not (JS.toString(AuthService.TokenPayload.Properties['user_access_type']) = 'ADMIN'))  then
  begin
    lblUsers.enabled := false;

    lblCustomers.Enabled := false;
  end;

  ShowForm(TFViewOrders);
  lblAppTitle.Caption := 'Koehler-Gibson Orders';
  lblVersion.Caption := 'v' + DMConnection.clientVersion;
  setActive('Orders');
end;




procedure TFViewMain.lblCustomersClick(Sender: TObject);
begin
  if ( not ( change ) ) then
  begin
    ShowForm(TFViewCustomers);
    lblAppTitle.Caption := 'Koehler-Gibson Customers';
    setActive('Customers');
  end
  else
    ShowToast('Please Save or Cancel your changes', 'danger');
end;

procedure TFViewMain.lblHomeClick(Sender: TObject);
begin
  if ( not ( change ) ) then
  begin
    ShowForm(TFViewHome);
    lblAppTitle.Caption := 'Koehler-Gibson Home';
    //setActive('Home');
  end
  else
    ShowToast('Please Save or Cancel your changes', 'danger');
end;

procedure TFViewMain.lblordersClick(Sender: TObject);
begin
  if ( not ( change ) ) then
  begin
    ShowForm(TFViewOrders);
    lblAppTitle.Caption := 'Koehler-Gibson Orders';
    setActive('Orders');
  end
  else
    ShowToast('Please Save or Cancel your changes', 'danger');
end;

procedure TFViewMain.lblQuickbooksClick(Sender: TObject);
begin
  if ( not ( change ) ) then
  begin
    //ShowForm(TFViewQuickbooks);
    lblAppTitle.Caption := 'Koehler-Gibson QuickBooks';
    setActive('QuickBooks');
  end
  else
    ShowToast('Please Save or Cancel your changes', 'danger');
end;

procedure TFViewMain.lblUsersClick(Sender: TObject);
begin
  if ( not ( change ) ) then
  begin
    ShowForm(TFViewUsers);
    lblAppTitle.Caption := 'Koehler-Gibson Users';
  end
  else
    ShowToast('Please Save or Cancel your changes', 'danger');
end;

procedure TFViewMain.lblItemsListClick(Sender: TObject);
begin
  if ( not ( change ) ) then
  begin
    if Assigned(FChildForm) then
      FChildForm.Free;
    TFViewItems.CreateForm(WebPanel1.ElementID);
    lblAppTitle.Caption := 'Koehler-Gibson Items';
    setActive('Items');
  end
  else
    ShowToast('Please Save or Cancel your changes', 'danger');
end;

procedure TFViewMain.setActive(page: string);
var
  links: TJSNodeList;
  link: TJSHTMLElement;
  i: integer;
begin
  // Get all the links in the navbar
  links := document.querySelectorAll('.navbar-nav .nav-item a');

  for i := 0 to links.length - 1 do
  begin
    link := TJSHTMLElement(links[i]);
    link.classList.remove('active');
    if link.innerText.Contains(page) then
      link.classList.add('active');
  end;
end;

procedure TFViewMain.mnuLogoutClick(Sender: TObject);
begin
  ConfirmLogout;
end;


procedure TFViewMain.wllblLogoutClick(Sender: TObject);
begin
  ConfirmLogout;
end;


procedure TFViewMain.ConfirmLogout;
begin
  ShowConfirmationModal(
    'Are you sure you want to log out?',
    'Yes',
    'No',
    procedure(confirmed: Boolean)
    begin
      if confirmed and Assigned(FLogoutProc) then
        FLogoutProc('');
    end
  );
end;


procedure TFViewMain.wllblUserProfileClick(Sender: TObject);
begin
    ShowCrudForm(TFViewUserProfile);
    lblAppTitle.Caption := 'Koehler-Gibson User Profile';
end;

//needs to be changed
function TFViewMain.GetUserInfo: string;
var
  userStr: string;
begin
  userStr := '?username=' + JS.toString(AuthService.TokenPayload.Properties['user_name']);
  userStr := userStr + '&fullname=' + JS.toString(AuthService.TokenPayload.Properties['user_fullname']);
  userStr := userStr + '&agency=' + JS.toString(AuthService.TokenPayload.Properties['user_agency']);
  userStr := userStr + '&badge=' + JS.toString(AuthService.TokenPayload.Properties['user_badge']);
  userStr := userStr + '&userid=' + JS.toString(AuthService.TokenPayload.Properties['user_id']);
  userStr := userStr + '&personnelid=' + JS.toString(AuthService.TokenPayload.Properties['user_personnelid']);

  Result := userStr;
end;


class procedure TFViewMain.Display(LogoutProc: TLogoutProc);
begin
  if Assigned(FViewMain) then
    FViewMain.Free;
  FViewMain := TFViewMain.CreateNew;
  FViewMain.FLogoutProc := LogoutProc;
end;


procedure TFViewMain.ShowCrudForm(AFormClass: TWebFormClass);
begin
  ShowForm(AFormClass);
end;


procedure TFViewMain.ShowForm(AFormClass: TWebFormClass);
begin
  if Assigned(FChildForm) then
    FChildForm.Free;
  Application.CreateForm(AFormClass, WebPanel1.ElementID, FChildForm);
end;

procedure TFViewMain.ViewCustomerList(info: string);
begin

end;

procedure TFViewMain.EditUser(Mode, Username, Password, Name, Status, Email,
                               Access, Rights, QB: string);
begin
  if Assigned(FChildForm) then
    FChildForm.Free;
  FChildForm := TFViewEditUser.CreateForm(WebPanel1.ElementID, Mode, Username,
                                Password, Name, Status, Email, Access, Rights, QB);
end;

procedure TFViewMain.ViewOrders(info: string);
begin
  if Assigned(FChildForm) then
    FChildForm.Free;
  FChildForm := TFViewOrders.CreateForm(WebPanel1.ElementID, info);
end;


procedure TFViewMain.ViewOrderEntryCorrugated(orderInfo, customerInfo, mode, info: string);
begin
  lblAppTitle.Caption := 'Koehler-Gibson Order Entry';
  if Assigned(FChildForm) then
    FChildForm.Free;
  FChildForm := TFOrderEntryCorrugated.CreateForm(WebPanel1.ElementID, orderInfo, customerInfo, mode, info);
end;

procedure TFViewMain.ViewOrderEntryWeb(orderInfo, customerInfo, mode, info: string);
begin
  lblAppTitle.Caption := 'Koehler-Gibson Order Entry';
  if Assigned(FChildForm) then
    FChildForm.Free;
  FChildForm := TFOrderEntryWeb.CreateForm(WebPanel1.ElementID, orderInfo, customerInfo, mode, info);
end;

procedure TFViewMain.ViewOrderEntryCuttingDie(orderInfo, customerInfo, mode, info: string);
begin
  lblAppTitle.Caption := 'Koehler-Gibson Order Entry';
  if Assigned(FChildForm) then
    FChildForm.Free;
  FChildForm := TFOrderEntryCuttingDie.CreateForm(WebPanel1.ElementID, orderInfo, customerInfo, mode, info);
end;

procedure TFViewMain.ViewAddCustomer(customerInfo: string; info: string);
begin
  lblAppTitle.Caption := 'Koehler-Gibson Add Customer';
  if Assigned(FChildForm) then
    FChildForm.Free;
  FChildForm := TFViewAddCustomer.CreateForm(WebPanel1.ElementID, customerInfo, info);
end;

procedure TFViewMain.ShowUserForm(Info: string);
begin
  if Assigned(FChildForm) then
    FChildForm.Free;
  FChildForm := TFViewUsers.CreateForm(WebPanel1.ElementID, Info);
end;

end.
