unit rOrderWeb;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, Common.Logging,
  frxClass, frxExportBaseDialog, frxExportPDF, frCoreClasses, frxDBSet, JS, JSON,
  frxTableObject, frxUtils, System.Generics.Collections;

type
  TrptOrderWeb = class(TDataModule)
    ucKG: TUniConnection;
    frxPDFExport1: TfrxPDFExport;
    frxDBOrderWeb: TfrxDBDataset;
    frxOrderWeb: TfrxReport;
    uqOrderWeb: TUniQuery;
    uqOrderWebORDER_ID: TIntegerField;
    uqOrderWebCOMPANY_ID: TIntegerField;
    uqOrderWebUSER_ID: TIntegerField;
    uqOrderWebORDER_DATE: TDateTimeField;
    uqOrderWebSTART_DATE: TDateField;
    uqOrderWebEND_DATE: TDateField;
    uqOrderWebORDER_STATUS: TStringField;
    uqOrderWebSCHED_JSON: TStringField;
    uqOrderWebstaff_fields_order_date: TDateField;
    uqOrderWebstaff_fields_proof_date: TDateField;
    uqOrderWebstaff_fields_ship_date: TDateField;
    uqOrderWebstaff_fields_ship_via: TStringField;
    uqOrderWebstaff_fields_price: TStringField;
    uqOrderWebstaff_fields_invoice_to: TStringField;
    uqOrderWebstaff_fields_invoice_attention: TStringField;
    uqOrderWebstaff_fields_ship_to: TStringField;
    uqOrderWebstaff_fields_ship_attention: TStringField;
    uqOrderWebstaff_fields_po_number: TStringField;
    uqOrderWebstaff_fields_job_name: TStringField;
    uqOrderWebstaff_fields_art_due: TDateField;
    uqOrderWebstaff_fields_plate_due: TDateField;
    uqOrderWebplates_job_number: TStringField;
    uqOrderWebsupplied_by_customer_b_w_or_co: TStringField;
    uqOrderWebsupplied_by_customer_plates: TStringField;
    uqOrderWebsupplied_by_customer_sample: TStringField;
    uqOrderWebsupplied_by_customer_dimension: TStringField;
    uqOrderWebsupplied_by_customer_other: TStringField;
    uqOrderWebsupplied_by_customer_disk: TStringField;
    uqOrderWebsupplied_by_customer_e_mail: TStringField;
    uqOrderWebsupplied_by_customer_ftp: TStringField;
    uqOrderWebplates_plate_material: TStringField;
    uqOrderWebplates_thickness: TStringField;
    uqOrderWebsupplied_by_customer_total_inc: TStringField;
    uqOrderWebsupplied_by_customer_sheets_us: TStringField;
    uqOrderWebsupplied_by_customer_initials: TStringField;
    uqOrderWebproofing_pdf: TStringField;
    uqOrderWebproofing_pdf_to: TStringField;
    uqOrderWebproofing_pdf_date_1: TDateField;
    uqOrderWebproofing_pdf_date_2: TDateField;
    uqOrderWebproofing_pdf_date_3: TDateField;
    uqOrderWebproofing_full_size_ink_jet_for: TStringField;
    uqOrderWebproofing_ink_jet_to: TStringField;
    uqOrderWebproofing_ink_jet_to_2: TStringField;
    uqOrderWebproofing_ink_jet_date_1: TDateField;
    uqOrderWebproofing_ink_jet_date_2: TDateField;
    uqOrderWebproofing_ink_jet_date_3: TDateField;
    uqOrderWebproofing_color_contract: TStringField;
    uqOrderWebproofing_color_contrac_to: TStringField;
    uqOrderWebproofing_color_contrac_date_1: TDateField;
    uqOrderWebproofing_color_contrac_date_2: TDateField;
    uqOrderWebproofing_digital_color_key: TStringField;
    uqOrderWebproofing_digital_color_to: TStringField;
    uqOrderWebproofing_digital_color_date_1: TDateField;
    uqOrderWebquantity_and_colors_press_name: TStringField;
    uqOrderWebquantity_and_colors_anilox_info: TStringField;
    uqOrderWebplate_marks_microdots: TStringField;
    uqOrderWebplate_marks_microdots_comments: TStringField;
    uqOrderWebplate_marks_crosshairs: TStringField;
    uqOrderWebplate_marks_crosshairs_comments: TStringField;
    uqOrderWebplate_marks_color_bars: TStringField;
    uqOrderWebplate_marks_color_bars_comments: TStringField;
    uqOrderWebplate_marks_other: TStringField;
    uqOrderWebplate_marks_other_comments: TStringField;
    uqOrderWebprint_orientation_print_orient: TStringField;
    uqOrderWeblayout_around: TStringField;
    uqOrderWeblayout_accross: TStringField;
    uqOrderWeblayout_surface_print: TStringField;
    uqOrderWeblayout_reverse_print: TStringField;
    uqOrderWeblayout_cylinder_repeat: TStringField;
    uqOrderWeblayout_cutoff_dimension: TStringField;
    uqOrderWeblayout_pitch: TStringField;
    uqOrderWeblayout_teeth: TStringField;
    uqOrderWeblayout_bleed: TStringField;
    uqOrderWeblayout_cutback: TStringField;
    uqOrderWeblayout_minimum_trap_dim: TStringField;
    uqOrderWeblayout_maximum_trap_dim: TStringField;
    uqOrderWebupc_size: TStringField;
    uqOrderWebupc_bar_width_reduction: TStringField;
    uqOrderWebquantity_and_colors_qty_colors: TStringField;
    uqOrderWebgeneral_comments: TStringField;
    uqOrderWebstaff_fields_quickbooks_item: TStringField;
    uqOrderWebstaff_fields_quantity: TStringField;
    uqOrderWebupc_distortion_percent: TStringField;
    uqOrderWebupc_distortion_amount: TStringField;
    uqOrderWebstaff_fields_art_location: TStringField;
    uqOrderWebORDER_ID_1: TLongWordField;
    uqOrderWebCOMPANY_ID_1: TLongWordField;
    uqOrderWebORDER_TYPE: TStringField;
    uqOrderWebORDER_DATE_1: TDateTimeField;
    uqOrderWebPRICE: TFloatField;
    uqOrderWebJOB_NAME: TStringField;
    uqOrderWebUSER_ID_1: TLongWordField;
    uqOrderWebLOCATION: TStringField;
    uqOrderWebIN_QB: TStringField;
    uqOrderWebQB_ORDER_NUM: TStringField;
    uqOrderWebQB_ESTIMATE_ID: TStringField;
    uqOrderWebQB_ORDER_USER: TStringField;
    uqOrderWebQB_CREATE_DATE: TDateTimeField;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function PrepareReport(SQL: string): string;
    function GeneratePDF: string;
    procedure PopulateColorTable();
  end;

var
  rptOrderWeb: TrptOrderWeb;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

uses
  uLibrary, Common.Config;

procedure TrptOrderWeb.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 1, 'TAuthDatabase.DataModuleCreate' );
  LoadDatabaseSettings( ucKG, 'kgOrdersServer.ini' );
  try
    ucKG.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TrptOrderList.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;


procedure TrptOrderWeb.PopulateColorTable;
var
  row: TfrxCustomTableRow;
  colorArray: TJSONArray;
  colorsObject, colorObject: TJSONObject;
  colorsString: string;
  i: Integer;
begin
  logger.Log(5, 'Adding Color Rows');

  colorsString := uqOrderWeb.FieldByName('quantity_and_colors_qty_colors').AsString;
  colorsObject :=  TJSONObject.ParseJSONValue(colorsString) as TJSONObject;
  colorArray := TJSONArray(colorsObject.GetValue<TJSONArray>('items'));

  for i := 0 to colorArray.Count - 1 do
  begin
    row := frxOrderWeb.FindObject('ColorRow' + IntToStr(i + 1)) as TfrxCustomTableRow;
    colorObject := colorArray.Items[i] as TJSONObject;

    row.Cells[0].Text := colorObject.GetValue<string>('#');
    row.Cells[1].Text := colorObject.GetValue<string>('Color');
    row.Cells[2].Text := colorObject.GetValue<string>('LPI');
    row.Cells[3].Text := colorObject.GetValue<string>('Size');
  end;

  colorsObject.Free;
end;


function TrptOrderWeb.PrepareReport(SQL: string): string;
begin
  Logger.Log(3, 'Generated SQL for Prepare Report: ' + SQL);
  doQuery(uqOrderWeb, SQL);

  if ( string( uqOrderWeb.FieldByName('quantity_and_colors_qty_colors').AsString ) ) <> '' then
  begin
    PopulateColorTable();
  end;
  result := GeneratePDF;

  Logger.Log(3, 'Report preparation complete.');
end;


function TrptOrderWeb.GeneratePDF: string;
var
  ReportDir, ReportFileName: string;
  reportURL: string;
begin
  ReportDir := ServerConfig.reportsFolder;

  if not DirectoryExists(ReportDir) then
  begin
    ForceDirectories(ReportDir);
    Logger.Log(1, 'Reports directory created: ' + ReportDir);
  end;
  reportURL :=  'reports\' + FormatDateTime('yyyymmdd_hhnnss', Now) + '.pdf';

  ReportFileName := reportDir + reportUrl;

  frxPDFExport1.FileName := ReportFileName;
  frxPDFExport1.ShowDialog := False;
  try
    frxOrderWeb.PrepareReport;
    frxOrderWeb.Export(frxPDFExport1);
  finally
     frxOrderWeb.Clear; // Clears the report to avoid memory bloat
  end;

  Logger.Log(5, 'PDF saved to: ' + ReportFileName);
  result := reportURL;
end;

end.
