unit rOrderCorrugated;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, Common.Logging,
  frxClass, frxExportBaseDialog, frxExportPDF, frCoreClasses, frxDBSet, JS, JSON,
  frxTableObject, frxUtils, System.Generics.Collections;

type
  TrptOrderCorrugated = class(TDataModule)
    ucKG: TUniConnection;
    frxPDFExport1: TfrxPDFExport;
    frxDBOrderCorrugated: TfrxDBDataset;
    frxOrderCorrugated: TfrxReport;
    uqOrderCorrugated: TUniQuery;
    uqOrderCorrugatedORDER_ID: TIntegerField;
    uqOrderCorrugatedCOMPANY_ID: TIntegerField;
    uqOrderCorrugatedUSER_ID: TIntegerField;
    uqOrderCorrugatedORDER_DATE: TDateTimeField;
    uqOrderCorrugatedSTART_DATE: TDateField;
    uqOrderCorrugatedEND_DATE: TDateField;
    uqOrderCorrugatedORDER_STATUS: TStringField;
    uqOrderCorrugatedSCHED_JSON: TStringField;
    uqOrderCorrugatedstaff_fields_order_date: TDateField;
    uqOrderCorrugatedstaff_fields_proof_date: TDateField;
    uqOrderCorrugatedstaff_fields_ship_date: TDateField;
    uqOrderCorrugatedstaff_fields_ship_via: TStringField;
    uqOrderCorrugatedstaff_fields_price: TStringField;
    uqOrderCorrugatedstaff_fields_invoice_to: TStringField;
    uqOrderCorrugatedstaff_fields_invoice_attention: TStringField;
    uqOrderCorrugatedstaff_fields_ship_to: TStringField;
    uqOrderCorrugatedstaff_fields_ship_attention: TStringField;
    uqOrderCorrugatedstaff_fields_po_number: TStringField;
    uqOrderCorrugatedstaff_fields_job_name: TStringField;
    uqOrderCorrugatedstaff_fields_art_due: TDateField;
    uqOrderCorrugatedstaff_fields_plate_due: TDateField;
    uqOrderCorrugatedstaff_fields_mount_due: TDateField;
    uqOrderCorrugatedplates_job_number: TStringField;
    uqOrderCorrugatedsupplied_by_customer_b_w_copy: TStringField;
    uqOrderCorrugatedsupplied_by_customer_color_copy: TStringField;
    uqOrderCorrugatedsupplied_by_customer_plates: TStringField;
    uqOrderCorrugatedsupplied_by_customer_sample_ca: TStringField;
    uqOrderCorrugatedsupplied_by_customer_dimension: TStringField;
    uqOrderCorrugatedsupplied_by_customer_disk_or_cd: TStringField;
    uqOrderCorrugatedsupplied_by_customer_e_mail: TStringField;
    uqOrderCorrugatedsupplied_by_customer_ftp: TStringField;
    uqOrderCorrugatedsupplied_by_customer_other: TStringField;
    uqOrderCorrugatedsupplied_by_customer_existing_: TStringField;
    uqOrderCorrugatedsupplied_by_customer_ref_art_p: TStringField;
    uqOrderCorrugatedsupplied_by_customer_ref_art_a: TStringField;
    uqOrderCorrugatedcut_die_cutdier: TStringField;
    uqOrderCorrugatedcut_die_cutdieb: TStringField;
    uqOrderCorrugatedcut_die_cutdief: TStringField;
    uqOrderCorrugatedcut_die_cutdierkr: TStringField;
    uqOrderCorrugatedcut_die_cutdiefkr: TStringField;
    uqOrderCorrugatedcut_die_cad_file: TStringField;
    uqOrderCorrugatedcut_die_attached: TStringField;
    uqOrderCorrugatedcut_die_boxpol250: TStringField;
    uqOrderCorrugatedcut_die_boxpol155: TStringField;
    uqOrderCorrugatedcut_die_boxpol125: TStringField;
    uqOrderCorrugatedcut_die_brub: TStringField;
    uqOrderCorrugatedproofing_fax: TStringField;
    uqOrderCorrugatedproofing_fax_attn: TStringField;
    uqOrderCorrugatedproofing_e_mail: TStringField;
    uqOrderCorrugatedproofing_e_mail_attn: TStringField;
    uqOrderCorrugatedproofing_ship_to: TStringField;
    uqOrderCorrugatedproofing_full_size_panel: TStringField;
    uqOrderCorrugatedproofing_print_card: TStringField;
    uqOrderCorrugatedproofing_wide_format: TStringField;
    uqOrderCorrugatedproofing_pdf_file: TStringField;
    uqOrderCorrugatedproofing_other: TStringField;
    uqOrderCorrugatedproofing_art_approved_as_is: TStringField;
    uqOrderCorrugatedproofing_approved_date: TDateField;
    uqOrderCorrugatedproofing_changes_required: TStringField;
    uqOrderCorrugatedproofing_changes_date: TDateField;
    uqOrderCorrugatedlayout_rsc_l: TStringField;
    uqOrderCorrugatedlayout_rcs_w: TStringField;
    uqOrderCorrugatedlayout_rcs_d: TStringField;
    uqOrderCorrugatedlayout_die_cut_no: TStringField;
    uqOrderCorrugatedlayout_accross_no: TStringField;
    uqOrderCorrugatedlayout_around_no: TStringField;
    uqOrderCorrugatedlayout_cad_file: TStringField;
    uqOrderCorrugatedlayout_excalibur_die: TStringField;
    uqOrderCorrugatedmounting_loose: TStringField;
    uqOrderCorrugatedmounting_sticky_bak: TStringField;
    uqOrderCorrugatedmounting_full_mount: TStringField;
    uqOrderCorrugatedmounting_strip_mount: TStringField;
    uqOrderCorrugatedcolors_cylinder_size: TStringField;
    uqOrderCorrugatedcolors_machine_ident: TStringField;
    uqOrderCorrugatedmounting_standard_setup: TStringField;
    uqOrderCorrugatedmounting_custom_backing: TStringField;
    uqOrderCorrugatedmounting_custom_adhesive: TStringField;
    uqOrderCorrugatedcolors_cross_hairs: TStringField;
    uqOrderCorrugatedcolors_clemson: TStringField;
    uqOrderCorrugatedplates_thickness: TStringField;
    uqOrderCorrugatedplates_plate_material: TStringField;
    uqOrderCorrugatedgeneral_special_instructions: TStringField;
    uqOrderCorrugatedcolors_colors: TStringField;
    uqOrderCorrugatedstaff_fields_quickbooks_item: TStringField;
    uqOrderCorrugatedstaff_fields_quantity: TStringField;
    uqOrderCorrugatedlayout_rsc_style: TStringField;
    uqOrderCorrugatedstaff_fields_art_location: TStringField;
    uqOrderCorrugatedORDER_ID_1: TLongWordField;
    uqOrderCorrugatedCOMPANY_ID_1: TLongWordField;
    uqOrderCorrugatedORDER_TYPE: TStringField;
    uqOrderCorrugatedORDER_DATE_1: TDateTimeField;
    uqOrderCorrugatedPRICE: TFloatField;
    uqOrderCorrugatedJOB_NAME: TStringField;
    uqOrderCorrugatedUSER_ID_1: TLongWordField;
    uqOrderCorrugatedLOCATION: TStringField;
    uqOrderCorrugatedIN_QB: TStringField;
    uqOrderCorrugatedQB_ORDER_NUM: TStringField;
    uqOrderCorrugatedQB_ESTIMATE_ID: TStringField;
    uqOrderCorrugatedQB_ORDER_USER: TStringField;
    uqOrderCorrugatedQB_CREATE_DATE: TDateTimeField;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    function PrepareReport(SQL: string): string;
    function GeneratePDF: string;
    procedure PopulateColorTable();
  end;

var
  rptOrderCorrugated: TrptOrderCorrugated;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

uses
  uLibrary, Common.Config;

procedure TrptOrderCorrugated.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 5, 'TrptOrderCorrugated.DataModuleCreate' );
  LoadDatabaseSettings( ucKG, 'kgOrdersServer.ini' );
  try
    ucKG.Connect;
  except
    on E: Exception do
    begin
      Logger.Log( 1, '--TrptOrderCorrugated.DataModuleCreate -Error connecting to database: ' + E.Message );
    end;
  end;
end;


procedure TrptOrderCorrugated.PopulateColorTable;
var
  row: TfrxCustomTableRow;
  colorArray: TJSONArray;
  colorsObject, colorObject: TJSONObject;
  colorsString: string;
  i: Integer;
begin
  logger.Log( 5, 'TrptOrderCorrugated.PopulateColorTable' );

  colorsString := uqOrderCorrugated.FieldByName('colors_colors').AsString;
  colorsObject :=  TJSONObject.ParseJSONValue(colorsString) as TJSONObject;
  colorArray := TJSONArray(colorsObject.GetValue<TJSONArray>('items'));

  for i := 0 to colorArray.Count - 1 do
  begin
    row := frxOrderCorrugated.FindObject('ColorRow' + IntToStr(i + 1)) as TfrxCustomTableRow;
    colorObject := colorArray.Items[i] as TJSONObject;

    row.Cells[0].Text := colorObject.GetValue<string>('#');
    row.Cells[1].Text := colorObject.GetValue<string>('Color');
    row.Cells[2].Text := colorObject.GetValue<string>('LPI');
    row.Cells[3].Text := colorObject.GetValue<string>('Size');
  end;

  colorsObject.Free;
end;


function TrptOrderCorrugated.PrepareReport(SQL: string): string;
begin
  Logger.Log( 5, 'TrptOrderCorrugated.PrepareReport - SQL: ' + SQL );

  doQuery(uqOrderCorrugated, SQL);
  if ( string( uqOrderCorrugated.FieldByName('colors_colors').AsString ) ) <> '' then
  begin
    PopulateColorTable();
  end;
  result := GeneratePDF;
end;


function TrptOrderCorrugated.GeneratePDF: string;
var
  reportsDir, reportFileName: string;
  reportURL: string;
begin
  reportsDir := ServerConfig.reportsFolder;
  reportFileName := FormatDateTime('yyyymmdd_hhnnss', Now) + '.pdf';
  reportURL :=  'reports\' + reportFilename;

  frxPDFExport1.FileName := reportsDir + reportFileName;
  frxPDFExport1.ShowDialog := False;
  try
    frxOrderCorrugated.PrepareReport;
    frxOrderCorrugated.Export(frxPDFExport1);
    //frxOrders.ShowPreparedReport;

  finally
    frxOrderCorrugated.Clear; // Clears the report to avoid memory bloat

  end;

  Logger.Log( 4, 'TrptOrderCorrugated.GeneratePDF - PDF saved to: ' + reportFileName );
  result := reportURL;
end;


end.
