// Where the database is kept. Only used by Lookup.ServiceImpl to retrieve info
// from the data base and send it to the client.
// Author: ???
unit Api.Database;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, UniProvider,
  PostgreSQLUniProvider, System.Variants, System.Generics.Collections, System.IniFiles,
  Common.Logging, Vcl.Forms, MySQLUniProvider;

type
  TApiDatabase = class(TDataModule)
    ucKG: TUniConnection;
    UniQuery1: TUniQuery;
    MySQLUniProvider1: TMySQLUniProvider;
    UniQuery2: TUniQuery;
    uqOrders: TUniQuery;
    uqOrdersORDER_ID: TIntegerField;
    uqOrdersCOMPANY_ID: TIntegerField;
    uqOrdersUSER_ID: TIntegerField;
    uqOrdersORDER_DATE: TDateTimeField;
    uqOrdersSTART_DATE: TDateField;
    uqOrdersEND_DATE: TDateField;
    uqOrdersORDER_STATUS: TStringField;
    uqOrdersSCHED_JSON: TStringField;
    uqOrdersstaff_fields_order_date: TDateField;
    uqOrdersstaff_fields_proof_date: TDateField;
    uqOrdersstaff_fields_ship_date: TDateField;
    uqOrdersstaff_fields_ship_via: TStringField;
    uqOrdersstaff_fields_price: TStringField;
    uqOrdersstaff_fields_invoice_to: TStringField;
    uqOrdersstaff_fields_invoice_attention: TStringField;
    uqOrdersstaff_fields_ship_to: TStringField;
    uqOrdersstaff_fields_ship_attention: TStringField;
    uqOrdersstaff_fields_po_number: TStringField;
    uqOrdersstaff_fields_job_name: TStringField;
    uqOrdersstaff_fields_art_due: TDateField;
    uqOrdersstaff_fields_plate_due: TDateField;
    uqOrdersstaff_fields_mount_due: TDateField;
    uqOrdersplates_job_number: TStringField;
    uqOrderssupplied_by_customer_b_w_copy: TStringField;
    uqOrderssupplied_by_customer_color_copy: TStringField;
    uqOrderssupplied_by_customer_plates: TStringField;
    uqOrderssupplied_by_customer_sample_ca: TStringField;
    uqOrderssupplied_by_customer_dimension: TStringField;
    uqOrderssupplied_by_customer_disk_or_cd: TStringField;
    uqOrderssupplied_by_customer_e_mail: TStringField;
    uqOrderssupplied_by_customer_ftp: TStringField;
    uqOrderssupplied_by_customer_other: TStringField;
    uqOrderssupplied_by_customer_existing_: TStringField;
    uqOrderssupplied_by_customer_ref_art_p: TStringField;
    uqOrderssupplied_by_customer_ref_art_a: TStringField;
    uqOrderscut_die_cutdier: TStringField;
    uqOrderscut_die_cutdieb: TStringField;
    uqOrderscut_die_cutdief: TStringField;
    uqOrderscut_die_cutdierkr: TStringField;
    uqOrderscut_die_cutdiefkr: TStringField;
    uqOrderscut_die_cad_file: TStringField;
    uqOrderscut_die_attached: TStringField;
    uqOrderscut_die_boxpol250: TStringField;
    uqOrderscut_die_boxpol155: TStringField;
    uqOrderscut_die_boxpol125: TStringField;
    uqOrderscut_die_brub: TStringField;
    uqOrdersproofing_fax: TStringField;
    uqOrdersproofing_fax_attn: TStringField;
    uqOrdersproofing_e_mail: TStringField;
    uqOrdersproofing_e_mail_attn: TStringField;
    uqOrdersproofing_ship_to: TStringField;
    uqOrdersproofing_full_size_panel: TStringField;
    uqOrdersproofing_print_card: TStringField;
    uqOrdersproofing_wide_format: TStringField;
    uqOrdersproofing_pdf_file: TStringField;
    uqOrdersproofing_other: TStringField;
    uqOrdersproofing_art_approved_as_is: TStringField;
    uqOrdersproofing_approved_date: TDateField;
    uqOrdersproofing_changes_required: TStringField;
    uqOrdersproofing_changes_date: TDateField;
    uqOrderslayout_rsc_l: TStringField;
    uqOrderslayout_rcs_w: TStringField;
    uqOrderslayout_rcs_d: TStringField;
    uqOrderslayout_die_cut_no: TStringField;
    uqOrderslayout_accross_no: TStringField;
    uqOrderslayout_around_no: TStringField;
    uqOrderslayout_cad_file: TStringField;
    uqOrderslayout_excalibur_die: TStringField;
    uqOrdersmounting_loose: TStringField;
    uqOrdersmounting_sticky_bak: TStringField;
    uqOrdersmounting_full_mount: TStringField;
    uqOrdersmounting_strip_mount: TStringField;
    uqOrderscolors_cylinder_size: TStringField;
    uqOrderscolors_machine_ident: TStringField;
    uqOrdersmounting_standard_setup: TStringField;
    uqOrdersmounting_custom_backing: TStringField;
    uqOrdersmounting_custom_adhesive: TStringField;
    uqOrderscolors_cross_hairs: TStringField;
    uqOrderscolors_clemson: TStringField;
    uqOrdersplates_thickness: TStringField;
    uqOrdersplates_plate_material: TStringField;
    uqOrdersgeneral_special_instructions: TStringField;
    uqOrderscolors_colors: TStringField;
    uqOrdersstaff_fields_quickbooks_item: TStringField;
    uqOrdersstaff_fields_quantity: TStringField;
    uqOrderslayout_rsc_style: TStringField;
    uqOrdersstaff_fields_art_location: TStringField;
    uqOrdersStatusSchedule: TUniQuery;
    uqOrdersStatusScheduleORDERS_STATUS_SCHEDULE_ID: TLongWordField;
    uqOrdersStatusScheduleORDER_ID: TLongWordField;
    uqOrdersStatusScheduleORDER_STATUS: TStringField;
    uqOrdersStatusScheduleSTATUS_DATE: TDateField;
    uqOrdersStatusScheduleORIGINAL_STATUS_DATE: TDateField;
    uqOrdersStatusScheduleUSER_ID: TLongWordField;
    uqOrdersStatusScheduleORDER_REVISION: TLongWordField;
    uqUsers: TUniQuery;
    uqUsersUSER_ID: TIntegerField;
    uqUsersNAME: TStringField;
    uqUsersSTATUS: TStringField;
    uqUsersREPRESENTATIVE: TStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure uqUsersCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    class procedure ExecSQL(const SQL: string);
  end;

var
  ApiDatabase: TApiDatabase;

implementation

uses
  uLibrary;
{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TApiDatabase.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 1, 'TApiDatabase.DataModuleCreate' );
  LoadDatabaseSettings( ucKG, 'kgOrdersServer.ini' );
  try
    ucKG.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TApiDatabase.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;

class procedure TApiDatabase.ExecSQL(const SQL: string);
var
  DB: TApiDatabase;
begin
  DB := TApiDatabase.Create(nil);
  try
    DB.UniQuery1.SQL.Text := SQL;
    DB.UniQuery1.ExecSQL;
  finally
    DB.Free;
  end;
end;

procedure TApiDatabase.uqUsersCalcFields(DataSet: TDataSet);
begin
  uqUsersREPRESENTATIVE.AsString := uqUsersNAME.AsString + '(' + uqUsersSTATUS.AsString + ')';
end;

end.
