// Lookup Service interface which retrieves information from the database
// which is then sent to the client.
// Authors:
// Cameron Hayes
// Mac ...
// Elias Sarraf

unit Lookup.Service;

interface

uses
  XData.Service.Common,
  Aurelius.Mapping.Attributes,
  System.JSON,
  System.Generics.Collections,
  System.Classes;

const
  API_MODEL = 'Api';

type

  TUserItem = class
  public
    userID: string;
    username: string;
    password: string;
    full_name: string;
    status: string;
    email_address: string;
    Atype: string;
    rights: integer;
    perspectiveID: string;
    QBID: string;
    representative: string;
  end;

  TUserList = class
  public
    count: integer;
    data: TList<TUserItem>;
  end;

  TItemItem = class
  public
    ID: string;
    name: string;
    description: string;
    status: string;
    QB_ID: string;
  end;

  TItemList = class
  public
    count: integer;
    data: TList<TItemItem>;
  end;

  TOrderItem = class
  public
    DBID,
    IN_QB,
    ID,
    companyName,
    jobName,
    orderDate,
    proofDue,
    proofDone,
    artDue,
    artDone,
    plateDue,
    plateDone,
    mountDue,
    mountDone,
    shipDue,
    shipDone,
    price,
    qbRefNum,
    orderType,
    colors,
    cadFile: string;

  end;

  TStatusSearchInfo = class
  Public
    startDate,
    endDate,
    filterType,
    statusType,
    statusSuffix,
    statusTableShort,
    statusTableLong,
    altStatusTableShort,
    altStatusTableLong: string;
    null: boolean;
  end;


  TSQLQuery = class
  Public
    SQL,
    whereSQL: string;
  end;

  TOrderList = class
  Public
    count: integer;
    data: TList<TOrderItem>;
  end;

  TAddressItem = class
  Public
    ADDRESS: string;
    shipping_address: string;
    city: string;
    state: string;
    contact: string;
    zip: string;
    ship_id: string;
  end;

  TCustomerItem = class
  Public
    NAME: string;
    CUSTOMER_ID: integer;
    SHORT_NAME: string;
    BILL_ADDRESS: string;
    BILL_CITY: string;
    BILL_STATE: string;
    BILL_ZIP: string;
    BILL_CONTACT: string;
    PHONE: string;
    staff_fields_invoice_to: string;
    START_DATE: String;
    END_DATE: string;
    QB_LIST_ID: string;
    FFAX: string;
    REP_USER_ID: string;
    SHIPPING_ADDRESS_LIST: TList<TAddressItem>;
    REP_USERS: TList<TUserItem>;
  end;

  TCustomerList = class
  Public
    count: integer;
    data: TList<TCustomerItem>;
  end;

  TCorrugatedOrder = class
  Public
    //Company
    ORDER_ID: integer;
    COMPANY_ID: integer;
    NAME: string;
    SHORT_NAME: string;
    IN_QB: string;
    QB_ORDER_NUM: string;

    // Staff Fields:
    staff_fields_order_date: string;
    staff_fields_proof_date: string;
    staff_fields_ship_date: string;
    staff_fields_ship_via: string;
    staff_fields_quantity: string;
    staff_fields_price: string;
    staff_fields_invoice_to: string;
    staff_fields_ship_to: string;
    staff_fields_po_number: string;
    staff_fields_job_name: string;
    staff_fields_quickbooks_item: string;
    staff_fields_art_due: string;
    staff_fields_plate_due: string;
    staff_fields_mount_due: string;
    staff_fields_art_location: string;

    // Supplied by Customer:
    supplied_by_customer_color_copy: string;
    supplied_by_customer_plates: string;
    supplied_by_customer_sample_ca: string;
    supplied_by_customer_dimension: string;
    supplied_by_customer_e_mail: string;
    supplied_by_customer_ftp: string;
    supplied_by_customer_other: string;
    supplied_by_customer_existing_: string;
    supplied_by_customer_ref_art_p: string;
    supplied_by_customer_ref_art_a: string;

    // Layout
    layout_rsc_l: string;

    //Typos to match database typos
    layout_rcs_w: string;
    layout_rcs_d: string;

    layout_die_cut_no: string;
    layout_accross_no: string;
    layout_around_no: string;
    layout_cad_file: string;
    layout_excalibur_die: string;
    layout_rsc_style: string;

    // Mounting
    mounting_loose: string;
    mounting_sticky_bak: string;
    mounting_full_mount: string;
    mounting_strip_mount: string;
    mounting_standard_setup: string;
    mounting_custom_backing: string;
    mounting_custom_adhesive: string;

    // Colors
    colors_cylinder_size: string;
    colors_machine_ident: string;
    colors_cross_hairs: string;
    colors_clemson: string;
    colors_colors: string;

    // Proofing
    proofing_fax: string;
    proofing_fax_attn: string;
    proofing_e_mail: string;
    proofing_e_mail_attn: string;
    proofing_ship_to: string;
    proofing_full_size_panel: string;
    proofing_print_card: string;
    proofing_wide_format: string;
    proofing_pdf_file: string;
    proofing_other: string;
    proofing_art_approved_as_is: string;
    proofing_approved_date: string;

    // Plates
    plates_thickness: string;
    plates_plate_material: string;
    plates_job_number: string;

    // General
    general_special_instructions: string;
  end;

  TWebOrder = class
  Public
    //Company
    ORDER_ID: integer;
    COMPANY_ID: integer;
    NAME: string;
    SHORT_NAME: string;
    IN_QB: string;
    QB_ORDER_NUM: string;

    // Staff Fields:
    staff_fields_order_date: string;
    staff_fields_proof_date: string;
    staff_fields_ship_date: string;
    staff_fields_ship_via: string;
    staff_fields_quantity: string;
    staff_fields_price: string;
    staff_fields_invoice_to: string;
    staff_fields_ship_to: string;
    staff_fields_po_number: string;
    staff_fields_job_name: string;
    staff_fields_quickbooks_item: string;
    staff_fields_art_due: string;
    staff_fields_plate_due: string;
    staff_fields_mount_due: string;
    staff_fields_art_location: string;

    // Supplied by Customer:
    supplied_by_customer_b_w_or_co: string;
    supplied_by_customer_plates: string;
    supplied_by_customer_sample: string;
    supplied_by_customer_dimension: string;
    supplied_by_customer_other: string;
    supplied_by_customer_disk: string;
    supplied_by_customer_e_mail: string;
    supplied_by_customer_ftp: string;
    supplied_by_customer_total_inc: string;
    supplied_by_customer_sheets_us: string;
    supplied_by_customer_initials: string;

    // Proofing
    proofing_pdf: string;
    proofing_pdf_to: string;
    proofing_pdf_date_1: string;
    proofing_pdf_date_2: string;
    proofing_pdf_date_3: string;
    proofing_full_size_ink_jet_for: string;
    proofing_ink_jet_to: string;
    proofing_ink_jet_to_2: string;
    proofing_ink_jet_date_1: string;
    proofing_ink_jet_date_2: string;
    proofing_color_contract: string;
    proofing_color_contrac_to: string;
    proofing_color_contrac_date_1: string;
    proofing_color_contrac_date_2: string;
    proofing_digital_color_key: string;
    proofing_digital_color_to: string;
    proofing_digital_color_date_1: string;

    // Print Orientation
    print_orientation_print_orient: string;

    // Plate
    plates_plate_material: string;
    plates_thickness: string;
    plates_job_number: string;

    // Quantity and Color
    quantity_and_colors_press_name: string;
    quantity_and_colors_anilox_info: string;
    quantity_and_colors_qty_colors: string;

    // Plate Marks

    plate_marks_microdots: string;
    plate_marks_microdots_comments: string;
    plate_marks_crosshairs: string;
    plate_marks_crosshairs_comments: string;
    plate_marks_color_bars: string;
    plate_marks_color_bars_comments: string;
    plate_marks_other: string;
    plate_marks_other_comments: string;

    // Layout
    layout_around: string;
    layout_accross: string;
    layout_surface_print: string;

    layout_reverse_print: string;
    layout_cylinder_repeat: string;
    layout_cutoff_dimension: string;
    layout_pitch: string;
    layout_teeth: string;
    layout_bleed: string;
    layout_cutback: string;
    layout_minimum_trap_dim: string;
    layout_maximum_trap_dim: string;

    // UPC
    upc_size: string;
    upc_bar_width_reduction: string;
    upc_distortion_percent: string;
    upc_distortion_amount: string;

    // General
    general_comments: string;
  end;

  TCuttingDie = class
  public
    // Company
    ORDER_ID: integer;
    COMPANY_ID: integer;
    NAME: string;
    SHORT_NAME: string;
    IN_QB: string;
    QB_ORDER_NUM: string;

    // Staff Fields:
    staff_fields_order_date: string;
    staff_fields_proof_date: string;
    staff_fields_ship_date: string;
    staff_fields_ship_via: string;
    staff_fields_quantity: string;
    staff_fields_price: string;
    staff_fields_invoice_to: string;
    staff_fields_ship_to: string;
    staff_fields_po_number: string;
    staff_fields_job_name: string;
    staff_fields_quickbooks_item: string;

    // General
    general_special_instructions: string;
  end;

  // These objects are only used for quickbooks estimates.
  TRef = record
    value: string;
    name: string; // optional
  end;

  TCustomerMemo = record
    value: string;
  end;

  TAddress = record
    Line1: string;
    Line2: string; // optional
    Line3: string; // optional
    Line4: string; //optional
    Line5: string; //optional
    City: string;
    CountrySubDivisionCode: string;
    PostalCode: string;
    Country: string; // optional
  end;

  TTaxCodeRef = record
    value: string;
  end;

  TClassRef = record
    value: string;
  end;

  TSalesItemLineDetail = record
    ItemRef: TRef;
    Qty: Double;
    UnitPrice: Double;
    TaxCodeRef: TTaxCodeRef; // optional
    ClassRef: TClassRef;     // optional
    ServiceDate: string;     // optional
  end;

  TLine = record
    Id: string;              // optional (auto-generated if omitted)
    LineNum: Integer;        // optional
    Description: string;     // optional
    Amount: Double;
    DetailType: string;
    SalesItemLineDetail: TSalesItemLineDetail;
  end;

  TCustomField = record
    DefinitionId: string;
    Name: string;
    Type_: string;
    StringValue: string;
  end;

  TTxnTaxCodeRef = record
    value: string;
  end;

  TTxnTaxDetail = record
    TxnTaxCodeRef: TTxnTaxCodeRef;
    TotalTax: Double;
  end;

  TEmail = record
    Address: string;
  end;

  TEstimate = record
    DocNumber: string;              // optional
    TxnDate: string;
    PrivateNote: string;           // optional
    CustomerRef: TRef;
    CustomerMemo: TCustomerMemo;   // optional
    BillAddr: TAddress;            // optional
    ShipAddr: TAddress;            // optional
    ShipMethodRef: TRef;           // optional
    SalesTermRef: TRef;            // optional
    DueDate: string;               // optional
    ClassRef: TRef;                // optional
    DepartmentRef: TRef;           // optional
    CurrencyRef: TRef;             // optional
    ExchangeRate: Double;          // optional
    EmailStatus: string;           // optional
    BillEmail: TEmail;             // optional
    ShipDate: string;              // optional
    TrackingNum: string;           // optional
    CustomerMsgRef: TRef;          // optional
    CustomField: TArray<TCustomField>; // optional
    Line: TArray<TLine>;
    TxnTaxDetail: TTxnTaxDetail;   // optional
  end;

type
  [ServiceContract, Model(API_MODEL)]
  ILookupService = interface(IInvokable)
    ['{F24E1468-5279-401F-A877-CD48B44F4416}']
    [HttpGet] function GetUsers(searchOptions: string): TUserList;
    [HttpGet] function GetItems(searchOptions: string): TItemList;
    [HttpGet] function GetOrders(searchOptions: string): TOrderList;
    [HttpGet] function GetCorrugatedOrder(orderInfo: string): TCorrugatedOrder;
    [HttpGet] function GetWebOrder(orderInfo: string): TWebOrder;
    [HttpGet] function GetCuttingDieOrder(orderInfo: string): TCuttingDie;
    [HttpGet] function GetCustomers(customerInfo: string): TCustomerList;
    [HttpGet] function GetCustomer(ID: string): TCustomerItem;
    [HttpGet] function GenerateOrderListPDF(searchOptions: string): string;
    [HttpGet] function GenerateOrderCorrugatedPDF(orderID: string): string;
    [HttpGet] function GenerateOrderWebPDF(orderID: string): string;
    [HttpGet] function GenerateOrderCuttingPDF(orderID: string): string;
    [HttpGet] function getQBCustomers(): TJSONArray;
    [HttpGet] function getQBItems(): TJSONArray;
    [HttpGet] function GetRepUsers(): TList<TUserItem>;


    function AddUser(userInfo: string): string;
    function AddItem(itemInfo: string): TJSONObject;
    function AddShippingAddress(Addressinfo: string): TJSONObject;
    function DelShippingAddress(AddressID, CustomerID: string): TJSONObject;
    function DelUser(username: string): string;
    function DelOrder(orderID, orderType, UserID: string): TJSONObject;
    function EditUser(const editOptions: string): string;
    function AddCorrugatedOrder(orderInfo: string): TJSONObject;
    function AddWebOrder(orderInfo: string): TJSONObject;
    function AddCuttingDieOrder(orderInfo: string): TJSONObject;
    function AddStatusSchedule(StatusType: string; order: TJSONObject; ORDER_ID: integer): string;
    function SetStatus(statusOptions: string): string;
    function AddCustomer(customerInfo: string): TJSONObject;
    function ImportQBCustomer(CustomerInfo: string): TJSONObject;
    function AddEstimate(orderInfo: string): TJSONObject;
  end;

implementation

initialization
  RegisterServiceType(TypeInfo(ILookupService));


end.

