unit View.UserProfile;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls, Vcl.StdCtrls, WEBLib.StdCtrls,
  XData.Web.Client, WEBLib.ExtCtrls, DB, XData.Web.JsonDataset,
  XData.Web.Dataset, XData.Web.Connection, Vcl.Forms, ConnectionModule,
  WEBLib.Toast, WEBLib.DBCtrls;

type
  TFViewUserProfile = class(TWebForm)
    WebLabel1: TWebLabel;
    WebLabel3: TWebLabel;
    WebLabel2: TWebLabel;
    WebLabel4: TWebLabel;
    WebLabel5: TWebLabel;
    XDataWebClient1: TXDataWebClient;
    WebDBEdit1: TWebDBEdit;
    WebDBEdit2: TWebDBEdit;
    WebDBEdit3: TWebDBEdit;
    WebDBEdit4: TWebDBEdit;
    WebDBEdit5: TWebDBEdit;
    WebDBEdit6: TWebDBEdit;
    WebLabel6: TWebLabel;
    WebLabel7: TWebLabel;
    xdwdsUser: TXDataWebDataSet;
    wdsUser: TWebDataSource;
    xdwdsUseruserID: TStringField;
    xdwdsUserusername: TStringField;
    xdwdsUseremail_address: TStringField;
    xdwdsUserQBID: TStringField;
    xdwdsUserAType: TStringField;
    xdwdsUserfull_name: TStringField;
    procedure WebFormShow(Sender: TObject);
    [async] procedure GetUser();
  end;

var
  FViewUserProfile: TFViewUserProfile;

implementation

uses
  Auth.Service,
  XData.Model.Classes,
  Utils,
  View.Main;

{$R *.dfm}


procedure TFViewUserProfile.WebFormShow(Sender: TObject);
begin
  GetUser();
end;


procedure TFViewUserProfile.GetUser;
var
  xdcResponse: TXDataClientResponse;
  userList: TJSObject;
  data: TJSArray;
  user: TJSObject;
begin
  try
    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetUsers',
          [JS.toString(AuthService.TokenPayload.Properties['user_name'])]));
    userList :=  TJSObject(xdcResponse.Result);
    data := TJSArray(userList['data']);
    user := TJSObject(data[0]);
    console.log(user);
    xdwdsUser.SetJsonData(user);
    xdwdsUser.Open;
  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
end;


end.
