// Auth Database to verify logins

unit Auth.Database;

interface

uses
  System.SysUtils, System.Classes, IniFiles, Vcl.Forms, MemDS,
  Data.DB, DBAccess, Uni, UniProvider, PostgreSQLUniProvider, MySQLUniProvider;

type
  TAuthDatabase = class(TDataModule)
    uq: TUniQuery;
    uqMisc: TUniQuery;
    ucKG: TUniConnection;
    MySQLUniProvider1: TMySQLUniProvider;
    uqUSER_ID: TIntegerField;
    uqUSER_NAME: TStringField;
    uqPASSWORD: TStringField;
    uqNAME: TStringField;
    uqSTATUS: TStringField;
    uqEMAIL: TStringField;
    uqACCESS_TYPE: TStringField;
    uqSYSTEM_RIGHTS: TIntegerField;
    uqPERSPECTIVE_ID: TStringField;
    uqQB_ID: TStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AuthDatabase: TAuthDatabase;

implementation

uses
  System.JSON,
  Common.Config,
  Common.Logging,
  uLibrary;

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TAuthDatabase.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 1, 'TAuthDatabase.DataModuleCreate' );
  LoadDatabaseSettings( ucKG, 'kgOrdersServer.ini' );
  try
    ucKG.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TAuthDatabase.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;

procedure TAuthDatabase.DataModuleDestroy(Sender: TObject);
begin
  ucKG.Connected := false;
end;


end.
