unit View.OrderEntryWeb;

interface

uses
  System.SysUtils, System.Generics.Collections, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, WEBLib.Menus, WEBLib.ExtCtrls, WEBLib.StdCtrls,
  WEBLib.JSON, Auth.Service, XData.Web.Client, WebLib.Storage,
  ConnectionModule, App.Types, Vcl.StdCtrls, Vcl.Controls, WEBLib.DBCtrls,
  Data.DB, XData.Web.JsonDataset, XData.Web.Dataset, WEBLib.DB, VCL.Forms;

type
  TFOrderEntryWeb = class(TWebForm)
    WebLabel2: TWebLabel;
    edtCompanyName: TWebDBEdit;
    edtCompanyAccountName: TWebDBEdit;
    XDataWebClient1: TXDataWebClient;
    xdwdsOrder: TXDataWebDataSet;
    xdwdsOrderORDER_ID: TIntegerField;
    xdwdsOrderCOMPANY_ID: TIntegerField;
    xdwdsOrderUSER_ID: TIntegerField;
    xdwdsOrderORDER_DATE: TDateField;
    xdwdsOrderNAME: TStringField;
    xdwdsOrderSHORT_NAME: TStringField;
    xdwdsOrderstaff_fields_ship_via: TStringField;
    xdwdsOrderstaff_fields_price: TStringField;
    xdwdsOrderstaff_fields_invoice_to: TStringField;
    xdwdsOrderstaff_fields_invoice_attention: TStringField;
    xdwdsOrderstaff_fields_ship_to: TStringField;
    xdwdsOrderstaff_fields_ship_attention: TStringField;
    xdwdsOrderstaff_fields_po_number: TStringField;
    xdwdsOrderstaff_fields_job_name: TStringField;
    xdwdsOrderstaff_fields_quickbooks_item: TStringField;
    xdwdsOrderstaff_fields_quantity: TStringField;
    xdwdsOrderstaff_fields_art_location: TStringField;
    xdwdsOrderstaff_fields_order_date: TStringField;
    xdwdsOrderstaff_fields_proof_date: TStringField;
    xdwdsOrderstaff_fields_ship_date: TStringField;
    xdwdsOrderstaff_fields_art_due: TStringField;
    xdwdsOrderstaff_fields_plate_due: TStringField;
    xdwdsOrderADDRESS_LIST: TStringField;
    wdsOrder: TWebDataSource;
    WebLabel1: TWebLabel;
    edtShipVia: TWebDBEdit;
    edtQuantity: TWebDBEdit;
    edtPrice: TWebDBEdit;
    edtInvoiceTo: TWebDBEdit;
    edtPONumber: TWebDBEdit;
    edtJobName: TWebDBEdit;
    wdbcbShipTo: TWebDBComboBox;
    wdsShipTo: TWebDataSource;
    xdwdsShipTo: TXDataWebDataSet;
    xdwdsShipToADDRESS: TStringField;
    WebLabel3: TWebLabel;
    edtBWorColorCopy: TWebDBEdit;
    edtPlates: TWebDBEdit;
    edtDimensionalLayout: TWebDBEdit;
    edtSample: TWebDBEdit;
    edtOther: TWebDBEdit;
    edtEmail: TWebDBEdit;
    edtTotalInchesUsed: TWebDBEdit;
    edtFTP: TWebDBEdit;
    edtSheetsUsed: TWebDBEdit;
    edtInitials: TWebDBEdit;
    WebLabel4: TWebLabel;
    cbPDF: TWebDBCheckBox;
    edtPDFTo: TWebDBEdit;
    cbInkJet: TWebDBCheckBox;
    edtInkJetTo2: TWebDBEdit;
    edtInkJetTo1: TWebDBEdit;
    edtColorContrastTo: TWebDBEdit;
    edtDigitalColorTo: TWebDBEdit;
    edtDigitalColorKey: TWebDBEdit;
    WebLabel5: TWebLabel;
    edtAniloxInfo: TWebDBEdit;
    edtPressName: TWebDBEdit;
    WebButton1: TWebButton;
    WebLabel6: TWebLabel;
    edtMicroDots: TWebDBEdit;
    edtMicrodotsComments: TWebDBEdit;
    edtCrosshairsComments: TWebDBEdit;
    edtCrosshairs: TWebDBEdit;
    edtColorBarsComments: TWebDBEdit;
    edtColorBars: TWebDBEdit;
    edtPlateOther: TWebDBEdit;
    edtPlateOtherComments: TWebDBEdit;
    WebLabel7: TWebLabel;
    WebLabel8: TWebLabel;
    edtAround: TWebDBEdit;
    edtAccross: TWebDBEdit;
    edtReversePrint: TWebDBEdit;
    edtSurfacePrint: TWebDBEdit;
    edtCutoffDimension: TWebDBEdit;
    edtCylinderRepeat: TWebDBEdit;
    edtPitch: TWebDBEdit;
    edtBleed: TWebDBEdit;
    edtTeeth: TWebDBEdit;
    edtCutback: TWebDBEdit;
    edtMinimumTrapDim: TWebDBEdit;
    edtMaximumTrapDim: TWebDBEdit;
    WebLabel9: TWebLabel;
    edtSize: TWebDBEdit;
    edtBarWidthReduction: TWebDBEdit;
    edtDistortionAmount: TWebDBEdit;
    edtDistortionPercent: TWebDBEdit;
    WebLabel10: TWebLabel;
    edtJobNumber: TWebDBEdit;
    WebLabel11: TWebLabel;
    Comments: TWebDBEdit;
    btnSave: TWebButton;
    btnPDF: TWebButton;
    btnCancel: TWebButton;
    xdwdsOrderplates_job_number: TStringField;
    xdwdsOrdersupplied_by_customer_plates: TStringField;
    xdwdsOrdersupplied_by_customer_sample: TStringField;
    xdwdsOrdersupplied_by_customer_dimension: TStringField;
    xdwdsOrdersupplied_by_customer_other: TStringField;
    xdwdsOrdersupplied_by_customer_disk: TStringField;
    xdwdsOrdersupplied_by_customer_e_mail: TStringField;
    xdwdsOrdersupplied_by_customer_ftp: TStringField;
    xdwdsOrderplates_plate_material: TStringField;
    xdwdsOrderplates_thickness: TStringField;
    xdwdsOrdersupplied_by_customer_total_inc: TStringField;
    xdwdsOrdersupplied_by_customer_sheets_us: TStringField;
    xdwdsOrdersupplied_by_customer_initials: TStringField;
    xdwdsOrderproofing_pdf_to: TStringField;
    xdwdsOrderproofing_pdf_date_1: TStringField;
    xdwdsOrderproofing_pdf_date_2: TStringField;
    xdwdsOrderproofing_pdf_date_3: TStringField;
    xdwdsOrderproofing_ink_jet_to: TStringField;
    xdwdsOrderproofing_ink_jet_to_2: TStringField;
    xdwdsOrderproofing_ink_jet_date_1: TStringField;
    xdwdsOrderproofing_ink_jet_date_2: TStringField;
    xdwdsOrderproofing_ink_jet_date_3: TStringField;
    xdwdsOrderproofing_color_contract: TStringField;
    xdwdsOrderproofing_color_contrac_to: TStringField;
    xdwdsOrderproofing_color_contrac_date_1: TStringField;
    xdwdsOrderproofing_color_contrac_date_2: TStringField;
    xdwdsOrderproofing_digital_color_key: TStringField;
    xdwdsOrderproofing_digital_color_to: TStringField;
    xdwdsOrderproofing_digital_color_date_1: TStringField;
    xdwdsOrderquantity_and_colors_press_name: TStringField;
    xdwdsOrderquantity_and_colors_anilox_info: TStringField;
    xdwdsOrderplate_marks_microdots_comments: TStringField;
    xdwdsOrderplate_marks_microdots: TStringField;
    xdwdsOrderplate_marks_crosshairs: TStringField;
    xdwdsOrderplate_marks_crosshairs_comments: TStringField;
    xdwdsOrderplate_marks_color_bars: TStringField;
    xdwdsOrderplate_marks_color_bars_comments: TStringField;
    xdwdsOrderplate_marks_other: TStringField;
    xdwdsOrderplate_marks_other_comments: TStringField;
    xdwdsOrderprint_orientation_print_orient: TStringField;
    xdwdsOrderlayout_around: TStringField;
    xdwdsOrderlayout_accross: TStringField;
    xdwdsOrderlayout_surface_print: TStringField;
    xdwdsOrderlayout_reverse_print: TStringField;
    xdwdsOrderlayout_cylinder_repeat: TStringField;
    xdwdsOrderlayout_cutoff_dimension: TStringField;
    xdwdsOrderlayout_pitch: TStringField;
    xdwdsOrderlayout_teeth: TStringField;
    xdwdsOrderlayout_bleed: TStringField;
    xdwdsOrderlayout_minimum_trap_dim: TStringField;
    xdwdsOrderlayout_maximum_trap_dim: TStringField;
    xdwdsOrderupc_size: TStringField;
    xdwdsOrderupc_bar_width_reduction: TStringField;
    xdwdsOrdergeneral_comments: TStringField;
    xdwdsOrderupc_distortion_percent: TStringField;
    xdwdsOrderupc_distortion_amount: TStringField;
    xdwdsOrderlayout_cutback: TStringField;
    xdwdsOrderquantity_and_colors_qty_colors: TStringField;
    xdwdsOrdersupplied_by_customer_b_w_or_co: TStringField;
    wdsQBItem: TWebDataSource;
    xdwdsQBItem: TXDataWebDataSet;
    xdwdsQBItemname: TStringField;
    WebDBComboBox2: TWebDBComboBox;
    WebDBComboBox3: TWebDBComboBox;
    wcbPrint: TWebDBComboBox;
    WebDBComboBox4: TWebDBComboBox;
    btnCopy: TWebButton;
    btnDelete: TWebButton;
    btnClose: TWebButton;
    tmrReturn: TWebTimer;
    btnEdit: TWebButton;
    btnAdd: TWebButton;
    WebButton2: TWebButton;
    lblFormState: TWebLabel;
    dtpOrderDate: TWebDBDateTimePicker;
    dtpProofDate: TWebDBDateTimePicker;
    dtpShipDate: TWebDBDateTimePicker;
    dtpPlateDue: TWebDBDateTimePicker;
    dtpPDFDate3: TWebDBDateTimePicker;
    dtpPDFDate2: TWebDBDateTimePicker;
    dtpPDFDate1: TWebDBDateTimePicker;
    dtpInkJetDate3: TWebDBDateTimePicker;
    dtpInkJetDate2: TWebDBDateTimePicker;
    dtpInkJetDate1: TWebDBDateTimePicker;
    dtpColorContractDate2: TWebDBDateTimePicker;
    dtpColorContractDate1: TWebDBDateTimePicker;
    dtpDigitalColorDate: TWebDBDateTimePicker;
    xdwdsOrderproofing_full_size_ink_jet_for: TStringField;
    xdwdsOrderproofing_pdf: TStringField;
    edtQBOrderNum: TWebDBEdit;
    wdbcbINQB: TWebDBCheckBox;
    xdwdsOrderIN_QB: TStringField;
    xdwdsOrderQB_ORDER_NUM: TStringField;
    edtQBItemDescription: TWebEdit;
    xdwdsQBItemQB_ID: TStringField;
    xdwdsQBItemdescription: TStringField;
    edtOrderNum: TWebDBEdit;
    wcbQBItem: TWebDBComboBox;
    xdwdsQBItemID: TStringField;
    btnQB: TWebButton;
    dtpArtDue: TWebDBDateTimePicker;
    procedure WebFormCreate(Sender: TObject);
    [async] procedure getOrder(Order_ID: string);
    [async] procedure SetNewOrderInfo(customerID: string);
    procedure WebButton1Click(Sender: TObject);
    procedure addColorRow(num, Color, LPI, Size: string);
    procedure btnSaveClick(Sender: TObject);
    [async] procedure SendWebOrder();
    procedure btnCancelClick(Sender: TObject);
    procedure btnPDFClick(Sender: TObject);
    [async] procedure GenerateReportPDF;
    procedure btnCopyClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    [async] procedure DelOrder;
    procedure tmrReturnTimer(Sender: TObject);
    function VerifyOrder(): boolean;
    procedure btnAddClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure EditMode();
    procedure ViewMode();
    procedure WebButton2Click(Sender: TObject);
    procedure ShowAddAddressForm();
    [async] procedure SendAddressToServer(AddressJSON: TJSONObject);
    procedure wcbQBItemChange(Sender: TObject);
    procedure edtJobNameExit(Sender: TObject);
    procedure btnQBClick(Sender: TObject);
    function VerifyQBOrder: Boolean;
    [async] procedure AddEstimate(orderID: string);
  private
    FModalAction: string;
    FAgencyCode: string;
    FCurrentReportType: string;
    FSelectProc: TSelectProc;
    orderID: string;
    customerID: string;
    mode: string;
    notification: string;
    customer_qb_id: string;
    REVISION_NOTES: string;
    procedure RemoveColorRow(Sender: TObject);
    [async] procedure InitializeForm;
    //FJSONProc1: TJSONProc1;
  public
    class function CreateForm(AElementID, orderInfo, customerInfo, modeParam, info: string): TWebForm;
  end;

var
  FOrderEntryWeb: TFOrderEntryWeb;

implementation

{$R *.dfm}

uses
  View.Home, View.Main, View.AddOrder, View.AddAddress, Utils;


class function TFOrderEntryWeb.CreateForm(AElementID, orderInfo, customerInfo, modeParam, info: string): TWebForm;
begin
  Application.CreateForm(TFOrderEntryWeb, AElementID, Result,
    procedure(AForm: TObject)
    begin
      with TFOrderEntryWeb(AForm) do
      begin
        customerID := customerInfo;
        orderID := orderInfo;
        mode := modeParam;
        notification := info;
        console.log('Mode in createform: ' + modeParam);

        InitializeForm;
      end;
    end
  );
end;


[async] procedure TFOrderEntryWeb.InitializeForm;
begin
  if mode = 'ADD' then
  begin
    await(SetNewOrderInfo(customerID));
    EditMode;
  end
  else
  begin
    await(getOrder(orderID));
    ViewMode;
  end;

  edtOrderNum.Text := orderID;
  if notification <> '' then
    ShowToast(notification);
end;


procedure TFOrderEntryWeb.WebButton2Click(Sender: TObject);
begin
  ShowAddAddressForm();
end;

procedure TFOrderEntryWeb.SendAddressToServer(AddressJSON: TJSONObject);
var
  Response: TXDataClientResponse;
  notification: TJSObject;
begin
  Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.AddShippingAddress',
              [AddressJSON.ToString]));

  notification := TJSObject(Response.Result);
  ShowToast(string(notification['status']));
  xdwdsShipTo.Close;
  xdwdsShipTo.SetJSONData(notification['ADDRESS']);
  xdwdsShipTo.Open;
end;

procedure TFOrderEntryWeb.ShowAddAddressForm;
// displays the search pop-up that allows the user to filter the order list
var
  newform: TFViewAddAddress;
  AddressJSON: TJSONObject;
  ship_block: string;
begin
  newform := TFViewAddAddress.CreateNew;

  newform.Caption := 'Input Shipping Information';
  newForm.Popup := True;
  newForm.Border := fbDialog;
  newForm.Position := poScreenCenter;

  // used to manage Back button handling to close subform
  window.location.hash := 'subform';

  newform.ShowModal(
    procedure(AValue: TModalResult)
    var
      searchOptions: string;
    begin
      if newform.confirm then
      begin
        AddressJSON := TJSONObject.Create;

        AddressJSON.AddPair('address', newform.edtAddress.Text);
        AddressJSON.AddPair('city', newform.edtCity.Text);
        AddressJSON.AddPair('state', newform.edtState.Text);
        AddressJSON.AddPair('zip', newform.edtZip.Text);
        AddressJSON.AddPair('contact', newform.edtContact.Text);
        AddressJSON.AddPair('customer_id', customerID);

        ship_block := newform.edtFirstLine.Text + slinebreak +
                      edtCompanyName.Text + slinebreak +
                      newform.edtContact.Text + slinebreak +
                      newform.edtAddress.Text + slinebreak +
                      newform.edtCity.Text + ', ' + newform.edtState.Text + ' ' + newform.edtZip.Text;
        AddressJSON.AddPair('ship_block', ship_block);

        AddressJSON.AddPair('mode', 'ADD');
        sendAddressToServer(AddressJSON);
      end;
    end
  );
end;

procedure TFOrderEntryWeb.btnSaveClick(Sender: TObject);
begin
  if VerifyOrder() then
  begin
    sendWebOrder();
    ViewMode();
  end;
  window.scrollTo(0, 0);
end;

procedure TFOrderEntryWeb.btnCopyClick(Sender: TObject);
begin
  mode := 'ADD';
  xdwdsOrder.Edit;
  xdwdsOrder.FieldByName('staff_fields_order_date').AsDateTime := 0;
  xdwdsOrder.FieldByName('staff_fields_proof_date').AsDateTime := 0;
  xdwdsOrder.FieldByName('staff_fields_art_due').AsDateTime := 0;
  xdwdsOrder.FieldByName('staff_fields_plate_due').AsDateTime := 0;
  xdwdsOrder.FieldByName('staff_fields_ship_date').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_pdf_date_1').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_pdf_date_2').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_pdf_date_3').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_ink_jet_date_1').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_ink_jet_date_2').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_ink_jet_date_3').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_color_contrac_date_1').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_color_contrac_date_2').AsDateTime := 0;
  xdwdsOrder.FieldByName('proofing_digital_color_date_1').AsDateTime := 0;

  xdwdsOrder.FieldByName('IN_QB').AsString := 'F';
  xdwdsOrder.FieldByName('QB_ORDER_NUM').AsString := '';
  REVISION_NOTES := 'Order was copied from ORDER_ID: ' + xdwdsOrder.FieldByName('ORDER_ID').AsString;
  xdwdsOrder.FieldByName('ORDER_ID').AsString := '';
  xdwdsOrder.Post;
  EditMode();
  ShowToast('Success: Order Successfully Copied');
  window.scrollTo(0, 0);
end;


procedure TFOrderEntryWeb.btnDeleteClick(Sender: TObject);
begin
  ShowConfirmationModal(
    'Are you sure you want to delete this order?',
    'Delete',
    'Cancel',
    procedure(confirmed: Boolean)
    begin
      if confirmed then
      begin
        Utils.ShowSpinner('spinner');
        DelOrder();
        tmrReturn.Enabled := true;
      end;
    end
  );
end;

procedure TFOrderEntryWeb.btnEditClick(Sender: TObject);
begin
  EditMode();
end;


[async] procedure TFOrderEntryWeb.DelOrder();
var
  Response: TXDataClientResponse;
begin
  Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.DelOrder', [OrderID, 'web', JS.toString(AuthService.TokenPayload.Properties['user_id'])]));
end;

procedure TFOrderEntryWeb.btnPDFClick(Sender: TObject);
begin
  GenerateReportPDF;
end;

procedure TFOrderEntryWeb.btnQBClick(Sender: TObject);
var
  orderJSON: TJSONObject;
begin
  if JS.toString(AuthService.TokenPayload.Properties['user_qb_id']) <> '' then
  begin
    if ( VerifyQBOrder() )then
    begin
      if wdbcbINQB.Checked = false  then
      begin
          Utils.ShowSpinner('spinner');
          orderJSON := TJSONObject.Create;
          orderJSON.AddPair('ORDER_ID', xdwdsOrder.FieldByName('ORDER_ID').AsString);
          orderJSON.AddPair('USER_ID', JS.toString(AuthService.TokenPayload.Properties['user_id']));
          addEstimate(orderJSON.ToString);
      end
      else
        ShowToast('Failure:Cannot submit orders already in QuickBooks', 'failure');
    end;
  end
  else
    ShowToast('Failure:User not authorized to add to QuickBooks', 'failure');
end;

procedure TFOrderEntryWeb.AddEstimate(orderID: string);
var
  Response: TXDataClientResponse;
  notification: TJSObject;
  msg: string;
begin
  try
    Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.AddEstimate',
                [orderID]));
    notification := TJSObject(Response.Result);
    msg := string(notification['status']);
    Utils.HideSpinner('spinner');
    getOrder(xdwdsOrder.FieldByName('ORDER_ID').AsString);

    ShowToast(msg);
  except
      on E: EXDataClientRequestException do
        Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
    end;
end;

procedure TFOrderEntryWeb.GenerateReportPDF;
// sends the search to the server which then sends back a pdf of the results
var
  xdcResponse: TXDataClientResponse;
  searchOptions, pdfURL: string;
  jsObject: TJSObject;
begin
  try
    // Call the server method to generate the PDF
    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GenerateOrderWebPDF', [xdwdsOrder.FieldByName('ORDER_ID').AsString]));
    jsObject := JS.TJSObject(xdcResponse.Result);
    pdfURL := JS.toString(jsObject.Properties['value']);

    // Open the PDF in a new browser tab without needing a different form
    // This method is much faster too, even for large datasets
    window.open(pdfURL, '_blank');
  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
end;


procedure TFOrderEntryWeb.SendWebOrder();
// sends the order JSON object to the server
var
  colorList: TJSONArray;
  container: TJSElement;
  colorCollection: TJSHTMLCollection;
  color: TJSHTMLElement;
  I, J: integer;
  colorJSON, orderJSON, colorListJSON: TJSONObject;
  fieldNames: TStringList;
  itemList: TJSNodeList;
  header, value, info: string;
  Field: TField;
  Response: TXDataClientResponse;
  jsObj: TJSObject;
begin
    orderJSON := TJSONObject.Create;
  colorList := TJSONArray.Create;
  container := document.getElementById('additionalFields');
  colorCollection := container.children;
  for I := 0 to colorCollection.length - 1 do
  begin
    colorJSON := TJSONObject.Create;
    itemList := colorCollection[I].childNodes;
    for J := 0 to itemList.length - 2 do
    begin
      header := TJSHTMLElement(itemList[J]).children[0].innerText.Replace(':', '').Trim();
      value := TJSHTMLInputElement(TJSHTMLElement(itemList[J]).childNodes[1]).value;
      colorJSON.AddPair(header, value);
    end;
    colorList.Add(colorJSON);
  end;
  colorListJSON := TJSONObject.Create;
  colorListJSON.AddPair('items', colorList);
  xdwdsOrder.Edit;

  xdwdsOrderquantity_and_colors_qty_colors.Value := colorListJSON.ToString;
  xdwdsOrderUSER_ID.AsString := JS.toString(AuthService.TokenPayload.Properties['user_id']);

  xdwdsOrder.Post;
  xdwdsOrder.First;
  while not xdwdsOrder.Eof do
  begin
    for Field in xdwdsOrder.Fields do
    begin
      if Field is TStringField then
      begin
        if Field.AsString = '' then
          orderJSON.AddPair(Field.FieldName, '')
        else
          orderJSON.AddPair(Field.FieldName, Field.AsString);  // Add all other fields
      end
      else if Field is TBooleanField then
      begin
        if Field.AsBoolean then
          orderJSON.AddPair(Field.FieldName, 'T')
        else
          orderJSON.AddPair(Field.FieldName, '');
      end
      else if Field is TIntegerField then
        orderJSON.AddPair(Field.FieldName, Field.AsInteger);
    end;
    xdwdsOrder.Next;
  end;

  orderJSON.AddPair('mode', mode);
  orderJSON.AddPair('REVISION_NOTES', REVISION_NOTES);

  try
    Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.AddWebOrder', [orderJSON.ToString]));

    jsObj := JS.TJSObject(Response.Result);

    console.log(jsObj);

    xdwdsOrder.Close;
    xdwdsOrder.SetJsonData(jsObj);
    xdwdsOrder.Open;

    mode := 'EDIT';
    ShowToast(String(jsObj.Properties['status']));
  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
end;

procedure TFOrderEntryWeb.addColorRow(num: string; Color: string; LPI: string; Size: string);
var
  container, newRow, col, labelEl, inputEl, removeCol: TJSHTMLElement;
  removeBtn: TWebButton;
  values: array[0..3] of string;
  labels: array[0..3] of string;
  i: Integer;
begin
  container := TJSHTMLElement(document.getElementById('additionalFields'));

  // Create the new row container
  newRow := TJSHTMLElement(document.createElement('div'));
  newRow.className := 'row mb-2';

  labels[0] := '#';     values[0] := num;
  labels[1] := 'Color'; values[1] := color;
  labels[2] := 'LPI';   values[2] := LPI;
  labels[3] := 'Size';  values[3] := size;

  for i := 0 to 3 do
  begin
    col := TJSHTMLElement(document.createElement('div'));
    col.className := 'col-sm';

    labelEl := TJSHTMLElement(document.createElement('label'));
    labelEl.className := 'pe-2';
    labelEl.style.setProperty('font-weight', '700');
    labelEl.style.setProperty('font-size', '15px');
    labelEl.textContent := labels[i] + ':';

    inputEl := TJSHTMLElement(document.createElement('input'));
    inputEl.className := 'form-control input-sm';
    inputEl.setAttribute('style', 'width: 100%');
    inputEl.setAttribute('value', values[i]);
    inputEl.setAttribute('id', 'input-' + IntToStr(container.childElementCount) + '-' + IntToStr(i));

    col.appendChild(labelEl);
    col.appendChild(inputEl);
    newRow.appendChild(col);
  end;

  // Add remove button
  removeCol := TJSHTMLElement(document.createElement('div'));
  removeCol.className := 'col-auto d-flex align-items-end pb-1';

  removeBtn := TWebButton.Create(Self);
  removeBtn.Caption := 'Remove';
  removeBtn.ElementClassName := 'btn btn-danger btn-sm mt-1';
  removeBtn.ParentElement := removeCol;
  removeBtn.ElementHandle.style.setProperty('height', '30px');
  removeBtn.OnClick := RemoveColorRow;

  newRow.appendChild(removeCol);
  container.appendChild(newRow);
end;

procedure TFOrderEntryWeb.RemoveColorRow(Sender: TObject);
var
  btn: TWebButton;
  rowElement: TJSHTMLElement;
begin
  EditMode();
  btn := TWebButton(Sender);
  if Assigned(btn.ElementHandle) and Assigned(btn.ElementHandle.parentElement) then
  begin
    // Assuming button is inside a <div> inside the row
    rowElement := TJSHTMLElement(btn.ElementHandle.parentElement.parentElement);
    if Assigned(rowElement) then
      rowElement.remove;
  end;
end;

procedure TFOrderEntryWeb.WebButton1Click(Sender: TObject);
begin
  EditMode();
  addColorRow('','','','');
end;

procedure TFOrderEntryWeb.btnAddClick(Sender: TObject);
var
  newform: TFAddOrder;
  orderType: string;
begin
  newform := TFAddOrder.CreateNew;

  newform.Caption := 'Select Customer and Order Type';
  newForm.Popup := True;
  newForm.Border := fbDialog;
  newForm.Position := poScreenCenter;

  // used to manage Back button handling to close subform
  window.location.hash := 'subform';

  newform.ShowModal(
    procedure(AValue: TModalResult)
    begin
      if newform.confirm then
      begin
        if newform.cbCorrugatedPlate.Checked then
          orderType := 'corrugated'
        else if newform.cbWebPlate.Checked then
          orderType := 'web'
        else
          orderType := 'cutting';

        if orderType = 'corrugated' then
          FViewMain.ViewOrderEntryCorrugated('', newForm.DBID, 'ADD', '')
        else if orderType = 'web' then
          FViewMain.ViewOrderEntryWeb('', newForm.DBID, 'ADD', '')
        else
          FViewMain.ViewOrderEntryCuttingDie('', newForm.DBID, 'ADD', '');
      end;
    end
  );
end;

procedure TFOrderEntryWeb.btnCancelClick(Sender: TObject);
begin
  ShowConfirmationModal(
    'Are you sure you want to cancel all changes?',
    'Yes',
    'No',
    procedure(confirmed: Boolean)
    begin
      if confirmed then
      begin
        FViewMain.change := false;
        if OrderID <> '' then
          FViewMain.ViewOrderEntryWeb(OrderID, '', 'EDIT', 'Failure:  Changes Discarded')
        else
          FViewMain.ViewOrders('');
      end;
    end
  );
end;

procedure TFOrderEntryWeb.btnCloseClick(Sender: TObject);
begin
  FViewMain.ViewOrders('');
end;


procedure TFOrderEntryWeb.WebFormCreate(Sender: TObject);
begin
   if not DMConnection.ApiConnection.Connected then
   begin
    DMConnection.ApiConnection.OpenAsync;
    console.log('report requirements connection open')
   end;
end;

procedure TFOrderEntryWeb.getOrder(Order_ID: string);
// retrieves an order from the server then loads the info into the page
var
  xdcResponse: TXDataClientResponse;
  orderList : TJSObject;
  i: integer;
  data: TJSArray;
  order, customer: TJSObject;
  callListLength: integer;
  tempString, strColorList: string;
  colorObject: TJSObject;
  colorList: TJSArray;
  colorLength: integer;
  color: TJSObject;
  colorJSON: TJSONObject;
  colorListJSON: TJSONArray;
  items: TJSObject;
begin
  Utils.ShowSpinner('spinner');
  try
    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetWebOrder',
          [Order_ID]));
    order :=  TJSObject(xdcResponse.Result);
    data := TJSArray(order['data']);
    xdwdsOrder.Close;
    xdwdsOrder.SetJsonData(order);
    xdwdsOrder.Open;

    if xdwdsOrderquantity_and_colors_qty_colors.Value <> '' then
    begin
      colorObject := TJSObject(TJSJSON.parse(xdwdsOrderquantity_and_colors_qty_colors.Value));
      colorList := TJSArray(colorObject['items']);
      for I := 0 to colorList.length -1 do
      begin
        color := TJSObject(colorList[i]);
        addColorRow(String(color['#']), string(color['Color']), string(color['LPI']), string(color['Size']));
      end;
    end;

    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetCustomer',
        [xdwdsOrder.FieldByName('COMPANY_ID').AsString]));
    customer :=  TJSObject(xdcResponse.Result);
    customer_qb_id := string(customer['QB_LIST_ID']);

    xdwdsShipTo.Close;
    xdwdsShipTo.SetJSONData(customer['SHIPPING_ADDRESS_LIST']);
    xdwdsShipTo.Open;

    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetItems',
        []));
    items :=  TJSObject(xdcResponse.Result);
    console.log(items);
    xdwdsQBItem.Close;
    xdwdsQBItem.SetJsonData(items['data']);
    xdwdsQBITEM.Open;

    xdwdsQBItem.Locate('name', wcbQBItem.Text , []);
    wcbQBItem.Text := xdwdsQBItem.FieldByName('name').AsString;
    edtQBItemDescription.text := xdwdsQBItem.FieldByName('description').AsString +
                                ' - ' + xdwdsOrder.FieldByName('staff_fields_job_name').AsString;

  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
  Utils.HideSpinner('spinner');
end;



procedure TFOrderEntryWeb.SetNewOrderInfo(customerID: string);
// gets a customer from the database then loads the appropiate fields
var
  xdcResponse: TXDataClientResponse;
  customer : TJSObject;
  address: string;
  items: TJSObject;
begin
  xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetCustomer',
        [customerID]));
  customer :=  TJSObject(xdcResponse.Result);
  customer_qb_id := string(customer['QB_LIST_ID']);

  xdwdsOrder.Close;
  xdwdsOrder.Open;
  xdwdsOrder.Append;
  xdwdsOrder.FieldByName('NAME').AsString := string(customer['NAME']);
  xdwdsOrder.FieldByName('SHORT_NAME').AsString := string(customer['SHORT_NAME']);
  xdwdsOrder.FieldByName('staff_fields_invoice_to').AsString := string(customer['staff_fields_invoice_to']);

  xdwdsOrder.FieldByName('COMPANY_ID').AsString := customerID;
  xdwdsOrder.Post;

  xdwdsShipTo.Close;
  xdwdsShipTo.SetJSONData(customer['SHIPPING_ADDRESS_LIST']);
  xdwdsShipTo.Open;

   xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetItems',
        []));
  items :=  TJSObject(xdcResponse.Result);
  xdwdsQBItem.Close;
  xdwdsQBItem.SetJsonData(items['data']);
  xdwdsQBITEM.Open;

end;

procedure TFOrderEntryWeb.tmrReturnTimer(Sender: TObject);
begin
  Utils.HideSpinner('spinner');
  tmrReturn.Enabled := false;
  FViewMain.ViewOrders('Success: Order Successfully Deleted');
end;

procedure TFOrderEntryWeb.EditMode;
begin
  xdwdsOrder.Edit;

  FViewMain.change := true;
  btnCopy.Enabled := false;
  btnPDF.Enabled := false;
  btnDelete.Enabled := false;
  btnClose.Enabled := false;
  btnSave.Enabled := true;
  btnCancel.Enabled := True;
  btnEdit.Enabled := false;
  btnAdd.Enabled := false;

  cbPdf.Enabled := True;
  cbInkJet.Enabled := True;

  lblFormState.Caption := 'Edit Mode';
  lblFormState.ElementHandle.classList.remove('text-danger');
  lblFormState.ElementHandle.classList.add('text-success');
end;

procedure TFOrderEntryWeb.edtJobNameExit(Sender: TObject);
begin
  edtQBItemDescription.text := xdwdsQBItem.FieldByName('description').AsString +
                              ' - ' + xdwdsOrder.FieldByName('staff_fields_job_name').AsString;
end;

procedure TFOrderEntryWeb.ViewMode;
begin
  btnPDF.Enabled := true;
  btnDelete.Enabled := true;
  btnClose.Enabled := true;
  btnCopy.Enabled := true;
  btnSave.Enabled := false;
  btnCancel.Enabled := false;
  btnEdit.Enabled := true;
  btnAdd.Enabled := true;
  FViewMain.change := false;

  cbPdf.Enabled := False;
  cbInkJet.Enabled := False;

  lblFormState.Caption := 'View Mode';
  lblFormState.ElementHandle.classList.remove('text-success');
  lblFormState.ElementHandle.classList.add('text-danger');
end;


procedure TFOrderEntryWeb.wcbQBItemChange(Sender: TObject);
begin
  xdwdsQBItem.Locate('name', wcbQBItem.Text , []);
  wcbQBItem.Text := xdwdsQBItem.FieldByName('name').AsString;
  edtQBItemDescription.text := xdwdsQBItem.FieldByName('description').AsString +
                              ' - ' + xdwdsOrder.FieldByName('staff_fields_job_name').AsString;
end;

function TFOrderEntryWeb.VerifyOrder: Boolean;
var
  input: TJSHTMLInputElement;
begin
  result := true;

  input := TJSHTMLInputElement(document.getElementById('edtcompanyname'));
  if edtCompanyName.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtjobname'));
  if edtJobName.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');


  input := TJSHTMLInputElement(document.getElementById('edtaccountcompanyname'));
  if edtCompanyAccountName.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtinvoiceto'));
  if edtInvoiceTo.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');


  input := TJSHTMLInputElement(document.getElementById('wcbshipto'));
  if wdbcbShipTo.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('dtporderdate'));
  if dtpOrderDate.Date = 0 then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtprice'));
  if edtPrice.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtquantity'));
  if edtQuantity.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('wcbqbitem'));
  if wcbQBItem.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');
end;

function TFOrderEntryWeb.VerifyQBOrder: Boolean;
var
  msg, SQL: string;
begin
  Result := True;
  msg := 'To add an order to QuickBooks, the following must be present:' + sLineBreak;

  if edtCompanyName.Text = '' then
  begin
    msg := msg + '- Company Name cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtCompanyAccountName.Text = '' then
  begin
    msg := msg + '- Company ID cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtInvoiceTo.Text = '' then
  begin
    msg := msg + '- Invoice To cannot be empty' + sLineBreak;
    Result := False;
  end;

  if wdbcbShipTo.Text = '' then
  begin
    msg := msg + '- Ship To cannot be empty' + sLineBreak;
    Result := False;
  end;

  if dtpOrderDate.Date = 0 then
  begin
    msg := msg + '- Order Date cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtPrice.Text = '' then
  begin
    msg := msg + '- Price cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtQuantity.Text = '' then
  begin
    msg := msg + '- Quantity cannot be empty' + sLineBreak;
    Result := False;
  end;

  if wcbQBItem.Text = '' then
  begin
    msg := msg + '- Item cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtJobName.Text = '' then
  begin
    msg := msg + '- Job Name Cannot be empty' + sLineBreak;
    Result := False;
  end;

  xdwdsQBItem.Locate('name', xdwdsOrder.FieldByName('staff_fields_quickbooks_item').AsString, []);
  if xdwdsQBItem.FieldByName('QB_ID').AsString = '' then
  begin
    msg := msg + '- Item Must be Linked to QuickBooks' + sLineBreak;
    Result := False;
  end;

  if customer_qb_id = '' then
  begin
    msg := msg + '- Customer Must be Linked to QuickBooks' + sLineBreak;
    Result := False;
  end;

  if not result then
  asm
    alert(msg);
  end;
end;


end.