// For testing querys.
// Visual aspect is for testing purposes only and has no affect on the client.
// Authors:
// Cameron Hayes
// Elias Serraf
// Mac Stephens
unit Data;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, AdvUtil, Data.DB, Vcl.Grids, AdvObj,
  BaseGrid, AdvGrid, DBAdvGrid, MemDS, DBAccess, Uni, Vcl.StdCtrls, Vcl.Mask,
  vcl.wwdbedit, vcl.wwdotdot, vcl.wwdbcomb, REST.Client, REST.Types, System.JSON,
  System.Generics.Collections, AdvEdit, vcl.wwdblook, vcl.wwdbdatetimepicker,
  System.Hash, Api.Database, Vcl.ExtCtrls;

type
  TFData = class(TForm)
    dsUsers: TDataSource;
    btnFind: TButton;
    Memo1: TMemo;
    DBAdvGrid1: TDBAdvGrid;
    DBAdvGrid2: TDBAdvGrid;
    dsGrid2: TDataSource;
    edtUsername: TEdit;
    edtPassword: TEdit;
    lblHash: TLabel;
    btnAddUser: TButton;
    lblHash2: TLabel;
    uqUsers: TUniQuery;
    cbAdmin: TCheckBox;
    edtFullName: TEdit;
    edtPhoneNumber: TEdit;
    edtEmailAddress: TEdit;
    btnPDF: TButton;
    Timer1: TTimer;
    Button1: TButton;
    uqWeb: TUniQuery;
    uqWebORDER_ID: TIntegerField;
    uqWebCOMPANY_ID: TIntegerField;
    uqWebUSER_ID: TIntegerField;
    uqWebORDER_DATE: TDateTimeField;
    uqWebSTART_DATE: TDateField;
    uqWebEND_DATE: TDateField;
    uqWebORDER_STATUS: TStringField;
    uqWebSCHED_JSON: TStringField;
    uqWebstaff_fields_order_date: TDateField;
    uqWebstaff_fields_proof_date: TDateField;
    uqWebstaff_fields_ship_date: TDateField;
    uqWebstaff_fields_ship_via: TStringField;
    uqWebstaff_fields_price: TStringField;
    uqWebstaff_fields_invoice_to: TStringField;
    uqWebstaff_fields_invoice_attention: TStringField;
    uqWebstaff_fields_ship_to: TStringField;
    uqWebstaff_fields_ship_attention: TStringField;
    uqWebstaff_fields_po_number: TStringField;
    uqWebstaff_fields_job_name: TStringField;
    uqWebstaff_fields_art_due: TDateField;
    uqWebstaff_fields_plate_due: TDateField;
    uqWebplates_job_number: TStringField;
    uqWebsupplied_by_customer_b_w_or_co: TStringField;
    uqWebsupplied_by_customer_plates: TStringField;
    uqWebsupplied_by_customer_sample: TStringField;
    uqWebsupplied_by_customer_dimension: TStringField;
    uqWebsupplied_by_customer_other: TStringField;
    uqWebsupplied_by_customer_disk: TStringField;
    uqWebsupplied_by_customer_e_mail: TStringField;
    uqWebsupplied_by_customer_ftp: TStringField;
    uqWebplates_plate_material: TStringField;
    uqWebplates_thickness: TStringField;
    uqWebsupplied_by_customer_total_inc: TStringField;
    uqWebsupplied_by_customer_sheets_us: TStringField;
    uqWebsupplied_by_customer_initials: TStringField;
    uqWebproofing_pdf: TStringField;
    uqWebproofing_pdf_to: TStringField;
    uqWebproofing_pdf_date_1: TDateField;
    uqWebproofing_pdf_date_2: TDateField;
    uqWebproofing_pdf_date_3: TDateField;
    uqWebproofing_full_size_ink_jet_for: TStringField;
    uqWebproofing_ink_jet_to: TStringField;
    uqWebproofing_ink_jet_to_2: TStringField;
    uqWebproofing_ink_jet_date_1: TDateField;
    uqWebproofing_ink_jet_date_2: TDateField;
    uqWebproofing_ink_jet_date_3: TDateField;
    uqWebproofing_color_contract: TStringField;
    uqWebproofing_color_contrac_to: TStringField;
    uqWebproofing_color_contrac_date_1: TDateField;
    uqWebproofing_color_contrac_date_2: TDateField;
    uqWebproofing_digital_color_key: TStringField;
    uqWebproofing_digital_color_to: TStringField;
    uqWebproofing_digital_color_date_1: TDateField;
    uqWebquantity_and_colors_press_name: TStringField;
    uqWebquantity_and_colors_anilox_info: TStringField;
    uqWebplate_marks_microdots: TStringField;
    uqWebplate_marks_microdots_comments: TStringField;
    uqWebplate_marks_crosshairs: TStringField;
    uqWebplate_marks_crosshairs_comments: TStringField;
    uqWebplate_marks_color_bars: TStringField;
    uqWebplate_marks_color_bars_comments: TStringField;
    uqWebplate_marks_other: TStringField;
    uqWebplate_marks_other_comments: TStringField;
    uqWebprint_orientation_print_orient: TStringField;
    uqWeblayout_around: TStringField;
    uqWeblayout_accross: TStringField;
    uqWeblayout_surface_print: TStringField;
    uqWeblayout_reverse_print: TStringField;
    uqWeblayout_cylinder_repeat: TStringField;
    uqWeblayout_cutoff_dimension: TStringField;
    uqWeblayout_pitch: TStringField;
    uqWeblayout_teeth: TStringField;
    uqWeblayout_bleed: TStringField;
    uqWeblayout_cutback: TStringField;
    uqWeblayout_minimum_trap_dim: TStringField;
    uqWeblayout_maximum_trap_dim: TStringField;
    uqWebupc_size: TStringField;
    uqWebupc_bar_width_reduction: TStringField;
    uqWebquantity_and_colors_qty_colors: TStringField;
    uqWebgeneral_comments: TStringField;
    uqWebstaff_fields_quickbooks_item: TStringField;
    uqWebstaff_fields_quantity: TStringField;
    uqWebupc_distortion_percent: TStringField;
    uqWebupc_distortion_amount: TStringField;
    uqWebstaff_fields_art_location: TStringField;
    procedure FormCreate(Sender: TObject);
    procedure btnFindClick(Sender: TObject);
    procedure btnPDFClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    kgDB: TApiDatabase;
    accountSID: string;
    authHeader: string;
  public
    procedure RunOrdersReport(searchOptions: string);
  end;

var
  FData: TFData;

implementation

{$R *.dfm}

uses uLibrary, rOrderList, rOrderWeb, rOrderCorrugated;

procedure TFData.FormCreate(Sender: TObject);
begin
  Timer1.Enabled := True;
end;


procedure TFData.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled := False;
  Screen.Cursor := crHourGlass;
  Memo1.Lines.Add( 'creating kgDB TApiDatabase...' );
  kgDB := TApiDatabase.Create(Self);
  Memo1.Lines.Add( '--kgDB TApiDatabase created!' );
  Screen.Cursor := crDefault;
end;


procedure TFData.btnPDFClick(Sender: TObject);
begin
  RunOrdersReport('&pagenumber=1&pagesize=50&orderby=');
end;


procedure TFData.Button1Click(Sender: TObject);
var
  Field: TField;
  SQL: string;
begin
  for Field in uqWeb.Fields do
  begin
    SQL := 'SELECT ORDER_ID, ORDER_DATE, ' + Field.FieldName + ', LENGTH( ' + Field.FieldName +
    ') AS max_length FROM web_plate_orders ORDER BY max_length DESC LIMIT 1';
    doQuery(uqUsers, SQL);
    memo1.Lines.Add(Field.FieldName + ', ' + uqUsers.FieldByName('ORDER_ID').AsString +
    ', '   + uqUsers.FieldByName('max_length').AsString + ', ' + uqUsers.FieldByName('ORDER_DATE').AsString);
  end;

end;

procedure TFData.btnFindClick(Sender: TObject);
// Retrieves calls from a specific number from the database.
// SQL: SQL statement to retrieve calls from the database
// whereSQL: where section of the SQL that is built in the function
var
  SQL: string;
  whereSQL: string;
begin
  Memo1.Lines.Add(uqUsers.Connection.Server);
  SQL := 'select * from users';
  uqUsers.Close;
  uqUsers.SQL.Text := sql;
  uqUsers.Open;

  DBAdvGrid1.AutoSizeColumns(true);
end;


procedure TFData.RunOrdersReport(searchOptions: string);
var
  rptOrderList: TrptOrderList;
begin
  rptOrderList := TrptOrderList.Create(nil);
  try
    rptOrderList.PrepareReport(searchOptions, '');
    dsGrid2.DataSet := rptOrderList.uqOrders;
  finally
    rptOrderList.Free;
  end;
end;


end.
