unit View.SetStatus;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls, Vcl.StdCtrls, WEBLib.ExtCtrls,
  WEBLib.StdCtrls, Utils, System.DateUtils;

type
  TFSetStatus = class(TWebForm)
    wlcbStatus: TWebLookupComboBox;
    dtpDate: TWebDateTimePicker;
    lblStatus1: TWebLabel;
    WebLabel1: TWebLabel;
    btnConfirm: TWebButton;
    btnCancel: TWebButton;
    WebLabel2: TWebLabel;
    edtOrderID: TWebEdit;
    edtJobName: TWebEdit;
    WebLabel3: TWebLabel;
    lblShip: TWebLabel;
    dtpShipDue: TWebDateTimePicker;
    lblMount: TWebLabel;
    dtpMountDue: TWebDateTimePicker;
    lblPlate: TWebLabel;
    dtpPlateDue: TWebDateTimePicker;
    lblArt: TWebLabel;
    dtpArtDue: TWebDateTimePicker;
    procedure WebFormShow(Sender: TObject);
    procedure btnConfirmClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure wlcbStatusChange(Sender: TObject);
    procedure dtpDateChange(Sender: TObject);
  private
    { Private declarations }
    function Verify(): boolean;
    function GetNextDate(CurrDate: TDateTime): TDateTime;
    procedure SetDueDates();
  public
    { Public declarations }
    confirm: boolean;
    OrderID, JobName, OrderType: string;
    ShipDue, MountDue, PlateDue, ArtDue: TDateTime;
  end;

var
  FSetStatus: TFSetStatus;

implementation

{$R *.dfm}

procedure TFSetStatus.btnCancelClick(Sender: TObject);
begin
  Close;
end;


function TFSetStatus.Verify: Boolean;
var
  input: TJSHTMLElement;
begin
  result := true;

  input := TJSHTMLElement(document.getElementById('dtpdate'));
  if dtpDate.Date = 0 then
  begin
    input.style.setProperty('background-color', 'yellow');
    result := false;
  end
  else
    input.style.setProperty('background-color', 'white');

  input := TJSHTMLElement(document.getElementById('wlc_status'));
  if wlcbStatus.Value = '' then
  begin
    input.style.setProperty('background-color', 'yellow');
    result := false;
  end
  else
    input.style.setProperty('background-color', 'white');

end;


procedure TFSetStatus.btnConfirmClick(Sender: TObject);
var
  el: tjshtmlElement;
begin
  if ( not Verify() ) then
  begin
    ShowToast('Failure: Please fill in all highlighted information')
  end
  else if ( ( OrderType = 'web plate' ) and ( wlcbStatus.Value = 'MOUNT' ) ) then
    ShowToast('Failure: Web Plate Orders do not have Mount Due/Done dates')
  else if ( ( OrderType = 'cutting die' ) and ( ( wlcbStatus.Value = 'MOUNT' ) or ( wlcbStatus.Value = 'ART' ) or (wlcbStatus.Value = 'PLATE') ) ) then
    ShowToast('Failure: Cutting Die Orders do not have Art/Plate/Mount Due or Done Dates')
  else
  begin
    confirm := true;
    ShowToast('Success: Status updated!');
    Close;
  end;
end;


procedure TFSetStatus.dtpDateChange(Sender: TObject);
begin
  SetDueDates();
end;


procedure TFSetStatus.WebFormShow(Sender: TObject);
var
  ItemsToRemove: TStringList;
  i: integer;
  filteredItems: TJSArray;
begin
  edtOrderID.Text := OrderID;
  dtpDate.Date := Now;
  edtJobName.Text := JobName;
  dtpShipDue.Date := ShipDue;
  dtpMountDue.Date := MountDue;
  dtpPlateDue.Date := PlateDue;
  dtpArtDue.Date := ArtDue;
  ItemsToRemove := TStringList.Create;
  console.log(orderType);
  if orderType = 'web plate' then
  begin
    dtpMountDue.Visible := false;
    lblMount.Visible := false;
    dtpShipDue.Top := dtpMountDue.Top;
    lblShip.Top := lblMount.Top;
    wlcbStatus.LookupValues.AddPair('PROOF', 'Proof Done');
    wlcbStatus.LookupValues.AddPair('ART', 'Art Done');
    wlcbStatus.LookupValues.AddPair('PLATE', 'Plate Done');
    wlcbStatus.LookupValues.AddPair('SHIP', 'Ship Done');
  end
  else if orderType = 'cutting die' then
  begin
    dtpMountDue.Visible := false;
    lblMount.Visible := false;

    dtpPlateDue.Visible := false;
    lblPlate.Visible := false;

    dtpArtDue.Visible := false;
    lblArt.Visible := false;

    dtpShipDue.Top := dtpArtDue.Top;
    lblShip.Top := lblArt.Top;
    wlcbStatus.LookupValues.AddPair('PROOF', 'Proof Done');
    wlcbStatus.LookupValues.AddPair('SHIP', 'Ship Done');
  end
  else
  begin
    wlcbStatus.LookupValues.AddPair('PROOF', 'Proof Done');
    wlcbStatus.LookupValues.AddPair('ART', 'Art Done');
    wlcbStatus.LookupValues.AddPair('PLATE', 'Plate Done');
    wlcbStatus.LookupValues.AddPair('MOUNT', 'Mount Done');
    wlcbStatus.LookupValues.AddPair('SHIP', 'Ship Done');
  end;
end;


procedure TFSetStatus.wlcbStatusChange(Sender: TObject);
begin
   SetDueDates();
end;


procedure TFSetStatus.SetDueDates();
begin
  if OrderType = 'corrugated plate' then
  begin
    if wlcbStatus.DisplayText = 'Proof Done' then
    begin
      dtpPlateDue.Date := plateDue;
      dtpMountDue.Date := mountDue;
      dtpShipDue.Date := shipDue;
    end
    else if wlcbStatus.DisplayText = 'Art Done' then
    begin
      dtpPlateDue.Date := getNextDate(dtpDate.Date);
      dtpMountDue.Date := getNextDate(dtpPlateDue.Date);
      dtpShipDue.Date := dtpMountDue.Date;
    end
    else if wlcbStatus.DisplayText = 'Plate Done' then
    begin
      dtpPlateDue.Date := plateDue;
      dtpMountDue.Date := getNextDate(dtpDate.Date);
      dtpShipDue.Date := dtpMountDue.Date;
    end
    else if wlcbStatus.DisplayText = 'Mount Done' then
    begin
      dtpPlateDue.Date := plateDue;
      dtpMountDue.Date := mountDue;
      dtpShipDue.Date := dtpDate.Date;
    end
    else if wlcbStatus.DisplayText = 'Ship Done' then
    begin
      dtpPlateDue.Date := plateDue;
      dtpMountDue.Date := mountDue;
      dtpShipDue.Date := shipDue;
    end;
  end
  else if OrderType = 'web plate' then
  begin
    if wlcbStatus.DisplayText = 'Proof Done' then
    begin
      dtpPlateDue.Date := plateDue;
      dtpShipDue.Date := shipDue;
    end
    else if wlcbStatus.DisplayText = 'Art Done' then
    begin
      dtpPlateDue.Date := getNextDate(dtpDate.Date);
      dtpShipDue.Date :=  dtpPlateDue.Date;
    end
    else if wlcbStatus.DisplayText = 'Plate Done' then
    begin
      dtpPlateDue.Date := plateDue;
      dtpShipDue.Date := plateDue;
    end
    else if wlcbStatus.DisplayText = 'Ship Done' then
    begin

      dtpPlateDue.Date := plateDue;
      dtpShipDue.Date := shipDue;
    end;
  end
  else
  begin
    if wlcbStatus.DisplayText = 'Proof Done' then
    begin
      dtpShipDue.Date := shipDue;
    end
    else if wlcbStatus.DisplayText = 'Art Done' then
    begin
      dtpShipDue.Date := dtpDate.Date;
    end
    else if wlcbStatus.DisplayText = 'Ship Done' then
    begin
      dtpShipDue.Date := shipDue;
    end;
  end;
end;


function TFSetStatus.GetNextDate(CurrDate: TDateTime): TDateTime;
var
  DOW: integer;
begin
  CurrDate := CurrDate + 1;
  DOW := DayOfWeek(CurrDate);
  while DOW in [1, 7] do
  begin
    CurrDate := CurrDate + 1;
    DOW := DayOfWeek(CurrDate);
  end;
  result := CurrDate;
  console.log(CurrDate);
end;


end.