unit rOrderCutting;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, Common.Logging,
  frxClass, frxExportBaseDialog, frxExportPDF, frCoreClasses, frxDBSet, JS, JSON,
  frxTableObject, frxUtils;


type
  TrptOrderCutting = class(TDataModule)
    ucKG: TUniConnection;
    frxPDFExport1: TfrxPDFExport;
    frxDBOrderCutting: TfrxDBDataset;
    frxOrderCutting: TfrxReport;
    uqOrderCutting: TUniQuery;
    uqOrderCuttingORDER_ID: TIntegerField;
    uqOrderCuttingCOMPANY_ID: TIntegerField;
    uqOrderCuttingUSER_ID: TIntegerField;
    uqOrderCuttingORDER_DATE: TDateTimeField;
    uqOrderCuttingstaff_fields_order_date: TDateField;
    uqOrderCuttingstaff_fields_proof_date: TDateField;
    uqOrderCuttingstaff_fields_ship_date: TDateField;
    uqOrderCuttingstaff_fields_ship_via: TStringField;
    uqOrderCuttingstaff_fields_quantity: TStringField;
    uqOrderCuttingstaff_fields_price: TStringField;
    uqOrderCuttingstaff_fields_invoice_to: TStringField;
    uqOrderCuttingstaff_fields_ship_to: TStringField;
    uqOrderCuttingstaff_fields_po_number: TStringField;
    uqOrderCuttingstaff_fields_job_name: TStringField;
    uqOrderCuttingstaff_fields_quickbooks_item: TStringField;
    uqOrderCuttinggeneral_special_instructions: TStringField;
    uqOrderCuttingORDER_STATUS: TStringField;
    uqOrderCuttingORDER_ID_1: TLongWordField;
    uqOrderCuttingCOMPANY_ID_1: TLongWordField;
    uqOrderCuttingORDER_TYPE: TStringField;
    uqOrderCuttingORDER_DATE_1: TDateTimeField;
    uqOrderCuttingPRICE: TFloatField;
    uqOrderCuttingJOB_NAME: TStringField;
    uqOrderCuttingUSER_ID_1: TLongWordField;
    uqOrderCuttingLOCATION: TStringField;
    uqOrderCuttingIN_QB: TStringField;
    uqOrderCuttingQB_ORDER_NUM: TStringField;
    uqOrderCuttingQB_ESTIMATE_ID: TStringField;
    uqOrderCuttingQB_ORDER_USER: TStringField;
    uqOrderCuttingQB_CREATE_DATE: TDateTimeField;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function PrepareReport(SQL: string): string;
    function GeneratePDF: string;
  end;

var
  rptOrderCutting: TrptOrderCutting;

implementation

uses
  uLibrary, Common.Config;

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TrptOrderCutting.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 5, 'TrptOrderCutting.DataModuleCreate' );
  LoadDatabaseSettings( ucKG, 'kgOrdersServer.ini' );
  try
    ucKG.Connect;
  except
    on E: Exception do
    begin
      Logger.Log( 1, '--TrptOrderCutting.DataModuleCreate -Error connecting to database: ' + E.Message );
    end;
  end;
end;


function TrptOrderCutting.PrepareReport(SQL: string): string;
begin
  Logger.Log( 5, 'TrptOrderCutting.PrepareReport - SQL: ' + SQL );

  doQuery(uqOrderCutting, SQL);
  result := GeneratePDF;
end;


function TrptOrderCutting.GeneratePDF: string;
var
  reportsDir, reportFileName: string;
  reportURL: string;
begin
  reportsDir := ServerConfig.reportsFolder;
  reportFileName := FormatDateTime('yyyymmdd_hhnnss', Now) + '.pdf';
  reportURL :=  'reports\' + reportFilename;

  frxPDFExport1.FileName := reportsDir + reportFileName;
  frxPDFExport1.ShowDialog := False;
  try
    frxOrderCutting.PrepareReport;
    frxOrderCutting.Export(frxPDFExport1);
    //frxOrders.ShowPreparedReport;
  finally
     frxOrderCutting.Clear; // Clears the report to avoid memory bloat
  end;

  Logger.Log( 4, 'TrptOrderWeb.GeneratePDF - PDF saved to: ' + reportFileName );
  result := reportURL;
end;


end.
