// Small Pop-Up page when adding orders if you want to quickly add an address
unit View.AddAddress;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls, Vcl.StdCtrls, WEBLib.StdCtrls;

type
  TFViewAddAddress = class(TWebForm)
    edtState: TWebEdit;
    edtFirstLine: TWebEdit;
    edtCity: TWebEdit;
    edtZip: TWebEdit;
    edtContact: TWebEdit;
    edtAddress: TWebEdit;
    WebLabel1: TWebLabel;
    WebLabel2: TWebLabel;
    WebLabel3: TWebLabel;
    WebLabel4: TWebLabel;
    WebLabel5: TWebLabel;
    WebLabel6: TWebLabel;
    edtNotification: TWebEdit;
    btnSave: TWebButton;
    btnCancel: TWebButton;
    procedure btnCancelClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
    { Private declarations }
    function Verify(): boolean;
  public
    { Public declarations }
    var
      confirm: boolean;
  end;

var
  FViewAddAddress: TFViewAddAddress;

implementation

{$R *.dfm}

procedure TFViewAddAddress.btnSaveClick(Sender: TObject);
begin
  if Verify() then
  begin
    confirm := true;
    Close;
  end;
end;

function TFViewAddAddress.Verify(): boolean;
// Makes sure the address is filled in.
begin
  result := true;

  if edtFirstLine.Text = '' then
  begin
    edtNotification.Text := 'Please Fill in the First Line';
    result := false;
  end
  else if edtAddress.Text = '' then
  begin
    edtNotification.Text := 'Please Fill in the Address';
    result := false;
  end
  else if edtCity.Text = '' then
  begin
    edtNotification.Text := 'Please Fill in the City';
    result := false;
  end
  else
  if edtState.Text = '' then
  begin
    edtNotification.Text := 'Please Fill in the State';
    result := false;
  end
  else if edtZip.Text = '' then
  begin
    edtNotification.Text := 'Please Fill in the Zip Code';
    result := false;
  end
  else if edtContact.Text = '' then
  begin
    edtNotification.Text := 'Please Fill in the Contact';
    result := false;
  end
end;

procedure TFViewAddAddress.btnCancelClick(Sender: TObject);
begin
  Close;
end;

end.