// Pop-Up menu that appears when Add Order button is clicked on orders page.
// Used to select customer before entering an order.
unit View.AddOrder;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, VCL.TMSFNCTypes, VCL.TMSFNCUtils,
  VCL.TMSFNCGraphics, VCL.TMSFNCGraphicsTypes, VCL.TMSFNCGridCell,
  VCL.TMSFNCGridOptions, Vcl.Controls, VCL.TMSFNCCustomControl,
  VCL.TMSFNCCustomScrollControl, VCL.TMSFNCGridData, VCL.TMSFNCCustomGrid,
  VCL.TMSFNCGrid, Vcl.StdCtrls, WEBLib.StdCtrls, XData.Web.Client, Data.DB,
  XData.Web.JsonDataset, XData.Web.Dataset, WEBLib.DB, ConnectionModule, Utils;

type
  TFAddOrder = class(TWebForm)
    edtSearch: TWebEdit;
    edtID: TWebEdit;
    TMSFNCGrid1: TTMSFNCGrid;
    cbCorrugatedPlate: TWebCheckBox;
    cbWebPlate: TWebCheckBox;
    btnCancel: TWebButton;
    btnConfirm: TWebButton;
    WebLabel1: TWebLabel;
    WebLabel2: TWebLabel;
    XDataWebClient1: TXDataWebClient;
    xdwdsCustomers: TXDataWebDataSet;
    xdwdsCustomersNAME: TStringField;
    xdwdsCustomersSHORT_NAME: TStringField;
    wdsCustomers: TWebDataSource;
    cbCuttingDie: TWebCheckBox;
    xdwdsCustomersstaff_fields_invoice_to: TStringField;
    xdwdsCustomersCUSTOMER_ID: TIntegerField;
    WebLabel3: TWebLabel;
    edtName: TWebEdit;
    procedure WebFormShow(Sender: TObject);
    procedure edtSearchChange(Sender: TObject);
    procedure cbCorrugatedPlateClick(Sender: TObject);
    procedure cbWebPlateClick(Sender: TObject);
    procedure btnConfirmClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure cbCuttingDieClick(Sender: TObject);
    procedure TMSFNCGrid1CellClick(Sender: TObject; ACol, ARow: Integer);
  private
    [async] procedure getCustomers;
    procedure PopulateGridManually;
    procedure ApplyFilter;
    { Private declarations }
  public
    { Public declarations }
    var
      confirm: boolean;
      DBID: string;
  end;

var
  FAddOrder: TFAddOrder;

implementation

{$R *.dfm}

procedure TFAddOrder.btnCancelClick(Sender: TObject);
begin
  Close;
end;


procedure TFAddOrder.btnConfirmClick(Sender: TObject);
begin
  confirm := true;
  if  ( ( not cbCorrugatedPlate.Checked ) and ( not cbWebPlate.Checked ) and ( not cbCuttingDie.Checked ) ) then
  begin
    ShowToast('Please Select an Order Type', 'danger');
    confirm := false;
  end;

  if edtID.Text = '' then
  begin
    ShowToast('Please Select a Customer', 'danger');
    confirm := false;
  end;

  if ( ( not cbCorrugatedPlate.Checked ) and ( not cbWebPlate.Checked ) and ( not cbCuttingDie.Checked ) and (edtID.Text = '' )) then
  begin
    ShowToast('Please Select an Order Type and a Customer', 'danger');
    confirm := false;
  end;

  if confirm = true then
  begin
    Close;
  end;
end;


procedure TFAddOrder.WebFormShow(Sender: TObject);
begin
  confirm := false;
  getCustomers();
end;


procedure TFAddOrder.cbCorrugatedPlateClick(Sender: TObject);
begin
  cbWebPlate.Checked := False;
  cbCuttingDie.Checked := False;
end;


procedure TFAddOrder.cbCuttingDieClick(Sender: TObject);
begin
  cbCorrugatedPlate.Checked := False;
  cbWebPlate.Checked := False;
end;


procedure TFAddOrder.cbWebPlateClick(Sender: TObject);
begin
  cbCorrugatedPlate.Checked := False;
  cbCuttingDie.Checked := False;
end;


procedure TFAddOrder.edtSearchChange(Sender: TObject);
begin
  ApplyFilter;
end;


[async] procedure TFAddOrder.getCustomers();
// retrieves customer list from server
var
  xdcResponse: TXDataClientResponse;
  customerList: TJSObject;
begin
  // Fetch data from XData service
  xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetCustomers', []));
  customerList := TJSObject(xdcResponse.Result);

  // Load data into TXDataWebDataset
  xdwdsCustomers.Close;
  xdwdsCustomers.SetJsonData(customerList['data']);
  xdwdsCustomers.Open;

  // Manually populate the grid
  PopulateGridManually;
end;


procedure TFAddOrder.PopulateGridManually;
// populates the grid with customers manually.
var
  RowIndex: Integer;
begin
  TMSFNCGrid1.BeginUpdate;
  try
    TMSFNCGrid1.Clear; // Clear any existing data

    // Set up column headers
    TMSFNCGrid1.ColumnCount := 4;
    TMSFNCGrid1.RowCount := 1;
    TMSFNCGrid1.Cells[0, 0] := 'Customer Num';
    TMSFNCGrid1.Cells[1, 0] := 'Customer ID';
    TMSFNCGrid1.Cells[2, 0] := 'Customer Name';
    TMSFNCGrid1.Cells[3, 0] := 'Address';

    // Populate the grid with data from the dataset
    xdwdsCustomers.First;
    RowIndex := 1;

    while not xdwdsCustomers.EOF do
    begin
      TMSFNCGrid1.RowCount := RowIndex + 1;
      TMSFNCGrid1.Cells[0, RowIndex] := xdwdsCustomers.FieldByName('CUSTOMER_ID').AsString;
      TMSFNCGrid1.Cells[1, RowIndex] := xdwdsCustomers.FieldByName('SHORT_NAME').AsString;
      TMSFNCGrid1.Cells[2, RowIndex] := xdwdsCustomers.FieldByName('NAME').AsString;
      TMSFNCGrid1.Cells[3, RowIndex] := xdwdsCustomers.FieldByName('staff_fields_invoice_to').AsString;

      Inc(RowIndex);
      xdwdsCustomers.Next;
    end;

  finally
    TMSFNCGrid1.EndUpdate;
  end;
end;



procedure TFAddOrder.TMSFNCGrid1CellClick(Sender: TObject; ACol, ARow: Integer);
begin
  edtID.Text := TMSFNCGrid1.Cells[1, ARow];
  edtName.Text := TMSFNCGrid1.Cells[2, ARow];
  DBID := TMSFNCGrid1.Cells[0, ARow];
end;


procedure TFAddOrder.ApplyFilter;
// filters the grid based on search textbox contents.
var
  fd: TTMSFNCGridFilterData;
  i: Integer;
  SearchText: string;
begin
  SearchText := Trim(edtSearch.Text);

  TMSFNCGrid1.RemoveFilter;
  TMSFNCGrid1.Filter.Clear;

  // match on first 3 columns
  for i := 0 to 2 do
  begin
    fd := TMSFNCGrid1.Filter.Add;
    fd.Column := i;
    fd.Condition := '*' + SearchText + '*'; // Match text anywhere in the cell
    fd.CaseSensitive := False; // Make the filter case-insensitive

    // Use foOR for "match any column" logic
    if i > 0 then
      fd.Operation := foOR
    else
      fd.Operation := foNONE; // First filter has no logical operation
  end;

  // Apply the filters to the grid
  TMSFNCGrid1.ApplyFilter;
end;

end.