unit rOrderCutting;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, Common.Logging,
  frxClass, frxExportBaseDialog, frxExportPDF, frCoreClasses, frxDBSet, JS, JSON,
  frxTableObject, frxUtils;


type
  TrptOrderCutting = class(TDataModule)
    ucKG: TUniConnection;
    frxPDFExport1: TfrxPDFExport;
    frxDBOrderCutting: TfrxDBDataset;
    frxOrderCutting: TfrxReport;
    uqOrderCutting: TUniQuery;
    uqOrderCuttingORDER_ID: TIntegerField;
    uqOrderCuttingCOMPANY_ID: TIntegerField;
    uqOrderCuttingUSER_ID: TIntegerField;
    uqOrderCuttingORDER_DATE: TDateTimeField;
    uqOrderCuttingstaff_fields_order_date: TDateField;
    uqOrderCuttingstaff_fields_proof_date: TDateField;
    uqOrderCuttingstaff_fields_ship_date: TDateField;
    uqOrderCuttingstaff_fields_ship_via: TStringField;
    uqOrderCuttingstaff_fields_quantity: TStringField;
    uqOrderCuttingstaff_fields_price: TStringField;
    uqOrderCuttingstaff_fields_invoice_to: TStringField;
    uqOrderCuttingstaff_fields_ship_to: TStringField;
    uqOrderCuttingstaff_fields_po_number: TStringField;
    uqOrderCuttingstaff_fields_job_name: TStringField;
    uqOrderCuttingstaff_fields_quickbooks_item: TStringField;
    uqOrderCuttinggeneral_special_instructions: TStringField;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function PrepareReport(SQL: string): string;
    function GeneratePDF: string;
  end;

var
  rptOrderCutting: TrptOrderCutting;

implementation

uses
  uLibrary, Common.Config;

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TrptOrderCutting.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 1, 'TAuthDatabase.DataModuleCreate' );
  LoadDatabaseSettings( ucKG, 'kgOrdersServer.ini' );
  try
    ucKG.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TrptOrderList.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;


function TrptOrderCutting.PrepareReport(SQL: string): string;
var
  orderList : TJSObject;
  i: integer;
  data: TJSArray;
  order: TJSObject;
  callListLength: integer;
  tempString, strColorList: string;
  colorObject: TJSONObject;
  colorList: TJSArray;
  colorLength: integer;
  color: TJSObject;
  colorJSON: TJSONObject;
  colorListJSON: TJSONArray;
  items: TJSObject;
begin
  Logger.Log(3, 'Generated SQL for Prepare Report: ' + SQL);
  //SQL := 'select * from corrugated_plate_orders where ORDER_ID = 18381';
  doQuery(uqOrderCutting, SQL);



  result := GeneratePDF;

  Logger.Log(5, 'Report preparation complete.');
end;


function TrptOrderCutting.GeneratePDF: string;
var
  ReportDir, ReportFileName: string;
  reportURL: string;
begin
  ReportDir := ServerConfig.reportsFolder;

  if not DirectoryExists(ReportDir) then
  begin
    ForceDirectories(ReportDir);
    Logger.Log(1, 'Reports directory created: ' + ReportDir);
  end;
  reportURL :=  'reports\' + FormatDateTime('yyyymmdd_hhnnss', Now) + '.pdf';

  ReportFileName := reportDir + reportUrl;

  frxPDFExport1.FileName := ReportFileName;
  frxPDFExport1.ShowDialog := False;
  try
    frxOrderCutting.PrepareReport;
    frxOrderCutting.Export(frxPDFExport1);
    //frxOrders.ShowPreparedReport;
  finally
     frxOrderCutting.Clear; // Clears the report to avoid memory bloat
  end;

  Logger.Log(5, 'PDF saved to: ' + ReportFileName);
  result := reportURL;
end;


end.
