unit View.OrderEntryCuttingDie;

interface

uses
  System.SysUtils, System.Generics.Collections, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, WEBLib.Menus, WEBLib.ExtCtrls, WEBLib.StdCtrls,
  WEBLib.JSON, Auth.Service, XData.Web.Client, WebLib.Storage,
  ConnectionModule, App.Types, Vcl.StdCtrls, Vcl.Controls, WEBLib.DBCtrls,
  Data.DB, XData.Web.JsonDataset, XData.Web.Dataset, WEBLib.DB, VCL.Forms;

type
  TFOrderEntryCuttingDie = class(TWebForm)
    wdsOrder: TWebDataSource;
    xdwdsOrder: TXDataWebDataSet;
    xdwdsOrderORDER_DATE: TDateField;
    xdwdsOrderSHORT_NAME: TStringField;
    xdwdsOrderstaff_fields_ship_via: TStringField;
    xdwdsOrderstaff_fields_price: TStringField;
    xdwdsOrderstaff_fields_invoice_to: TStringField;
    xdwdsOrderstaff_fields_invoice_attention: TStringField;
    xdwdsOrderstaff_fields_ship_to: TStringField;
    xdwdsOrderstaff_fields_ship_attention: TStringField;
    xdwdsOrderstaff_fields_po_number: TStringField;
    xdwdsOrderstaff_fields_job_name: TStringField;
    xdwdsOrderstaff_fields_order_date: TStringField;
    xdwdsOrderstaff_fields_proof_date: TStringField;
    xdwdsOrderstaff_fields_ship_date: TStringField;
    XDataWebClient1: TXDataWebClient;
    WebLabel2: TWebLabel;
    edtCompanyAccountName: TWebDBEdit;
    edtQBOrderNum: TWebDBEdit;
    WebLabel1: TWebLabel;
    edtShipVia: TWebDBEdit;
    edtQuantity: TWebDBEdit;
    edtPrice: TWebDBEdit;
    edtInvoiceTo: TWebDBEdit;
    wdbcbShipTo: TWebDBComboBox;
    edtPONumber: TWebDBEdit;
    edtJobName: TWebDBEdit;
    wdsShipTo: TWebDataSource;
    xdwdsShipTo: TXDataWebDataSet;
    xdwdsShipToADDRESS: TStringField;
    WebLabel9: TWebLabel;
    edtSpecialInstructions: TWebDBEdit;
    btnSave: TWebButton;
    btnCancel: TWebButton;
    edtCompanyName: TWebDBEdit;
    xdwdsOrderNAME: TStringField;
    xdwdsOrderstaff_fields_quickbooks_item: TStringField;
    xdwdsOrdergeneral_special_instructions: TStringField;
    xdwdsOrderstaff_fields_quantity: TStringField;
    wdsQBItem: TWebDataSource;
    xdwdsQBItem: TXDataWebDataSet;
    xdwdsQBItemname: TStringField;
    btnPDF: TWebButton;
    btnDelete: TWebButton;
    btnClose: TWebButton;
    btnCopy: TWebButton;
    tmrReturn: TWebTimer;
    btnEdit: TWebButton;
    btnAdd: TWebButton;
    WebButton2: TWebButton;
    lblFormState: TWebLabel;
    wdbcbINQB: TWebDBCheckBox;
    xdwdsOrderQB_ESTIMATE_ID: TStringField;
    xdwdsOrderQB_ORDER_NUM: TStringField;
    xdwdsOrderUSER_ID: TIntegerField;
    xdwdsOrderCOMPANY_ID: TIntegerField;
    xdwdsOrderORDER_ID: TIntegerField;
    edtOrderNum: TWebDBEdit;
    xdwdsOrderIN_QB: TStringField;
    btnQB: TWebButton;
    dtpOrderDate: TWebDBDateTimePicker;
    dtpProofDate: TWebDBDateTimePicker;
    dtpShipDate: TWebDBDateTimePicker;
    xdwdsQBItemQB_ID: TStringField;
    xdwdsOrderQB_LIST_ID: TStringField;
    xdwdsQBItemdescription: TStringField;
    edtQBItemDescription: TWebEdit;
    wcbQBItem: TWebDBComboBox;
    procedure btnSaveClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure WebFormCreate(Sender: TObject);
    [async] procedure GetCuttingDieOrder(Order_ID: string);
    [async] procedure SetNewOrderInfo(customerID: string);
    [async] procedure SendCuttingDieOrder();
    procedure btnPDFClick(Sender: TObject);
    [async] procedure GenerateReportPDF;
    function VerifyOrder(): boolean;
    [async] procedure btnDeleteClick(Sender: TObject);
    [async] procedure delOrder();
    procedure btnCloseClick(Sender: TObject);
    procedure btnCopyClick(Sender: TObject);
    procedure tmrReturnTimer(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure ViewMode();
    procedure WebButton2Click(Sender: TObject);
    procedure ShowAddAddressForm();
    [async] procedure SendAddressToServer(AddressJSON: TJSONObject);
    procedure btnQBClick(Sender: TObject);
    procedure xdwdsOrderCalcFields(DataSet: TDataSet);
    [async] procedure AddEstimate(orderID: string);
    function VerifyQBOrder(): boolean;
    procedure wcbQBItemChange(Sender: TObject);
    procedure edtJobNameExit(Sender: TObject);
  private
    FAgencyCode: string;
    FCurrentReportType: string;
    FSelectProc: TSelectProc;
    orderID: string;
    customerID: string;
    customer_qb_id: string;
    mode: string;
    notification: string;
    REVISION_NOTES: string;
    procedure EditMode;
    [async] procedure InitializeForm;
  public
    class function CreateForm(AElementID, orderInfo, customerInfo, modeParam, info: string): TWebForm;
  end;

var
  FOrderEntryCuttingDie: TFOrderEntryCuttingDie;

implementation

{$R *.dfm}

uses
  View.Home, View.Main, View.AddOrder, View.AddAddress, Utils;


class function TFOrderEntryCuttingDie.CreateForm(AElementID, orderInfo, customerInfo, modeParam, info: string): TWebForm;
begin
  Application.CreateForm(TFOrderEntryCuttingDie, AElementID, Result,
    procedure(AForm: TObject)
    begin
      with TFOrderEntryCuttingDie(AForm) do
      begin
        customerID := customerInfo;
        orderID := orderInfo;
        mode := modeParam;
        notification := info;

        InitializeForm;
      end;
    end
  );
end;


[async] procedure TFOrderEntryCuttingDie.InitializeForm;
begin
  if mode = 'ADD' then
  begin
    await(SetNewOrderInfo(customerID));
    EditMode;
  end
  else
  begin
    await(getCuttingDieOrder(orderID));
    ViewMode;
  end;

  if notification <> '' then
    ShowToast(notification);
end;

procedure TFOrderEntryCuttingDie.AddEstimate(orderID: string);
var
  Response: TXDataClientResponse;
  notification: TJSObject;
  msg: string;
begin
  try
    Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.AddEstimate',
                [orderID]));
    notification := TJSObject(Response.Result);
    msg := string(notification['status']);
    Utils.HideSpinner('spinner');
    getCuttingDieOrder(xdwdsOrder.FieldByName('ORDER_ID').AsString);

    ShowToast(msg);
  except
      on E: EXDataClientRequestException do
        Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
    end;
end;

procedure TFOrderEntryCuttingDie.btnQBClick(Sender: TObject);
var
  orderJSON: TJSONObject;
begin
  if AuthService.TokenPayload.Properties['qb_enabled'] then
  begin
    if JS.toString(AuthService.TokenPayload.Properties['user_qb_id']) <> '' then
    begin
      if ( VerifyQBOrder() )then
      begin
        if wdbcbINQB.Checked = false  then
        begin
            Utils.ShowSpinner('spinner');
            orderJSON := TJSONObject.Create;
            orderJSON.AddPair('ORDER_ID', xdwdsOrder.FieldByName('ORDER_ID').AsString);
            orderJSON.AddPair('USER_ID', JS.toString(AuthService.TokenPayload.Properties['user_id']));
            addEstimate(orderJSON.ToString);
        end
        else
          ShowToast('Failure:Cannot submit orders already in QuickBooks', 'failure');
      end;
    end
    else
      ShowToast('Failure:User not authorized to add to QuickBooks', 'failure');
  end
  else
    ShowToast('QB interface not currently active', 'info');
end;

procedure TFOrderEntryCuttingDie.WebButton2Click(Sender: TObject);
begin
  ShowAddAddressForm();
end;


procedure TFOrderEntryCuttingDie.SendAddressToServer(AddressJSON: TJSONObject);
var
  Response: TXDataClientResponse;
  notification: TJSObject;
begin
  Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.AddShippingAddress',
              [AddressJSON.ToString]));
  notification := TJSObject(Response.Result);
  ShowToast(string(notification['status']));
  xdwdsShipTo.Close;
  xdwdsShipTo.SetJSONData(notification['ADDRESS']);
  xdwdsShipTo.Open;
end;


procedure TFOrderEntryCuttingDie.ShowAddAddressForm;
// displays the search pop-up that allows the user to filter the order list
var
  newform: TFViewAddAddress;
  AddressJSON: TJSONObject;
  ship_block: string;
begin
  newform := TFViewAddAddress.CreateNew;

  newform.Caption := 'Shipping Information';
  newForm.Popup := True;
  newForm.Border := fbDialog;
  newForm.Position := poScreenCenter;

  // used to manage Back button handling to close subform
  window.location.hash := 'subform';

  newform.ShowModal(
    procedure(AValue: TModalResult)
    var
      searchOptions: string;
    begin
      if newform.confirm then
      begin
        AddressJSON := TJSONObject.Create;

        AddressJSON.AddPair('address', newform.edtAddress.Text);
        AddressJSON.AddPair('city', newform.edtCity.Text);
        AddressJSON.AddPair('state', newform.edtState.Text);
        AddressJSON.AddPair('zip', newform.edtZip.Text);
        AddressJSON.AddPair('contact', newform.edtContact.Text);
        AddressJSON.AddPair('customer_id', xdwdsOrder.FieldByName('COMPANY_ID').AsString);

        ship_block := newform.edtFirstLine.Text + slinebreak +
                      edtCompanyName.Text + slinebreak +
                      newform.edtContact.Text + slinebreak +
                      newform.edtAddress.Text + slinebreak +
                      newform.edtCity.Text + ', ' + newform.edtState.Text + ' ' + newform.edtZip.Text;
        AddressJSON.AddPair('ship_block', ship_block);

        AddressJSON.AddPair('mode', 'ADD');
        sendAddressToServer(AddressJSON);
      end;
    end
  );
end;

procedure TFOrderEntryCuttingDie.btnSaveClick(Sender: TObject);
// Converts all the information on the page into a JSON to then send to the server
begin
  if VerifyOrder() then
  begin
    sendCuttingDieOrder();
    ViewMode();
  end;
  window.scrollTo(0, 0);
end;


procedure TFOrderEntryCuttingDie.btnCopyClick(Sender: TObject);
begin
  mode := 'ADD';
  xdwdsOrder.Edit;
  xdwdsOrder.FieldByName('staff_fields_order_date').AsDateTime := 0;
  xdwdsOrder.FieldByName('staff_fields_proof_date').AsDateTime := 0;
  xdwdsOrder.FieldByName('staff_fields_ship_date').AsDateTime := 0;
  xdwdsOrder.FieldByName('IN_QB').AsString := 'F';
  xdwdsOrder.FieldByName('QB_ORDER_NUM').AsString := '';
  REVISION_NOTES := 'Order was copied from ORDER_ID: ' + xdwdsOrder.FieldByName('ORDER_ID').AsString;
  xdwdsOrder.FieldByName('ORDER_ID').AsString := '';
  xdwdsOrder.Post;
  ShowToast('Success: Order Successfully Copied');
  EditMode();
  window.scrollTo(0, 0);
end;


[async] procedure TFOrderEntryCuttingDie.btnDeleteClick(Sender: TObject);
begin
  ShowConfirmationModal(
    'Are you sure you want to delete this order?',
    'Delete',
    'Cancel',
    procedure(confirmed: Boolean)
    begin
      if confirmed then
      begin
        Utils.ShowSpinner('spinner');
        DelOrder();
        tmrReturn.Enabled := true;
      end;
    end
  );
end;


procedure TFOrderEntryCuttingDie.btnEditClick(Sender: TObject);
begin
  EditMode;
end;


procedure TFOrderEntryCuttingDie.DelOrder();
var
  Response: TXDataClientResponse;
begin
  Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.DelOrder', [xdwdsOrder.FieldByName('ORDER_ID').AsString, 'cutting', JS.toString(AuthService.TokenPayload.Properties['user_id'])]));
end;


procedure TFOrderEntryCuttingDie.btnPDFClick(Sender: TObject);
begin
  GenerateReportPDF;
end;


[async] procedure TFOrderEntryCuttingDie.GenerateReportPDF;
// sends the search to the server which then sends back a pdf of the results
var
  xdcResponse: TXDataClientResponse;
  searchOptions, pdfURL: string;
  jsObject: TJSObject;
begin
  try
    // Call the server method to generate the PDF
    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GenerateOrderCuttingPDF', [xdwdsOrder.FieldByName('ORDER_ID').AsString]));
    jsObject := JS.TJSObject(xdcResponse.Result);
    pdfURL := JS.toString(jsObject.Properties['value']);

    // Open the PDF in a new browser tab without needing a different form
    // This method is much faster too, even for large datasets
    window.open(pdfURL, '_blank');
  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
end;


procedure TFOrderEntryCuttingDie.SendCuttingDieOrder();
// sends the order JSON object to the server
var
  Response: TXDataClientResponse;
  jsObj: TJSObject;
  orderJSON: TJSONObject;
  fieldNames: TStringList;
  itemList: TJSNodeList;
  header, value: string;
  Field: TField;
begin
   orderJSON := TJSONObject.Create;

    xdwdsOrder.Edit;
    xdwdsOrderUSER_ID.AsString := JS.toString(AuthService.TokenPayload.Properties['user_id']);
    xdwdsOrder.Post;

    xdwdsOrder.First;
    while not xdwdsOrder.Eof do
    begin
      for Field in xdwdsOrder.Fields do
      begin
        if Field is TStringField then
        begin
          if Field.AsString = '' then
            orderJSON.AddPair(Field.FieldName, '')
          else
            orderJSON.AddPair(Field.FieldName, Field.AsString);
        end
        else if Field is TBooleanField then
        begin
          if Field.AsBoolean then
            orderJSON.AddPair(Field.FieldName, 'T')
          else
            orderJSON.AddPair(Field.FieldName, 'F');
        end
        else if Field is TIntegerField then
          orderJSON.AddPair(Field.FieldName, Field.AsInteger);
      end;
      xdwdsOrder.Next;
    end;

    orderJSON.AddPair('mode', mode);
    orderJSON.AddPair('REVISION_NOTES', REVISION_NOTES);

  try
    Response := await(XDataWebClient1.RawInvokeAsync('ILookupService.AddCuttingDieOrder',
                [orderJSON.ToString]));
    jsObj := JS.TJSObject(Response.Result);

    xdwdsOrder.Close;
    xdwdsOrder.SetJsonData(jsObj);
    xdwdsOrder.Open;

    mode := 'EDIT';
    ShowToast(String(jsObj.Properties['status']));
  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
end;


procedure TFOrderEntryCuttingDie.btnAddClick(Sender: TObject);
var
  newform: TFAddOrder;
  orderType: string;
begin
  newform := TFAddOrder.CreateNew;

  newform.Caption := 'Select Customer and Order Type';
  newForm.Popup := True;
  newForm.Border := fbDialog;
  newForm.Position := poScreenCenter;

  // used to manage Back button handling to close subform
  window.location.hash := 'subform';

  newform.ShowModal(
    procedure(AValue: TModalResult)
    begin
      if newform.confirm then
      begin
        if newform.cbCorrugatedPlate.Checked then
          orderType := 'corrugated'
        else if newform.cbWebPlate.Checked then
          orderType := 'web'
        else
          orderType := 'cutting';

        if orderType = 'corrugated' then
          FViewMain.ViewOrderEntryCorrugated('', newForm.DBID, 'ADD', '')
        else if orderType = 'web' then
          FViewMain.ViewOrderEntryWeb('', newForm.DBID, 'ADD', '')
        else
          FViewMain.ViewOrderEntryCuttingDie('', newForm.DBID, 'ADD', '');
      end;
    end
  );
end;


procedure TFOrderEntryCuttingDie.btnCancelClick(Sender: TObject);
begin
  ShowConfirmationModal(
    'Are you sure you want to cancel all changes?',
    'Yes',
    'No',
    procedure(confirmed: Boolean)
    begin
      if confirmed then
      begin
        FViewMain.change := false;
        if xdwdsOrder.FieldByName('ORDER_ID').AsString <> '' then
          FViewMain.ViewOrderEntryCuttingDie(xdwdsOrder.FieldByName('ORDER_ID').AsString, '', 'EDIT', 'Failure:  Changes Discarded')
        else
          FViewMain.ViewOrders('');
      end;
    end
  );
end;


procedure TFOrderEntryCuttingDie.btnCloseClick(Sender: TObject);
begin
  FViewMain.ViewOrders('');
end;

procedure TFOrderEntryCuttingDie.WebFormCreate(Sender: TObject);
begin
  if not DMConnection.ApiConnection.Connected then
    DMConnection.ApiConnection.OpenAsync;
end;


procedure TFOrderEntryCuttingDie.xdwdsOrderCalcFields(DataSet: TDataSet);
begin
  if DataSet.FieldByName('IN_QB').IsNull then
    DataSet.FieldByName('IN_QB').AsBoolean := False;
end;

procedure TFOrderEntryCuttingDie.getCuttingDieOrder(Order_ID: string);
// retrieves an order from the server then loads the info into the page
var
  xdcResponse: TXDataClientResponse;
  orderList : TJSObject;
  i: integer;
  data: TJSArray;
  order, items, customer: TJSObject;
begin
  Utils.ShowSpinner('spinner');
  try
    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetCuttingDieOrder',
          [Order_ID]));
    order :=  TJSObject(xdcResponse.Result);
    data := TJSArray(order['data']);

    xdwdsOrder.Close;
    xdwdsOrder.SetJsonData(order);
    xdwdsOrder.Open;

    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetCustomer',
          [xdwdsOrder.FieldByName('COMPANY_ID').AsString]));

    customer :=  TJSObject(xdcResponse.Result);
    xdwdsShipTo.Close;
    xdwdsShipTo.SetJSONData(customer['SHIPPING_ADDRESS_LIST']);
    xdwdsShipTo.Open;

    customer_qb_id := string(customer['QB_LIST_ID']);

    xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetItems',
          []));

    items := TJSObject(xdcResponse.Result);
    xdwdsQBItem.Close;
    xdwdsQBItem.SetJsonData(items['data']);
    xdwdsQBITEM.Open;

    xdwdsQBItem.Locate('name', wcbQBItem.Text , []);
    wcbQBItem.Text := xdwdsQBItem.FieldByName('name').AsString;
    edtQBItemDescription.text := xdwdsQBItem.FieldByName('description').AsString +
                                ' - ' + xdwdsOrder.FieldByName('staff_fields_job_name').AsString;

  except
    on E: EXDataClientRequestException do
      Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
  end;
  Utils.HideSpinner('spinner');
end;


procedure TFOrderEntryCuttingDie.SetNewOrderInfo(customerID: string);
// Set new blank order and then gets the customer and items from the database
// then loads the appropiate fields
var
  xdcResponse: TXDataClientResponse;
  customer, items : TJSObject;
  address: string;
begin

  xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetCustomer',
        [customerID]));

  customer := TJSObject(xdcResponse.Result);
  customer_qb_id := string(customer['QB_LIST_ID']);

  xdwdsOrder.Close;
  xdwdsOrder.Open;
  xdwdsOrder.Append;
  xdwdsOrder.FieldByName('NAME').AsString := string(customer['NAME']);
  xdwdsOrder.FieldByName('SHORT_NAME').AsString := string(customer['SHORT_NAME']);
  xdwdsOrder.FieldByName('staff_fields_invoice_to').AsString := string(customer['staff_fields_invoice_to']);

  xdwdsOrder.FieldByName('COMPANY_ID').AsString := customerID;
  xdwdsOrder.Post;

  xdwdsShipTo.Close;
  xdwdsShipTo.SetJSONData(customer['SHIPPING_ADDRESS_LIST']);
  xdwdsShipTo.Open;

  xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.GetItems',
        []));

  items := TJSObject(xdcResponse.Result);
  xdwdsQBItem.Close;
  xdwdsQBItem.SetJsonData(items['data']);
  xdwdsQBITEM.Open;
end;


procedure TFOrderEntryCuttingDie.tmrReturnTimer(Sender: TObject);
begin
  Utils.HideSpinner('spinner');
  tmrReturn.Enabled := false;
  FViewMain.ViewOrders('Success: Order Successfully Deleted');
end;


procedure TFOrderEntryCuttingDie.EditMode;
begin
  xdwdsOrder.Edit;
  xdwdsQBItem.Edit;
  FViewMain.change := true;
  btnCopy.Enabled := false;
  btnPDF.Enabled := false;
  btnDelete.Enabled := false;
  btnClose.Enabled := false;
  btnSave.Enabled := true;
  btnCancel.Enabled := True;
  btnEdit.Enabled := false;
  btnAdd.Enabled := false;
  btnQB.Enabled := false;

  lblFormState.Caption := 'Edit Mode';
  lblFormState.ElementHandle.classList.remove('text-danger');
  lblFormState.ElementHandle.classList.add('text-success');
end;


procedure TFOrderEntryCuttingDie.edtJobNameExit(Sender: TObject);
begin
  edtQBItemDescription.text := xdwdsQBItem.FieldByName('description').AsString +
                              ' - ' + xdwdsOrder.FieldByName('staff_fields_job_name').AsString;
end;

procedure TFOrderEntryCuttingDie.ViewMode;
begin
  btnPDF.Enabled := true;
  btnDelete.Enabled := true;
  btnClose.Enabled := true;
  btnCopy.Enabled := true;
  btnSave.Enabled := false;
  btnCancel.Enabled := false;
  btnEdit.Enabled := true;
  btnAdd.Enabled := true;
  btnQB.Enabled := true;
  FViewMain.change := false;

  lblFormState.Caption := 'View Mode';
  lblFormState.ElementHandle.classList.remove('text-success');
  lblFormState.ElementHandle.classList.add('text-danger');
end;

procedure TFOrderEntryCuttingDie.wcbQBItemChange(Sender: TObject);
begin
  xdwdsQBItem.Locate('name', wcbQBItem.Text , []);
  wcbQBItem.Text := xdwdsQBItem.FieldByName('name').AsString;
  edtQBItemDescription.text := xdwdsQBItem.FieldByName('description').AsString +
                              ' - ' + xdwdsOrder.FieldByName('staff_fields_job_name').AsString;
end;

function TFOrderEntryCuttingDie.VerifyOrder: Boolean;
var
  input: TJSHTMLInputElement;
begin
  result := true;

  input := TJSHTMLInputElement(document.getElementById('edtcompanyname'));
  if edtCompanyName.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtjobname'));
  if edtJobName.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');


  input := TJSHTMLInputElement(document.getElementById('edtaccountcompanyname'));
  if edtCompanyAccountName.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtinvoiceto'));
  if edtInvoiceTo.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');


  input := TJSHTMLInputElement(document.getElementById('wcbshipto'));
  if wdbcbShipTo.Text = '' then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('dtporderdate'));
  if dtpOrderDate.Date = 0 then
  begin
    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtprice'));
  if edtPrice.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('edtquantity'));
  if edtQuantity.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');

  input := TJSHTMLInputElement(document.getElementById('wcbqbitem'));
  if wcbQBItem.Text = '' then
  begin

    input.classList.add('is-invalid');
    result := false;
  end
  else
    input.classList.remove('is-invalid');
end;

function TFOrderEntryCuttingDie.VerifyQBOrder: Boolean;
var
  msg, SQL: string;
begin
  Result := True;
  msg := 'To add an order to QuickBooks, the following must be present:' + sLineBreak;

  if edtCompanyName.Text = '' then
  begin
    msg := msg + '- Company Name cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtCompanyAccountName.Text = '' then
  begin
    msg := msg + '- Company ID cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtInvoiceTo.Text = '' then
  begin
    msg := msg + '- Invoice To cannot be empty' + sLineBreak;
    Result := False;
  end;

  if wdbcbShipTo.Text = '' then
  begin
    msg := msg + '- Ship To cannot be empty' + sLineBreak;
    Result := False;
  end;

  if dtpOrderDate.Date = 0 then
  begin
    msg := msg + '- Order Date cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtPrice.Text = '' then
  begin
    msg := msg + '- Price cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtQuantity.Text = '' then
  begin
    msg := msg + '- Quantity cannot be empty' + sLineBreak;
    Result := False;
  end;

  if wcbQBItem.Text = '' then
  begin
    msg := msg + '- Item cannot be empty' + sLineBreak;
    Result := False;
  end;

  if edtJobName.Text = '' then
  begin
    msg := msg + '- Job Name Cannot be empty' + sLineBreak;
    Result := False;
  end;

  xdwdsQBItem.Locate('name', xdwdsOrder.FieldByName('staff_fields_quickbooks_item').AsString, []);
  if xdwdsQBItem.FieldByName('QB_ID').AsString = '' then
  begin
    msg := msg + '- Item Must be Linked to QuickBooks' + sLineBreak;
    Result := False;
  end;

  if customer_qb_id = '' then
  begin
    msg := msg + '- Customer Must be Linked to QuickBooks' + sLineBreak;
    Result := False;
  end;

  if not result then
  asm
    alert(msg);
  end;
end;

initialization
  RegisterClass(TFOrderEntryCuttingDie);

end.