unit View.Main;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, WEBLib.ExtCtrls, Vcl.Controls, Vcl.StdCtrls,
  WEBLib.StdCtrls, Data.DB, XData.Web.JsonDataset, XData.Web.Dataset,
  App.Types, ConnectionModule, XData.Web.Client, WEBLib.Menus, Utils;

type
  TFViewMain = class(TWebForm)
    wllblLogout: TWebLinkLabel;
    WebPanel1: TWebPanel;
    WebMessageDlg1: TWebMessageDlg;
    WebMemo1: TWebMemo;
    XDataWebClient: TXDataWebClient;
    lblVersion: TWebLabel;
    lblAppTitle: TWebLabel;
    procedure WebFormCreate(Sender: TObject);
    procedure mnuLogoutClick(Sender: TObject);
    procedure wllblLogoutClick(Sender: TObject);
  private
    { Private declarations }
    FUserInfo: string;
    FSearchSettings: string;
    FChildForm: TWebForm;
    FLogoutProc: TLogoutProc;
    FSearchProc: TSearchProc;
    procedure ShowCrudForm( AFormClass: TWebFormClass );
    procedure ConfirmLogout;
  public
    { Public declarations }
    class procedure Display(LogoutProc: TLogoutProc);
    procedure ShowForm( AFormClass: TWebFormClass );
    var
      search: string;
      change: boolean;
  end;

var
  FViewMain: TFViewMain;

implementation

uses
  Auth.Service,
  View.Tasks,
  View.TasksHTML,
  View.TasksDataGrid,
  View.TasksDBGrid;

{$R *.dfm}

class procedure TFViewMain.Display(LogoutProc: TLogoutProc);
begin
  if Assigned(FViewMain) then
    FViewMain.Free;
  FViewMain := TFViewMain.CreateNew;
  FViewMain.FLogoutProc := LogoutProc;
end;

procedure TFViewMain.WebFormCreate(Sender: TObject);
begin
  console.log('TFViewMain.WebFormCreate fired');

  FChildForm := nil;
  console.log('About to ShowForm(TFTasksHTML), host=' + WebPanel1.ElementID);
  ShowForm(TFTasksHTML);
  lblAppTitle.Caption := 'emT3web';
  lblVersion.Caption := 'v' + DMConnection.clientVersion;
end;



procedure TFViewMain.mnuLogoutClick(Sender: TObject);
begin
  ConfirmLogout;
end;


procedure TFViewMain.wllblLogoutClick(Sender: TObject);
begin
  ConfirmLogout;
end;


procedure TFViewMain.ConfirmLogout;
begin
  ShowConfirmationModal(
    'End this session?.',
    'Yes',
    'No',
    procedure(confirmed: Boolean)
    begin
      if confirmed and Assigned(FLogoutProc) then
        FLogoutProc('');
    end
  );
end;


procedure TFViewMain.ShowCrudForm(AFormClass: TWebFormClass);
begin
  ShowForm(AFormClass);
end;


procedure TFViewMain.ShowForm(AFormClass: TWebFormClass);
begin
  if Assigned(FChildForm) then
    FChildForm.Free;
  Application.CreateForm(AFormClass, WebPanel1.ElementID, FChildForm);
end;

//procedure TFViewMain.ShowTasksForm(Info: string);
//begin
//  if Assigned(FChildForm) then
//    FChildForm.Free;
//  FChildForm := TFViewUsers.CreateForm(WebPanel1.ElementID, Info);
//end;

end.
