unit View.Tasks;

interface

uses
  System.SysUtils, System.Classes,
  JS, Web, WEBLib.Graphics, WEBLib.Controls, WEBLib.Forms, WEBLib.Dialogs,
  VCL.TMSFNCTypes, VCL.TMSFNCUtils, VCL.TMSFNCGraphics, VCL.TMSFNCGraphicsTypes,
  VCL.TMSFNCDataGridCell, VCL.TMSFNCDataGridData, VCL.TMSFNCDataGridBase,
  VCL.TMSFNCDataGridCore, VCL.TMSFNCDataGridRenderer, VCL.TMSFNCCustomControl,
  VCL.TMSFNCDataGrid,
  XData.Web.Client,
  Utils, WEBLib.ExtCtrls, System.Rtti, Vcl.Controls;

type
  TFTasks = class(TWebForm)
    xdwcTasks: TXDataWebClient;
    pnlGrid: TWebPanel;
    grdTasks: TTMSFNCDataGrid;
    procedure WebFormCreate(Sender: TObject);
  private
    [async] procedure LoadTasks(const AProjectId: string);
  public
  end;

var
  FTasks: TFTasks;

implementation

uses
  ConnectionModule;

{$R *.dfm}

const
  COL_TASK_ITEM_ID = 0;
  COL_TASK_ID = 1;
  COL_APP = 2;
  COL_VERSION = 3;
  COL_TASK_DATE = 4;
  COL_REPORTED_BY = 5;
  COL_ASSIGNED_TO = 6;
  COL_STATUS = 7;
  COL_STATUS_DATE = 8;
  COL_FIXED_VER = 9;
  COL_FORM_SECTION = 10;
  COL_ISSUE = 11;
  COL_NOTES = 12;

procedure TFTasks.WebFormCreate(Sender: TObject);
begin
  xdwcTasks.Connection := DMConnection.ApiConnection;
  LoadTasks('WPR0001');
end;

[async] procedure TFTasks.LoadTasks(const AProjectId: string);
var
  response: TXDataClientResponse;
  resultObj: TJSObject;
  tasksArray: TJSArray;
  taskObj: TJSObject;
  itemsArray: TJSArray;
  itemObj: TJSObject;
  taskIndex, itemIndex: Integer;
  gridRow: Integer;
  statusDateVal: JSValue;
begin
  Utils.ShowSpinner('spinner');
  try
    try
      response := await(xdwcTasks.RawInvokeAsync(
        'IApiService.GetProjectTasks', [AProjectId]
      ));

      if not Assigned(response.Result) then
        Exit;

      resultObj := TJSObject(response.Result);
      tasksArray := TJSArray(resultObj['data']);

      grdTasks.BeginUpdate;
      try
        grdTasks.RowCount := 1;
        gridRow := 1;

        for taskIndex := 0 to tasksArray.Length - 1 do
        begin
          taskObj := TJSObject(tasksArray[taskIndex]);
          itemsArray := TJSArray(taskObj['items']);

          for itemIndex := 0 to itemsArray.Length - 1 do
          begin
            itemObj := TJSObject(itemsArray[itemIndex]);

            grdTasks.RowCount := gridRow + 1;

            grdTasks.Cells[COL_TASK_ITEM_ID, gridRow] := string(itemObj['taskItemId']);
            grdTasks.Cells[COL_TASK_ID, gridRow] := string(itemObj['taskId']);
            grdTasks.Cells[COL_APP, gridRow] := string(itemObj['application']);
            grdTasks.Cells[COL_VERSION, gridRow] := string(itemObj['version']);
            grdTasks.Cells[COL_TASK_DATE, gridRow] := string(itemObj['taskDate']);
            grdTasks.Cells[COL_REPORTED_BY, gridRow] := string(itemObj['reportedBy']);
            grdTasks.Cells[COL_ASSIGNED_TO, gridRow] := string(itemObj['assignedTo']);
            grdTasks.Cells[COL_STATUS, gridRow] := string(itemObj['status']);

            statusDateVal := itemObj['statusDate'];
            if JS.isNull(statusDateVal) or JS.isUndefined(statusDateVal) then
              grdTasks.Cells[COL_STATUS_DATE, gridRow] := ''
            else
              grdTasks.Cells[COL_STATUS_DATE, gridRow] := string(statusDateVal);

            grdTasks.Cells[COL_FIXED_VER, gridRow] := string(itemObj['fixedVersion']);
            grdTasks.Cells[COL_FORM_SECTION, gridRow] := string(itemObj['formSection']);
            grdTasks.Cells[COL_ISSUE, gridRow] := string(itemObj['issue']);
            grdTasks.Cells[COL_NOTES, gridRow] := string(itemObj['notes']);

            Inc(gridRow);
          end;
        end;
      finally
        grdTasks.EndUpdate;
      end;

    except
      on E: EXDataClientRequestException do
        Utils.ShowErrorModal(E.ErrorResult.ErrorMessage);
    end;
  finally
    Utils.HideSpinner('spinner');
  end;
end;

end.

