program emT3webClient;

uses
  Vcl.Forms,
  System.SysUtils,
  JS,
  Web,
  XData.Web.Connection,
  WEBLib.Dialogs,
  Auth.Service in 'Auth.Service.pas',
  App.Types in 'App.Types.pas',
  ConnectionModule in 'ConnectionModule.pas' {DMConnection: TWebDataModule},
  View.Login in 'View.Login.pas' {FViewLogin: TWebForm} {*.html},
  App.Config in 'App.Config.pas',
  View.Main in 'View.Main.pas' {FViewMain: TWebForm} {*.html},
  Utils in 'Utils.pas',
  View.Tasks in 'View.Tasks.pas' {FTasks: TWebForm} {*.html},
  View.TasksHTML in 'View.TasksHTML.pas' {FTasksHTML: TWebForm} {*.html},
  View.TasksDataGrid in 'View.TasksDataGrid.pas' {FTasksDataGrid: TWebForm} {*.html},
  View.TasksTabulator in 'View.TasksTabulator.pas' {FTasksTabulator: TWebForm} {*.html},
  View.TasksDBGrid in 'View.TasksDBGrid.pas' {FTasksDBGrid: TWebForm} {*.html};

{$R *.res}

procedure DisplayAccessDeniedModal(const ErrorMessage: string);
begin
  asm
    var dlg = document.createElement("dialog");
    dlg.classList.add("shadow", "rounded", "border", "p-4");
    dlg.style.maxWidth = "500px";
    dlg.style.width = "90%";
    dlg.style.fontFamily = "system-ui, sans-serif";

    dlg.innerHTML =
      "<h5 class='fw-bold mb-3 text-danger'>emT3web</h5>" +
      "<p class='mb-3' style='white-space: pre-wrap;'>" + ErrorMessage + "</p>" +
      "<div class='text-end'>" +
      "<button id='actionBtn' class='btn btn-primary'></button></div>";

    document.body.appendChild(dlg);
    dlg.showModal();

    var btn = document.getElementById("actionBtn");

    if (
      (ErrorMessage.indexOf("Version mismatch") >= 0) ||
      (ErrorMessage.indexOf("old version") >= 0)
    ) {
      btn.textContent = "Reload";
      btn.addEventListener("click", function () {
        location.reload(true);
      });
    } else {
      btn.textContent = "Close";
      btn.addEventListener("click", function () {
        dlg.close();
        dlg.remove();
      });
    }
  end;
end;

procedure DisplayLoginView(AMessage: string = '');
begin
  AuthService.Logout;
  DMConnection.ApiConnection.Connected := False;

  if Assigned(FViewMain) then
    FViewMain.Free;

  if AMessage = '' then
    DisplayAccessDeniedModal('Access requires a valid emt3 link. Please reopen from emt3.')
  else
    DisplayAccessDeniedModal(AMessage);
end;

procedure DisplayMainView;

  procedure ConnectProc;
  begin
    if Assigned(FViewLogin) then
      FViewLogin.Free;

    TFViewMain.Display(@DisplayLoginView);
  end;

begin
  if not DMConnection.ApiConnection.Connected then
    DMConnection.ApiConnection.Open(@ConnectProc)
  else
    ConnectProc;
end;

procedure UnauthorizedAccessProc(AMessage: string);
begin
  DisplayLoginView(AMessage);
end;

procedure SaveUrlParamsToStorage(const userId, taskId, code: string);
begin
  if userId <> '' then
    window.localStorage.setItem('EMT3_USER_ID', userId);
  if taskId <> '' then
    window.localStorage.setItem('EMT3_TASK_ID', taskId);
  if code <> '' then
    window.localStorage.setItem('EMT3_CODE', code);
end;

procedure StartApplication;
var
  UserIdParam: string;
  TaskIdParam: string;
  CodeParam: string;
begin
  UserIdParam := Application.Parameters.Values['user_id'];
  TaskIdParam := Application.Parameters.Values['task_id'];
  CodeParam := Application.Parameters.Values['code'];

  SaveUrlParamsToStorage(UserIdParam, TaskIdParam, CodeParam);

  DMConnection.InitApp(
    procedure
    begin
      DMConnection.SetClientConfig(
        procedure(Success: Boolean; ErrorMessage: string)
        begin
          if Success then
          begin
            if (UserIdParam <> '') and (TaskIdParam <> '') and (CodeParam <> '') then
            begin
              AuthService.Login(
                UserIdParam, TaskIdParam, CodeParam,
                procedure
                begin
                  DisplayMainView;
                end,
                procedure(LoginError: string)
                begin
                  DisplayLoginView('Invalid or expired link.' + sLineBreak + LoginError);
                end
              );
              Exit;
            end;

            if AuthService.Authenticated and (not AuthService.TokenExpired) then
              DisplayMainView
            else
              DisplayLoginView;
          end
          else
          begin
            DisplayAccessDeniedModal(ErrorMessage);
          end;
        end);
    end,
    @UnauthorizedAccessProc
  );
end;

begin
  Application.Initialize;
  Application.MainFormOnTaskbar := True;
  Application.CreateForm(TDMConnection, DMConnection);
  StartApplication;
  Application.Run;
end.
