unit Api.Database;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, UniProvider,
  PostgreSQLUniProvider, System.Variants, System.Generics.Collections, System.IniFiles,
  Common.Logging, Vcl.Forms, MySQLUniProvider;

type
  TApiDatabase = class(TDataModule)
    ucETaskApi: TUniConnection;
    MySQLUniProvider1: TMySQLUniProvider;
    uqUsers: TUniQuery;
    uqUsersUSER_ID: TIntegerField;
    uqUsersNAME: TStringField;
    uqUsersSTATUS: TStringField;
    uqUsersREPRESENTATIVE: TStringField;
    uqSaveTaskRow: TUniQuery;
    uqWebTasks: TUniQuery;
    uqWebTasksTASK_ITEM_ID: TStringField;
    uqWebTasksTASK_ID: TStringField;
    uqWebTasksPROJECT_ID: TStringField;
    uqWebTasksAPPLICATION: TStringField;
    uqWebTasksAPP_VERSION: TStringField;
    uqWebTasksTASK_DATE: TDateField;
    uqWebTasksSTATUS_DATE: TDateField;
    uqWebTasksREPORTED_BY: TStringField;
    uqWebTasksASSIGNED_TO: TStringField;
    uqWebTasksSTATUS: TStringField;
    uqWebTasksFIXED_VERSION: TStringField;
    uqWebTasksFORM_SECTION: TStringField;
    uqWebTasksISSUE: TStringField;
    uqWebTasksNOTES: TStringField;
    uqEnsureBlankRow: TUniQuery;
    procedure DataModuleCreate(Sender: TObject);
    procedure uqUsersCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ApiDatabase: TApiDatabase;

implementation

uses
  uLibrary;
{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TApiDatabase.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 5, 'TApiDatabase.DataModuleCreate' );
  LoadDatabaseSettings( ucETaskApi, 'emT3webServer.ini' );
  try
    ucETaskApi.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TApiDatabase.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;

procedure TApiDatabase.uqUsersCalcFields(DataSet: TDataSet);
begin
  uqUsersREPRESENTATIVE.AsString := uqUsersNAME.AsString + '(' + uqUsersSTATUS.AsString + ')';
end;

end.
