unit Api.Service;

interface

uses
  XData.Service.Common,
  System.Generics.Collections,
  System.Classes,
  System.SysUtils,
  Aurelius.Mapping.Attributes,
  System.JSON,
  Common.Logging;

const
  API_MODEL = 'Api';

type
  TTaskItem = class
  public
    taskItemId: string;
    taskId: string;
    projectId: string;

    application: string;
    version: string;

    taskDate: TDateTime;
    reportedBy: string;
    assignedTo: string;

    status: string;
    statusDate: Variant;

    fixedVersion: string;
    formSection: string;

    issue: string;
    notes: string;
  end;

  TTask = class
  public
    taskId: string;
    projectId: string;
    items: TList<TTaskItem>;
    constructor Create;
    destructor Destroy; override;
  end;

  TTasksList = class
  public
    count: integer;
    data: TList<TTask>;
    constructor Create;
    destructor Destroy; override;
  end;

  TTaskRowSave = class
  public
    taskItemId: string;
    taskId: string;
    projectId: string;
    application: string;
    version: string;
    taskDate: string;
    reportedBy: string;
    assignedTo: string;
    status: string;
    statusDate: string;
    fixedVersion: string;
    formSection: string;
    issue: string;
    notes: string;
  end;

type
  [ServiceContract, Model(API_MODEL)]
  IApiService = interface(IInvokable)
    ['{0EFB33D7-8C4C-4F3C-9BC3-8B4D444B5F69}']
    function GetTaskItems(taskId: string): TTasksList;
    [HttpPost] function SaveTaskRow(const Item: TTaskRowSave): Boolean;
  end;

implementation

constructor TTask.Create;
begin
  inherited;
  items := TList<TTaskItem>.Create;
end;

destructor TTask.Destroy;
begin
  items.Free;
  inherited;
end;

constructor TTasksList.Create;
begin
  inherited;
  data := TList<TTask>.Create;
end;

destructor TTasksList.Destroy;
begin
  data.Free;
  inherited;
end;

initialization
  RegisterServiceType(TypeInfo(IApiService));



end.
