// Auth Database to verify logins

unit Auth.Database;

interface

uses
  System.SysUtils, System.Classes, IniFiles, Vcl.Forms, MemDS,
  Data.DB, DBAccess, Uni, UniProvider, PostgreSQLUniProvider, MySQLUniProvider;

type
  TAuthDatabase = class(TDataModule)
    uqWebTasksUrl: TUniQuery;
    ucETaskAuth: TUniConnection;
    MySQLUniProvider1: TMySQLUniProvider;
    uqWebTasksUrlUSER_ID: TStringField;
    uqWebTasksUrlUSER_NAME: TStringField;
    uqWebTasksUrlNAME: TStringField;
    uqWebTasksUrlSTATUS: TStringField;
    uqWebTasksUrlEMAIL: TStringField;
    uqWebTasksUrlACCESS_LEVEL: TIntegerField;
    uqWebTasksUrlTASK_RIGHTS: TIntegerField;
    uqWebTasksUrlPERSPECTIVE_ID: TStringField;
    uqWebTasksUrlLAST_NAME: TStringField;
    uqWebTasksUrlFIRST_NAME: TStringField;
    uqWebTasksUrlURL_TIME: TDateTimeField;
    uqWebTasksUrlURL_TIME_EXP: TIntegerField;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AuthDatabase: TAuthDatabase;

implementation

uses
  System.JSON,
  Common.Config,
  Common.Logging,
  uLibrary;

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TAuthDatabase.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 5, 'TAuthDatabase.DataModuleCreate' );
  LoadDatabaseSettings( ucETaskAuth, 'emT3WebServer.ini' );
  try
    ucETaskAuth.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TAuthDatabase.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;

procedure TAuthDatabase.DataModuleDestroy(Sender: TObject);
begin
  ucETaskAuth.Connected := false;
end;


end.
