unit uLibrary;

interface

uses
  System.Classes, Uni;

procedure LoadDatabaseSettings( uc: TUniConnection; iniFilename: string );
procedure DoQuery( uq: TUniQuery; sql: string );

implementation

uses
  System.SysUtils,
  System.IniFiles,
  Vcl.Forms,
  Data.DB;

procedure LoadDatabaseSettings( uc: TUniConnection; iniFilename: string );
var
  iniFile: TIniFile;
begin
  iniFile := TIniFile.Create( ExtractFilePath(Application.ExeName) + iniFilename );
  try
    uc.Server := iniFile.ReadString('Database', 'Server', uc.Server);
    uc.Database := iniFile.ReadString('Database', 'Database', uc.Database);
    uc.Username := iniFile.ReadString('Database', 'Username', uc.Username);
    uc.Password := iniFile.ReadString('Database', 'Password', uc.Password);
  finally
    iniFile.Free;
  end;
end;

procedure DoQuery(uq: TUniQuery; sql: string);
begin
  uq.Close;
  uq.SQL.Text := sql;
  uq.Open;
end;


end.
