unit Api.Database;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, UniProvider,
  PostgreSQLUniProvider, System.Variants, System.Generics.Collections, System.IniFiles,
  Common.Logging, Vcl.Forms, MySQLUniProvider;

type
  TApiDatabase = class(TDataModule)
    ucEmT3: TUniConnection;
    MySQLUniProvider1: TMySQLUniProvider;
    uqUsers: TUniQuery;
    uqUsersUSER_ID: TIntegerField;
    uqUsersNAME: TStringField;
    uqUsersSTATUS: TStringField;
    uqUsersREPRESENTATIVE: TStringField;
    uqProjectTasks: TUniQuery;
    uqProjectTasksTASK_ITEM_ID: TStringField;
    uqProjectTasksTASK_ID: TStringField;
    uqProjectTasksPROJECT_ID: TStringField;
    uqProjectTasksAPPLICATION: TStringField;
    uqProjectTasksAPP_VERSION: TStringField;
    uqProjectTasksTASK_DATE: TDateField;
    uqProjectTasksREPORTED_BY: TStringField;
    uqProjectTasksASSIGNED_TO: TStringField;
    uqProjectTasksSTATUS: TStringField;
    uqProjectTasksSTATUS_DATE: TDateField;
    uqProjectTasksFIXED_VERSION: TStringField;
    uqProjectTasksFORM_SECTION: TStringField;
    uqProjectTasksISSUE: TStringField;
    uqProjectTasksNOTES: TStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure uqUsersCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ApiDatabase: TApiDatabase;

implementation

uses
  uLibrary;
{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TApiDatabase.DataModuleCreate(Sender: TObject);
begin
  Logger.Log( 1, 'TApiDatabase.DataModuleCreate' );
  LoadDatabaseSettings( ucEmT3, 'emT3webServer.ini' );
  try
    ucEmT3.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TApiDatabase.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;

procedure TApiDatabase.uqUsersCalcFields(DataSet: TDataSet);
begin
  uqUsersREPRESENTATIVE.AsString := uqUsersNAME.AsString + '(' + uqUsersSTATUS.AsString + ')';
end;

end.
