unit Api.Service;

interface

uses
  XData.Service.Common,
  System.Generics.Collections,
  System.Classes,
  System.SysUtils;

const
  API_MODEL = 'Api';

type
  TTaskItem = class
  public
    taskItemId: string;
    taskId: string;
    projectId: string;

    application: string;
    version: string;

    taskDate: TDateTime;
    reportedBy: string;
    assignedTo: string;

    status: string;
    statusDate: TDateTime;

    fixedVersion: string;
    formSection: string;

    issue: string;
    notes: string;
  end;

  TTask = class
  public
    taskId: string;
    projectId: string;
    items: TList<TTaskItem>;
    constructor Create;
    destructor Destroy; override;
  end;

  TTasksList = class
  public
    count: integer;
    data: TList<TTask>;
    constructor Create;
    destructor Destroy; override;
  end;

  [ServiceContract]
  IApiService = interface(IInvokable)
    ['{A8CBF627-BB64-4A53-821C-9A84C2752248}']

  end;

  [ServiceContract]
  ITasksService = interface(IInvokable)
    ['{D5E1B7A2-6A9D-4D9A-9F7F-9A3E8A9E3B11}']
    [HttpGet] function GetProjectTasks(projectId: string): TTasksList;
  end;

implementation

constructor TTask.Create;
begin
  inherited;
  items := TList<TTaskItem>.Create;
end;

destructor TTask.Destroy;
begin
  items.Free;
  inherited;
end;

constructor TTasksList.Create;
begin
  inherited;
  data := TList<TTask>.Create;
end;

destructor TTasksList.Destroy;
begin
  data.Free;
  inherited;
end;

initialization
  RegisterServiceType(TypeInfo(ITasksService));

end.
