unit Api.Database;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, UniProvider,
  PostgreSQLUniProvider, System.Variants, System.Generics.Collections, System.IniFiles,
  Common.Logging, Vcl.Forms, MySQLUniProvider, Common.Ini;

type
  TApiDatabase = class(TDataModule)
    UniQuery1: TUniQuery;
    MySQLUniProvider1: TMySQLUniProvider;
    UniQuery2: TUniQuery;
    ucHST: TUniConnection;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    class procedure ExecSQL(const SQL: string);
  end;

var
  ApiDatabase: TApiDatabase;

implementation

uses
  uLibrary;
{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TApiDatabase.DataModuleCreate(Sender: TObject);
begin
  Logger.Log(5, 'TApiDatabase.DataModuleCreate');
  try
    ucHST.Database := IniEntries.dbDatabase;
    ucHST.Server := IniEntries.dbServer;
    ucHST.Port := IniEntries.dbPort;
    ucHST.Username := IniEntries.dbUsername;
    ucHST.Password := IniEntries.dbPassword;
    ucHST.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TAuthDatabase.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;

class procedure TApiDatabase.ExecSQL(const SQL: string);
var
  DB: TApiDatabase;
begin
  DB := TApiDatabase.Create(nil);
  try
    DB.UniQuery1.SQL.Text := SQL;
    DB.UniQuery1.ExecSQL;
  finally
    DB.Free;
  end;
end;

end.
