unit Common.Ini;

interface

uses
  System.SysUtils, System.IniFiles, Vcl.Forms;

type
  TIniEntries = class
  private
    // [Settings]
    FConsoleLogLevel: Integer;
    FFileLogLevel: Integer;
    FLogFileNum: Integer;
    FJWTSecret: string;

    // [Database]
    FDBServer: string;
    FDBPort: Integer;
    FDBDatabase: string;
    FDBUsername: string;
    FDBPassword: string;

  public
    constructor Create;

    // Properties
    property consoleLogLevel: Integer read FConsoleLogLevel;
    property fileLogLevel: Integer read FFileLogLevel;
    property logFileNum: Integer read FLogFileNum;

    property dbServer: string read FDBServer;
    property dbPort: Integer read FDBPort;
    property dbDatabase: string read FDBDatabase;
    property dbUsername: string read FDBUsername;
    property dbPassword: string read FDBPassword;

end;

procedure LoadIniEntries;

var
  IniEntries: TIniEntries;

implementation

procedure LoadIniEntries;
begin
  if Assigned(IniEntries) then
    IniEntries.Free;
  IniEntries := TIniEntries.Create;
end;

{ TIniEntries }

constructor TIniEntries.Create;
var
  iniFile: TIniFile;
begin
  iniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  try
    // [Settings]
    FConsoleLogLevel := iniFile.ReadInteger('Settings', 'ConsoleLogLevel', 3);
    FFileLogLevel := iniFile.ReadInteger('Settings', 'FileLogLevel', 3);
    FLogFileNum := iniFile.ReadInteger('Settings', 'LogFileNum', 0);

    // [Database]
    FDBServer := iniFile.ReadString('Database', 'Server', '10.208.1.13');
    FDBPort := iniFile.ReadInteger('Database', 'Port', 0);
    FDBDatabase := iniFile.ReadString('Database', 'Database', 'sleepdb');
    FDBUsername := iniFile.ReadString('Database', 'Username', 'hstuser');
    FDBPassword := iniFile.ReadString('Database', 'Password', 'emsys!01');
  finally
    iniFile.Free;
  end;
end;


end.

