unit Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, Winapi.ShellApi,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.StdCtrls, Vcl.ExtCtrls, ExeInfo, System.StrUtils;

type
  TFMain = class(TForm)
    memoLogs: TMemo;
    btnSwaggerApi: TButton;
    btnSwaggerAuth: TButton;
    btnExit: TButton;
    timerStartServer: TTimer;
    exeInfoVersion: TExeInfo;
    procedure btnSwaggerApiClick(Sender: TObject);
    procedure btnSwaggerAuthClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure timerStartServerTimer(Sender: TObject);
  strict private
    procedure StartServers;
    function LogValue(const labelName: string; const value: string; fromIni: Boolean): string;
  end;

var
  FMain: TFMain;

implementation

uses
  Common.Logging,
  Common.Config,
  Common.Ini,
  Auth.Server.Module,
  Api.Server.Module,
  App.Server.Module,
  Api.Service,
  Auth.Service,
  Sparkle.Utils;

{$R *.dfm}

procedure TFMain.btnSwaggerApiClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open',
    PChar(TSparkleUtils.CombineUrlFast(ApiServerModule.XDataServer.BaseUrl, 'swaggerui')),
    nil, nil, SW_SHOWNORMAL);
end;

procedure TFMain.btnSwaggerAuthClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open',
    PChar(TSparkleUtils.CombineUrlFast(AuthServerModule.XDataServer.BaseUrl, 'swaggerui')),
    nil, nil, SW_SHOWNORMAL);
end;

procedure TFMain.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TFMain.timerStartServerTimer(Sender: TObject);
begin
  timerStartServer.Enabled := False;
  Caption := Caption + ' ver ' + exeInfoVersion.FileVersion;
  LoadIniEntries;
  LoadServerConfig;
  StartServers;
end;

function TFMain.LogValue(const labelName: string; const value: string; fromIni: Boolean): string;
begin
  Result := labelName + ': ' + value + IfThen(fromIni, ' [from ini]', ' [default]');
end;

procedure TFMain.StartServers;
begin
  Logger.Log(1, '');
  Logger.Log(1, '******************************************************');
  Logger.Log(1, '                 template Server                      ');
  Logger.Log(1, Format('              Version: %s               ', [exeInfoVersion.FileVersion]));
  Logger.Log(1, '                                                      ');
  Logger.Log(1, '                   by EM Systems, Inc.                ');
  Logger.Log(1, '******************************************************');
  Logger.Log(1, '');

  Logger.Log(1, '--- Database ---');
  Logger.Log(1, '--Database->Server: ' + IniEntries.dbServer);
  Logger.Log(1, '--Database->Port: ' + IniEntries.dbPort.ToString);
  Logger.Log(1, '--Database->Database: ' + IniEntries.dbDatabase);
  Logger.Log(1, '--Database->Username: ' + IniEntries.dbUsername);
  Logger.Log(1, '--Database->Password: ' + IniEntries.dbPassword);
  Logger.Log(1, '');

  Logger.Log(1, '--- Settings ---');
  Logger.Log(1, '--Settings->ConsoleLogLevel: ' + IniEntries.consoleLogLevel.ToString);
  Logger.Log(1, '--Settings->FileLogLevel: ' + IniEntries.fileLogLevel.ToString);
  Logger.Log(1, '--Settings->LogFileNum: ' + IniEntries.logFileNum.ToString);
  Logger.Log(1, '');

  try
    AuthServerModule := TAuthServerModule.Create(Self);
    AuthServerModule.StartAuthServer(ServerConfig.url, AUTH_MODEL);

    ApiServerModule := TApiServerModule.Create(Self);
    ApiServerModule.StartApiServer(ServerConfig.url, API_MODEL);

    AppServerModule := TAppServerModule.Create(Self);
    AppServerModule.StartAppServer(ServerConfig.url);

    Logger.Log(1, '');
  except
    on E: Exception do
      Logger.Log(2, 'Failed to start server modules: ' + E.Message);
  end;
end;

procedure TFMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  AuthServerModule.Free;
  ApiServerModule.Free;
  AppServerModule.Free;
  IniEntries.Free;
end;

end.
