program webTemplateApp;

uses
  Vcl.Forms,
  XData.Web.Connection,
  WEBLib.Dialogs,
  Auth.Service in 'Auth.Service.pas',
  App.Types in 'App.Types.pas',
  ConnectionModule in 'ConnectionModule.pas' {DMConnection: TWebDataModule},
  App.Config in 'App.Config.pas',
  View.Main in 'View.Main.pas' {FViewMain: TWebForm} {*.html},
  Utils in 'Utils.pas',
  View.Login in 'View.Login.pas' {FViewLogin: TWebForm} {*.html},
  View.Test in 'View.Test.pas' {FTest: TWebForm} {*.html};

{$R *.res}

procedure DisplayLoginView(AMessage: string = ''); forward;

procedure DisplayMainView;

  procedure ConnectProc;
  begin
    if Assigned(FViewLogin) then
      FViewLogin.Free;
    TFViewMain.Display(@DisplayLoginView);
  end;

begin
  if not DMConnection.ApiConnection.Connected then
    DMConnection.ApiConnection.Open(@ConnectProc)
  else
    ConnectProc;
end;


procedure DisplayLoginView(AMessage: string);
begin
  AuthService.Logout;
  DMConnection.ApiConnection.Connected := False;
  if Assigned(FViewMain) then
    FViewMain.Free;
  TFViewLogin.Display(@DisplayMainView, AMessage);
end;


procedure UnauthorizedAccessProc(AMessage: string);
begin
  DisplayLoginView(AMessage);
end;


procedure StartApplication;
var
  ClientVer: string;
begin
  ClientVer := TDMConnection.clientVersion;
  DMConnection.InitApp(
    procedure
    begin
      DMConnection.SetClientConfig(
        procedure(Success: Boolean; ErrorMessage: string)
        begin
          if Success then
          begin
            if (not AuthService.Authenticated) or AuthService.TokenExpired then
              DisplayLoginView
            else
              DisplayMainView;
          end
          else
          begin
            asm
              var dlg = document.createElement("dialog");
              dlg.classList.add("shadow", "rounded", "border", "p-4");
              dlg.style.maxWidth = "500px";
              dlg.style.width = "90%";
              dlg.style.fontFamily = "system-ui, sans-serif";

              dlg.innerHTML =
                "<h5 class='fw-bold mb-3 text-danger'>kgOrders web app</h5>" +
                "<p class='mb-3' style='white-space: pre-wrap;'>" + ErrorMessage + "</p>" +
                "<div class='text-end'>" +
                "<button id='refreshBtn' class='btn btn-primary'>Reload</button></div>";

              document.body.appendChild(dlg);
              dlg.showModal();

              document.getElementById("refreshBtn").addEventListener("click", function () {
                var base = location.origin + location.pathname;
                location.replace(base + "?ver=" + ClientVer + "&r=" + Date.now() + location.hash);
              });
            end;
          end;
        end);
    end,
    @UnauthorizedAccessProc
  );
end;




begin
  Application.Initialize;
  Application.MainFormOnTaskbar := True;
  Application.CreateForm(TDMConnection, DMConnection);
  StartApplication;
  Application.Run;
end.
