unit Api.ServiceImpl;

interface

uses
  XData.Server.Module, XData.Service.Common, Api.Service, Api.Database,
  System.SysUtils, System.Generics.Collections, Uni, System.JSON,
  Common.Logging, System.IniFiles, Winapi.Windows, Winapi.Messages, System.Variants,
  Winapi.ShellApi, System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.StdCtrls, Vcl.ExtCtrls, Data.DB, uLibrary;

type
  [ServiceImplementation]
  TApiService = class(TInterfacedObject, IApiService)
  private
    FAppVersion: string;
  public
    FApiDatabase: TApiDatabase;

    constructor Create;
    destructor Destroy; override;
  end;

implementation

uses
  XData.Sys.Exceptions;

{ TApiService }
constructor TApiService.Create;
begin
  Logger.Log(1, 'TApiService.Create');
  inherited Create;
  try
    FApiDatabase := TApiDatabase.Create(nil);
  except
    on E: Exception do
    begin
      Logger.Log(2, '--Error creating TApiDatabase: ' + E.Message);
      raise;
    end;
  end;
end;


destructor TApiService.Destroy;
begin
  Logger.Log(1, 'TApiService.Destroy');
  FApiDatabase.Free;
  inherited Destroy;
end;



initialization
  RegisterServiceType(TApiService);


end.

