// The configuartion file for the program. Contains important info like the admin
// password and the secret token. Should likely move this to the ini file..

unit Common.Config;

interface

const
  defaultServerUrl = 'http://localhost:2004/emsys/template/';

type
  TServerConfig = class
  private
    Furl: string;
    FjwtTokenSecret: string;
    FadminPassword: string;
    FwebAppFolder: string;
    FreportsFolder: string;
  public
    property url: string read Furl write Furl;
    property jwtTokenSecret: string read FjwtTokenSecret write FjwtTokenSecret;
    property adminPassword: string read FadminPassword write FadminPassword;
    property webAppFolder: string read FwebAppFolder write FwebAppFolder;
    property reportsFolder: string read FreportsFolder write FreportsFolder;

    constructor Create;
  end;

procedure LoadServerConfig;
procedure SaveServerConfig(const AConfigFile: string = '');

var
  serverConfig: TServerConfig;

implementation

uses
  Bcl.Json, System.SysUtils, System.IOUtils, System.StrUtils,
  Common.Logging, Common.Ini;

function GetConfigFileName: string;
begin
  if TFile.Exists('serverconfig.json') then
    Result := 'serverconfig.json'
  else
    Result := TPath.ChangeExtension(ParamStr(0), '.json');
end;


procedure SaveServerConfig(const AConfigFile: string = '');
var
  configFile: string;
  serverConfigStr: string;
begin
  configFile := AConfigFile;
  if configFile = '' then
    configFile := GetConfigFileName;
  serverConfigStr := Bcl.Json.TJson.Serialize(serverConfig);
  TFile.WriteAllText(configFile, serverConfigStr);
  Logger.Log(1, '-- ServerConfig saved to file: ' + configFile);
end;


procedure LoadServerConfig;
var
  configFile: string;
  localConfig: TServerConfig;
  jwtFromIni: Boolean;
begin
  Logger.Log(1, '--LoadServerConfig - start');
  configFile := GetConfigFileName;
  Logger.Log(1, '-- Config file: ' + configFile);

  if TFile.Exists(configFile) then
  begin
    Logger.Log(1, '-- Config file found.');
    localConfig := TJson.Deserialize<TServerConfig>(TFile.ReadAllText(configFile));
    Logger.Log(1, '-- localConfig loaded from config file');

    serverConfig.Free;
    Logger.Log(1, '-- serverConfig.Free - called');
    serverConfig := localConfig;
    Logger.Log(1, '-- serverConfig := localConfig - called');
  end
  else
  begin
    Logger.Log(1, '-- Config file not found.');
    SaveServerConfig(configFile);
  end;

  Logger.Log(1, '--- Server Config Values ---');
  Logger.Log(1, '-- url: ' + serverConfig.url + IfThen(serverConfig.url = defaultServerUrl, ' [default]', ' [from config]'));
  Logger.Log(1, '-- adminPassword: ' + serverConfig.adminPassword + IfThen(serverConfig.adminPassword = 'whatisthisusedfor', ' [default]', ' [from config]'));
  Logger.Log(1, '-- jwtTokenSecret: [from config/default]');
  Logger.Log(1, '-- webAppFolder: ' + serverConfig.webAppFolder + IfThen(serverConfig.webAppFolder = 'static', ' [default]', ' [from config]'));
  Logger.Log(1, '-- reportsFolder: ' + serverConfig.reportsFolder + IfThen(serverConfig.reportsFolder = 'static\reports\', ' [default]', ' [from config]'));

  Logger.Log(1, '--LoadServerConfig - end');
end;


{ TServerConfig }
constructor TServerConfig.Create;
begin
  Logger.Log(1, '--TServerConfig.Create - start');
  url := defaultServerUrl;
  adminPassword := 'whatisthisusedfor';
  jwtTokenSecret := '';
  webAppFolder := 'static';
//  reportsFolder := 'static\reports\';
  Logger.Log(1, '--TServerConfig.Create - end');
end;

initialization
  serverConfig := TServerConfig.Create;

finalization
  serverConfig.Free;

end.
