// Auth Database to verify logins

unit Auth.Database;

interface

uses
  System.SysUtils, System.Classes, IniFiles, Vcl.Forms, MemDS,
  Data.DB, DBAccess, Uni, UniProvider, PostgreSQLUniProvider, MySQLUniProvider;

type
  TAuthDatabase = class(TDataModule)
    ucHST: TUniConnection;
    MySQLUniProvider1: TMySQLUniProvider;
    uqUser: TUniQuery;
    uqUseruser_id: TIntegerField;
    uqUseruser_name: TStringField;
    uqUseruser_password: TStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AuthDatabase: TAuthDatabase;

implementation

uses
  System.JSON,
  Common.Ini,
  Common.Config,
  Common.Logging,
  uLibrary;

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TAuthDatabase.DataModuleCreate(Sender: TObject);
begin
  Logger.Log(5, 'TAuthDatabase.DataModuleCreate');
  try
    ucHST.Database := IniEntries.dbDatabase;
    ucHST.Server := IniEntries.dbServer;
    ucHST.Port := IniEntries.dbPort;
    ucHST.Username := IniEntries.dbUsername;
    ucHST.Password := IniEntries.dbPassword;
    ucHST.Connect;
  except
    on E: Exception do
    begin
      Logger.Log(2, '--TAuthDatabase.DataModuleCreate -Error connecting to database: ' + E.Message);
    end;
  end;
end;


procedure TAuthDatabase.DataModuleDestroy(Sender: TObject);
begin
  ucHST.Connected := false;
end;


end.
