unit View.Main;

interface

uses
  System.SysUtils, System.Classes, JS, Web,
  WEBLib.Controls, WEBLib.Forms, WEBLib.ExtCtrls, WEBLib.StdCtrls,
  App.Types, ConnectionModule, XData.Web.Client, WEBLib.Dialogs, Vcl.StdCtrls,
  Vcl.Controls, Vcl.Graphics;

type
  TFViewMain = class(TWebForm)
    pnlMain: TWebPanel;
    lblUsername: TWebLabel;
    lblUserProfile: TWebLinkLabel;
    lblHome: TWebLinkLabel;
    lblLogout: TWebLinkLabel;
    lblVersion: TWebLabel;
    lblAppTitle: TWebLabel;
    memoDebug: TWebMemo;
    xdwcMain: TXDataWebClient;
    procedure WebFormCreate(Sender: TObject);
    procedure lblLogoutClick(Sender: TObject);
  private
    FChildForm: TWebForm;
    FLogoutProc: TLogoutProc;
    procedure ShowForm(aFormClass: TWebFormClass);
  public
    class procedure Display(logoutProc: TLogoutProc);
  end;

var
  FViewMain: TFViewMain;

implementation

uses
  Auth.Service,
  View.Test;

{$R *.dfm}

procedure TFViewMain.WebFormCreate(Sender: TObject);
var
  userName: string;
begin
  userName := JS.toString(AuthService.TokenPayload.Properties['user_name']);
  lblUsername.Caption := userName;
  lblVersion.Caption := 'v' + DMConnection.clientVersion;

  ShowForm(TFTest);
end;

procedure TFViewMain.lblLogoutClick(Sender: TObject);
begin
  if Assigned(FLogoutProc) then
    FLogoutProc('');
end;

procedure TFViewMain.ShowForm(aFormClass: TWebFormClass);
begin
  if Assigned(FChildForm) then
    FChildForm.Free;
  Application.CreateForm(aFormClass, pnlMain.ElementID, FChildForm);
end;

class procedure TFViewMain.Display(logoutProc: TLogoutProc);
begin
  if Assigned(FViewMain) then
    FViewMain.Free;
  FViewMain := TFViewMain.CreateNew;
  FViewMain.FLogoutProc := logoutProc;
end;

end.


