unit View.Test;

interface

uses
  System.SysUtils, System.Classes, JS, Web,
  WEBLib.Graphics, WEBLib.Controls, WEBLib.Forms, WEBLib.StdCtrls,
  XData.Web.Client,
  App.Types, ConnectionModule, Vcl.StdCtrls, Vcl.Controls;

type
  TFTest = class(TWebForm)
    lblTest: TWebLabel;
    btnTestApi: TWebButton;
    memoTestDebug: TWebMemo;
    xdwcTest: TXDataWebClient;
    [async] procedure btnTestApiClick(Sender: TObject);
    procedure memoTestDebugChange(Sender: TObject);
  private
    procedure AddLine(const s: string);
    procedure DumpClaims;
  public
  end;

var
  FTest: TFTest;

implementation

uses
  Auth.Service;

procedure TFTest.AddLine(const s: string);
begin
  memoTestDebug.Lines.Add(s);
end;

procedure TFTest.DumpClaims;
var
  token: string;
  payload: TJSObject;
begin
  token := AuthService.GetToken;

  AddLine('token present: ' + BoolToStr(token <> '', True));
  if token = '' then
    Exit;

  AddLine('token expired: ' + BoolToStr(AuthService.TokenExpired, True));
  AddLine('token exp (local): ' + DateTimeToStr(AuthService.TokenExpirationDate));

  payload := TJSObject(AuthService.TokenPayload);
  if not Assigned(payload) then
    Exit;

  asm
    const p = payload;
    const keys = Object.keys(p);
    for (let i = 0; i < keys.length; i++) {
      const k = keys[i];
      const v = p[k];
      this.AddLine('claim ' + k + ': ' + String(v));
    }
  end;
end;

[async] procedure TFTest.btnTestApiClick(Sender: TObject);
var
  response: TXDataClientResponse;
  resultObj: TJSObject;
  messageText: string;
  requiredVersion: string;
begin
  memoTestDebug.Visible := True;
  memoTestDebug.Lines.Clear;

  AddLine('--- request ---');
  AddLine('api url: ' + DMConnection.ApiConnection.URL);
  AddLine('auth url: ' + DMConnection.AuthConnection.URL);
  AddLine('clientVersion const: ' + DMConnection.clientVersion);

  AddLine('');
  AddLine('--- token / claims ---');
  DumpClaims;

  messageText := 'hello from TFTest @ ' + DateTimeToStr(Now);

  AddLine('');
  AddLine('calling IApiService.TestApi ...');
  try
    response := await(xdwcTest.RawInvokeAsync('IApiService.TestApi', [messageText]));
  except
    on E: Exception do
    begin
      AddLine('');
      AddLine('--- api exception ---');
      AddLine(E.Message);
      Exit;
    end;
  end;

  AddLine('');
  AddLine('--- api response ---');

  if not Assigned(response.Result) then
  begin
    AddLine('response.Result is nil');
    Exit;
  end;

  resultObj := TJSObject(response.Result);

  AddLine('messageEcho: ' + JS.toString(resultObj['messageEcho']));
  AddLine('serverTime: ' + JS.toString(resultObj['serverTime']));
  AddLine('requiredWebClientVersion: ' + JS.toString(resultObj['requiredWebClientVersion']));
  AddLine('note: ' + JS.toString(resultObj['note']));

  requiredVersion := JS.toString(resultObj['requiredWebClientVersion']);

  AddLine('');
  AddLine('--- version compare (client-side) ---');
  AddLine('clientVersion const: ' + DMConnection.clientVersion);
  AddLine('requiredWebClientVersion: ' + requiredVersion);
  AddLine('match: ' + BoolToStr(DMConnection.clientVersion = requiredVersion, True));
end;

procedure TFTest.memoTestDebugChange(Sender: TObject);
begin

end;

end.
