unit Common.Ini;

interface

uses
  System.SysUtils, System.IniFiles, Vcl.Forms;

type
  TIniEntries = class
  private
    // [Settings]
    FMemoLogLevel: Integer;
    FMemoLogLevelFromIni: Boolean;
    FFileLogLevel: Integer;
    FFileLogLevelFromIni: Boolean;
    FLogFileNum: Integer;
    FLogFileNumFromIni: Boolean;
    FEmailPolling: Boolean;
    FEmailPollingFromIni: Boolean;
    FEmailPollingInterval: Integer;
    FEmailPollingIntervalFromIni: Boolean;
    FWebClientVersion: string;
    FWebClientVersionFromIni: Boolean;
    FTwilioUpdateTime: Integer;
    FTwilioUpdateTimeFromIni: Boolean;

    // [Database]
    FDatabaseServer: string;
    FDatabaseServerFromIni: Boolean;
    FDatabaseName: string;
    FDatabaseNameFromIni: Boolean;
    FDatabaseUsername: string;
    FDatabaseUsernameFromIni: Boolean;
    FDatabasePassword: string;
    FDatabasePasswordFromIni: Boolean;

    // [Twilio]
    FTwilioSID: string;
    FTwilioSIDFromIni: Boolean;
    FTwilioAuthHeader: string;
    FTwilioAuthHeaderFromIni: Boolean;
  public
    constructor Create;

    // [Settings]
    property MemoLogLevel: Integer read FMemoLogLevel;
    property MemoLogLevelFromIni: Boolean read FMemoLogLevelFromIni;
    property FileLogLevel: Integer read FFileLogLevel;
    property FileLogLevelFromIni: Boolean read FFileLogLevelFromIni;
    property LogFileNum: Integer read FLogFileNum;
    property LogFileNumFromIni: Boolean read FLogFileNumFromIni;
    property EmailPolling: Boolean read FEmailPolling;
    property EmailPollingFromIni: Boolean read FEmailPollingFromIni;
    property EmailPollingInterval: Integer read FEmailPollingInterval;
    property EmailPollingIntervalFromIni: Boolean read FEmailPollingIntervalFromIni;
    property WebClientVersion: string read FWebClientVersion;
    property WebClientVersionFromIni: Boolean read FWebClientVersionFromIni;
    property TwilioUpdateTime: Integer read FTwilioUpdateTime;
    property TwilioUpdateTimeFromIni: Boolean read FTwilioUpdateTimeFromIni;

    // [Database]
    property DatabaseServer: string read FDatabaseServer;
    property DatabaseServerFromIni: Boolean read FDatabaseServerFromIni;
    property DatabaseName: string read FDatabaseName;
    property DatabaseNameFromIni: Boolean read FDatabaseNameFromIni;
    property DatabaseUsername: string read FDatabaseUsername;
    property DatabaseUsernameFromIni: Boolean read FDatabaseUsernameFromIni;
    property DatabasePassword: string read FDatabasePassword;
    property DatabasePasswordFromIni: Boolean read FDatabasePasswordFromIni;

    // [Twilio]
    property TwilioSID: string read FTwilioSID;
    property TwilioSIDFromIni: Boolean read FTwilioSIDFromIni;
    property TwilioAuthHeader: string read FTwilioAuthHeader;
    property TwilioAuthHeaderFromIni: Boolean read FTwilioAuthHeaderFromIni;
  end;

procedure LoadIniEntries;

var
  IniEntries: TIniEntries;

implementation

procedure LoadIniEntries;
begin
  if Assigned(IniEntries) then
    IniEntries.Free;
  IniEntries := TIniEntries.Create;
end;

{ TIniEntries }

constructor TIniEntries.Create;
var
  iniFile: TIniFile;
begin
  iniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  try
    // [Settings]
    FMemoLogLevel := iniFile.ReadInteger('Settings', 'MemoLogLevel', 3);
    FMemoLogLevelFromIni := iniFile.ValueExists('Settings', 'MemoLogLevel');

    FFileLogLevel := iniFile.ReadInteger('Settings', 'FileLogLevel', 3);
    FFileLogLevelFromIni := iniFile.ValueExists('Settings', 'FileLogLevel');

    FLogFileNum := iniFile.ReadInteger('Settings', 'LogFileNum', 0);
    FLogFileNumFromIni := iniFile.ValueExists('Settings', 'LogFileNum');

    FEmailPolling := iniFile.ReadBool('Settings', 'EmailPolling', False);
    FEmailPollingFromIni := iniFile.ValueExists('Settings', 'EmailPolling');

    FEmailPollingInterval := iniFile.ReadInteger('Settings', 'EmailPollingInterval', 1);
    FEmailPollingIntervalFromIni := iniFile.ValueExists('Settings', 'EmailPollingInterval');

    FWebClientVersion := iniFile.ReadString('Settings', 'webClientVersion', '');
    FWebClientVersionFromIni := iniFile.ValueExists('Settings', 'webClientVersion');

    FTwilioUpdateTime := iniFile.ReadInteger('Settings', 'TwilioUpdateTime', 0);
    FTwilioUpdateTimeFromIni := iniFile.ValueExists('Settings', 'TwilioUpdateTime');

    // [Database]
    FDatabaseServer := iniFile.ReadString('Database', 'Server', 'localhost');
    FDatabaseServerFromIni := iniFile.ValueExists('Database', 'Server');

    FDatabaseName := iniFile.ReadString('Database', 'Database', 'envoy_db');
    FDatabaseNameFromIni := iniFile.ValueExists('Database', 'Database');

    FDatabaseUsername := iniFile.ReadString('Database', 'Username', 'postgres');
    FDatabaseUsernameFromIni := iniFile.ValueExists('Database', 'Username');

    FDatabasePassword := iniFile.ReadString('Database', 'Password', '');
    FDatabasePasswordFromIni := iniFile.ValueExists('Database', 'Password');

    // [Twilio]
    FTwilioSID := iniFile.ReadString('Twilio', 'AccountSID', '');
    FTwilioSIDFromIni := iniFile.ValueExists('Twilio', 'AccountSID');

    FTwilioAuthHeader := iniFile.ReadString('Twilio', 'AuthHeader', '');
    FTwilioAuthHeaderFromIni := iniFile.ValueExists('Twilio', 'AuthHeader');
  finally
    iniFile.Free;
  end;
end;

end.

