program webEmiMobile;

uses
  Vcl.Forms,
  XData.Web.Connection,
  Auth.Service in 'Auth.Service.pas',
  App.Types in 'App.Types.pas',
  ConnectionModule in 'ConnectionModule.pas' {DMConnection: TWebDataModule},
  View.Login in 'View.Login.pas' {FViewLogin: TWebForm} {*.html},
  View.UserProfile in 'View.UserProfile.pas' {FViewUserProfile: TWebForm} {*.html},
  View.Units in 'View.Units.pas' {FViewUnits: TWebForm} {*.html},
  App.Config in 'App.Config.pas',
  Paginator.Plugins in 'Paginator.Plugins.pas',
  View.Complaints in 'View.Complaints.pas' {FViewComplaints: TWebForm} {*.html},
  View.Main in 'View.Main.pas' {FViewMain: TWebForm} {*.html},
  View.Map in 'View.Map.pas' {FViewMap: TWebForm} {*.html},
  View.Admin in 'View.Admin.pas' {FViewAdmin: TWebForm} {*.html},
  View.Users in 'View.Users.pas' {FViewUsers: TWebForm} {*.html},
  View.EditUser in 'View.EditUser.pas' {FViewEditUser: TWebForm} {*.html},
  Utils in 'Utils.pas',
  View.ErrorPage in 'View.ErrorPage.pas' {FViewErrorPage: TWebForm} {*.html},
  View.ComplaintDetails in 'View.ComplaintDetails.pas' {FViewComplaintDetails: TWebForm} {*.html};

{$R *.res}

procedure DisplayLoginView(AMessage: string = ''); forward;

procedure DisplayMainView;

  procedure ConnectProc;
  begin
    if Assigned(FViewLogin) then
      FViewLogin.Free;
    TFViewMain.Display(@DisplayLoginView);
  end;

begin
  if not DMConnection.ApiConnection.Connected then
    DMConnection.ApiConnection.Open(@ConnectProc)
  else
    ConnectProc;
end;

procedure DisplayLoginView(AMessage: string);
begin
  AuthService.Logout;
  DMConnection.ApiConnection.Connected := False;
  if Assigned(FViewMain) then
    FViewMain.Free;
  TFViewLogin.Display(@DisplayMainView, AMessage);
end;

procedure UnauthorizedAccessProc(AMessage: string);
begin
  DisplayLoginView(AMessage);
end;

procedure StartApplication;
begin
  DMConnection.SetClientConfig(
    procedure(Success: Boolean; ErrorMessage: string)
    begin
      if Success then
      begin
        if (not AuthService.Authenticated) or AuthService.TokenExpired then
          DisplayLoginView
        else
          DisplayMainView;
      end
      else
      begin
        asm
          var dlg = document.createElement("dialog");
          dlg.classList.add("shadow", "rounded", "border", "p-4");
          dlg.style.maxWidth = "500px";
          dlg.style.width = "90%";
          dlg.style.fontFamily = "system-ui, sans-serif";

          dlg.innerHTML =
            "<h5 class='fw-bold mb-3 text-danger'>kgOrders web app</h5>" +
            "<p class='mb-3' style='white-space: pre-wrap;'>" + ErrorMessage + "</p>" +
            "<div class='text-end'>" +
            "<button id='refreshBtn' class='btn btn-primary'>Reload</button></div>";

          document.body.appendChild(dlg);
          dlg.showModal();

          document.getElementById("refreshBtn").addEventListener("click", function () {
            location.reload(true); // Hard refresh
          });
        end;
      end;
    end);
end;


begin
  Application.Initialize;
  Application.MainFormOnTaskbar := True;
  Application.CreateForm(TDMConnection, DMConnection);
  Application.Run;
  DMConnection.InitApp(@StartApplication, @UnauthorizedAccessProc);
end.
