// Where the database is kept. Only used by Lookup.ServiceImpl to retrieve info
// from the data base and send it to the client.
// Author: ???
unit Api.Database;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, UniProvider,
  PostgreSQLUniProvider, System.Variants, System.Generics.Collections, System.IniFiles,
  Common.Logging, Vcl.Forms, OracleUniProvider;

type
  TApiDatabaseModule = class(TDataModule)
    ucEnvoy: TUniConnection;
    PostgreSQLUniProvider1: TPostgreSQLUniProvider;
    UniQuery1: TUniQuery;
    ucBooking: TUniConnection;
    OracleUniProvider1: TOracleUniProvider;
    uqBooking: TUniQuery;
    uqUnitsCurrent: TUniQuery;
    uqDISUnitsActive: TUniQuery;
    uqCFSActive: TUniQuery;
    uqCFSMemos: TUniQuery;
    uqComplaintList: TUniQuery;
    uqComplaintDetails: TUniQuery;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    class procedure ExecSQL(const SQL: string);
  end;

var
  ApiDatabaseModule: TApiDatabaseModule;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TApiDatabaseModule.DataModuleCreate(Sender: TObject);
var
  iniFile: TIniFile;
begin
  iniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  try
    ucEnvoy.Server := iniFile.ReadString('Database', 'Server', '');
    ucEnvoy.Database := iniFile.ReadString('Database', 'Database', '');
    ucEnvoy.Username := iniFile.ReadString('Database', 'Username', '');
    ucEnvoy.Password := iniFile.ReadString('Database', 'Password', '');

    try
      Logger.Log(2, '');
      Logger.Log(2, 'Connecting to envoyCalls Database (ApiDatabaseModule)...');
      Logger.Log(2, Format('--ucEnvoy.Server: %s ucEnvoy.Username: %s', [ucEnvoy.Server, ucEnvoy.Username]));
      if not ucEnvoy.Connected then
        ucEnvoy.Connect;
      Logger.Log(2, '--ucEnvoy connected!');
    except
      on E: Exception do
      begin
        Logger.Log(2, Format('Failed to connect to envoyCalls database: %s', [E.Message]));
      end;
    end;

    Logger.Log(1, '');
    Logger.Log(1, 'Loading Twilio settings...');

    var twilioSID := iniFile.ReadString('Twilio', 'AccountSID', '');
    if twilioSID.IsEmpty then
      Logger.Log(1, 'Twilio->AccountSID: Entry not found')
    else
      Logger.Log(1, 'Twilio->AccountSID: ' + twilioSID);

    var twilioAuth := iniFile.ReadString('Twilio', 'AuthHeader', '');
    if twilioAuth.IsEmpty then
      Logger.Log(1, 'Twilio->AuthHeader: Entry not found')
    else
      Logger.Log(1, 'Twilio->AuthHeader: ' + twilioAuth);

  finally
    iniFile.Free;
  end;
end;


class procedure TApiDatabaseModule.ExecSQL(const SQL: string);
var
  DB: TApiDatabaseModule;
begin
  DB := TApiDatabaseModule.Create(nil);
  try
    DB.UniQuery1.SQL.Text := SQL;
    DB.UniQuery1.ExecSQL;
  finally
    DB.Free;
  end;
end;

end.
