// Lookup Service interface which retrieves information from the database
// which is then sent to the client.
// Authors:
// Cameron Hayes
// Mac ...
// Elias Sarraf

unit Lookup.Service;

interface

uses
  XData.Service.Common,
  Aurelius.Mapping.Attributes,
  System.JSON,
  System.Generics.Collections,
  System.Classes;

const
  API_MODEL = 'Api';

type
  TCallItem = class
  // Class of the info we want from the database from a specific call.
  // callSid: SID of the call, 34 digit string.
  // fromNumber: Who the phone call was from. (xxx) xxx-xxxx
  // toNumber: Who the phone call was to. (xxx) xxx-xxxx
  // dateCreated: Date the phone call was created. mm/dd/yyyy hh:nn:ss am/pm
  // mediaURL: Link to the recording audio
  // duration: Length of the entire call and recording.
  // transcription: Transcription of the recording. Not always present due to
  // the call being answerered or caller did not leave a message.
  public
    callSid: string;
    fromNumber: string;
    toNumber: string;
    dateCreated: string;
    mediaUrl: string;
    duration: string;
    transcription: string;
  end;

  // List of call items
  // count: Total amount of records that fit the SQL query
  // data: List of retrieved calls
  TCallList = class
  public
    count: integer;
    data: TList<TCallItem>;
  end;

  TUserItem = class
  public
    userID: string;
    username: string;
    full_name: string;
    phone_number: string;
    email_address: string;
    admin: boolean;
    active: boolean;
    password: string;
  end;

  TUserList = class
  public
    count: integer;
    data: TList<TUserItem>;
  end;


type
  [ServiceContract, Model(API_MODEL)]
  ILookupService = interface(IInvokable)
    ['{F24E1468-5279-401F-A877-CD48B44F4416}']
    [HttpGet] function GetCalls(searchOptions: string): TCallList;
    [HttpGet] function Search(phoneNum: string): TCallList;
    [HttpGet] function GetUsers(searchOptions: string): TUserList;
    function AddUser(userInfo: string): string;
    function DelUser(username: string): string;
    function EditUser(const editOptions: string): string;
  end;

implementation

initialization
  RegisterServiceType(TypeInfo(ILookupService));

end.
