unit Api.Database;

interface

uses
  System.SysUtils, System.Classes, Data.DB, MemDS, DBAccess, Uni, UniProvider,
  PostgreSQLUniProvider, System.Variants, System.Generics.Collections, System.IniFiles,
  Common.Logging, Vcl.Forms, OracleUniProvider;

type
  TApiDatabaseModule = class(TDataModule)
    ucEnvoy: TUniConnection;
    PostgreSQLUniProvider1: TPostgreSQLUniProvider;
    UniQuery1: TUniQuery;
    OracleUniProvider1: TOracleUniProvider;
    uqBooking: TUniQuery;
    uqUnitsCurrent: TUniQuery;
    uqDISUnitsActive: TUniQuery;
    uqCFSActive: TUniQuery;
    uqCFSMemos: TUniQuery;
    uqComplaintList: TUniQuery;
    uqComplaintDetails: TUniQuery;
    ucENTCAD: TUniConnection;
    uqComplaintListCOMPLAINTID: TFloatField;
    uqComplaintListCFSID: TFloatField;
    uqComplaintListCOMPLAINT: TStringField;
    uqComplaintListAGENCY: TStringField;
    uqComplaintListDISPATCH_CODE_DESC: TStringField;
    uqComplaintListSOURCE: TStringField;
    uqComplaintListSOURCE_DESC: TStringField;
    uqComplaintListPRIORITY: TStringField;
    uqComplaintListADDRESSID: TFloatField;
    uqComplaintListADDRESS: TStringField;
    uqComplaintListAPARTMENT: TStringField;
    uqComplaintListCITY: TStringField;
    uqComplaintListBUSINESS: TStringField;
    uqComplaintListDISPATCHDISTRICT: TStringField;
    uqComplaintListDISPATCHSECTOR: TStringField;
    uqComplaintListADDRESSDISTRICT: TStringField;
    uqComplaintListADDRESSSECTOR: TStringField;
    uqComplaintListXCOORD: TFloatField;
    uqComplaintListYCOORD: TFloatField;
    uqComplaintListWARNINGS: TFloatField;
    uqComplaintListCONTACTS: TFloatField;
    uqComplaintListHISTORY: TFloatField;
    uqComplaintListDATEREPORTED: TDateTimeField;
    uqComplaintListDATERECEIVED: TDateTimeField;
    uqComplaintListDATEDISPATCHED: TDateTimeField;
    uqComplaintListDATERESPONDED: TDateTimeField;
    uqComplaintListDATEARRIVED: TDateTimeField;
    uqComplaintListDATECLEARED: TDateTimeField;
    uqComplaintDetailsCOMPLAINTID: TFloatField;
    uqComplaintDetailsCFSID: TFloatField;
    uqComplaintDetailsCOMPLAINT: TStringField;
    uqComplaintDetailsAGENCY: TStringField;
    uqComplaintDetailsDISPATCHCODE: TStringField;
    uqComplaintDetailsDISPATCH_CODE_DESC: TStringField;
    uqComplaintDetailsSOURCE: TStringField;
    uqComplaintDetailsSOURCE_DESC: TStringField;
    uqComplaintDetailsPRIORITY: TStringField;
    uqComplaintDetailsADDRESSID: TFloatField;
    uqComplaintDetailsADDRESS: TStringField;
    uqComplaintDetailsAPARTMENT: TStringField;
    uqComplaintDetailsCITY: TStringField;
    uqComplaintDetailsBUSINESS: TStringField;
    uqComplaintDetailsDISPATCHDISTRICT: TStringField;
    uqComplaintDetailsDISPATCHSECTOR: TStringField;
    uqComplaintDetailsADDRESSDISTRICT: TStringField;
    uqComplaintDetailsADDRESSSECTOR: TStringField;
    uqComplaintDetailsXCOORD: TFloatField;
    uqComplaintDetailsYCOORD: TFloatField;
    uqComplaintDetailsWARNINGS: TFloatField;
    uqComplaintDetailsCONTACTS: TFloatField;
    uqComplaintDetailsHISTORY: TFloatField;
    uqComplaintDetailsDATEREPORTED: TDateTimeField;
    uqComplaintDetailsDATERECEIVED: TDateTimeField;
    uqComplaintDetailsDATEDISPATCHED: TDateTimeField;
    uqComplaintDetailsDATERESPONDED: TDateTimeField;
    uqComplaintDetailsDATEARRIVED: TDateTimeField;
    uqComplaintDetailsDATECLEARED: TDateTimeField;
    uqCFSActiveCOMPLAINTID: TFloatField;
    uqCFSActiveUNITID: TFloatField;
    uqCFSActiveUNITNAME: TStringField;
    uqCFSActiveDATEDISPATCHED: TDateTimeField;
    uqCFSActiveDATERESPONDED: TDateTimeField;
    uqCFSActiveDATEARRIVED: TDateTimeField;
    uqCFSActiveDATECLEARED: TDateTimeField;
    uqCFSActiveLOCATION: TStringField;
    uqCFSMemosMEMO_ID: TFloatField;
    uqCFSMemosCFSID: TFloatField;
    uqCFSMemosMEMO_TYPE: TFloatField;
    uqCFSMemosTIMESTAMP: TDateTimeField;
    uqCFSMemosBADGE_NUMBER: TStringField;
    uqCFSMemosREMARKS: TStringField;
    uqUnitsCurrentENTRYID: TFloatField;
    uqUnitsCurrentUNITID: TFloatField;
    uqUnitsCurrentUNITNAME: TStringField;
    uqUnitsCurrentUNIT_DISTRICT: TStringField;
    uqUnitsCurrentGPS_LATITUDE: TFloatField;
    uqUnitsCurrentGPS_LONGITUDE: TFloatField;
    uqDISUnitsActiveUNITID: TFloatField;
    uqDISUnitsActiveUNITNAME: TStringField;
    uqDISUnitsActiveCARNUMBER_DESC: TStringField;
    uqDISUnitsActiveDISTRICT_DESC: TStringField;
    uqDISUnitsActiveSECTOR_DESC: TStringField;
    uqDISUnitsActiveOFFICER1_EMPNUM: TStringField;
    uqDISUnitsActiveOFFICER1_LAST_NAME: TStringField;
    uqDISUnitsActiveOFFICER1_FIRST_NAME: TStringField;
    uqDISUnitsActiveOFFICER1_MI: TStringField;
    uqDISUnitsActiveOFFICER2_EMPNUM: TStringField;
    uqDISUnitsActiveOFFICER2_LAST_NAME: TStringField;
    uqDISUnitsActiveOFFICER2_FIRST_NAME: TStringField;
    uqDISUnitsActiveOFFICER2_MI: TStringField;
    uqDISUnitsActiveLOCATION: TStringField;
    uqDISUnitsActiveCOMPLAINT: TStringField;
    uqDISUnitsActiveUNITSTATUS: TFloatField;
    uqDISUnitsActiveUNIT_STATUS_DESC: TStringField;
    uqDISUnitsActiveENTRYID: TFloatField;
    uqDISUnitsActiveGPS_LATITUDE: TFloatField;
    uqDISUnitsActiveGPS_LONGITUDE: TFloatField;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    class procedure ExecSQL(const SQL: string);
  end;

var
  ApiDatabaseModule: TApiDatabaseModule;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TApiDatabaseModule.DataModuleCreate(Sender: TObject);
var
  iniFile: TIniFile;
begin
  iniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  try
    ucEnvoy.Server := iniFile.ReadString('Database', 'Server', '');
    ucEnvoy.Database := iniFile.ReadString('Database', 'Database', '');
    ucEnvoy.Username := iniFile.ReadString('Database', 'Username', '');
    ucEnvoy.Password := iniFile.ReadString('Database', 'Password', '');

    try
      Logger.Log(2, '');
      Logger.Log(2, 'Connecting to envoyCalls Database (ApiDatabaseModule)...');
      Logger.Log(2, Format('--ucEnvoy.Server: %s ucEnvoy.Username: %s', [ucEnvoy.Server, ucEnvoy.Username]));
      if not ucEnvoy.Connected then
        ucEnvoy.Connect;
      Logger.Log(2, '--ucEnvoy connected!');
    except
      on E: Exception do
      begin
        Logger.Log(2, Format('Failed to connect to envoyCalls database: %s', [E.Message]));
      end;
    end;

    Logger.Log(1, '');
    Logger.Log(1, 'Loading Twilio settings...');

    var twilioSID := iniFile.ReadString('Twilio', 'AccountSID', '');
    if twilioSID.IsEmpty then
      Logger.Log(1, 'Twilio->AccountSID: Entry not found')
    else
      Logger.Log(1, 'Twilio->AccountSID: ' + twilioSID);

    var twilioAuth := iniFile.ReadString('Twilio', 'AuthHeader', '');
    if twilioAuth.IsEmpty then
      Logger.Log(1, 'Twilio->AuthHeader: Entry not found')
    else
      Logger.Log(1, 'Twilio->AuthHeader: ' + twilioAuth);

  finally
    iniFile.Free;
  end;
end;


class procedure TApiDatabaseModule.ExecSQL(const SQL: string);
var
  DB: TApiDatabaseModule;
begin
  DB := TApiDatabaseModule.Create(nil);
  try
    DB.UniQuery1.SQL.Text := SQL;
    DB.UniQuery1.ExecSQL;
  finally
    DB.Free;
  end;
end;

end.
