unit Api.Service;

interface

uses
  XData.Service.Common,
  Aurelius.Mapping.Attributes,
  System.JSON,
  System.Generics.Collections,
  System.Classes;

const
  API_MODEL = 'Api';

type
  [ServiceContract, Model(API_MODEL)]
  IApiService = interface(IInvokable)
    ['{4FCB7FAF-44E5-49D6-9C0F-EE44BFB33313}']
    [HttpGet] function GetBadgeCounts: TJSONObject;
    [HttpGet] function GetComplaintList: TJSONObject;
    [HttpGet] function GetUnitList: TJSONObject;
    [HttpGet] function GetComplaintMap: TJSONObject;
    [HttpGet] function GetUnitMap: TJSONObject;
    [HttpGet] function GetComplaintDetails(const ComplaintId: string): TJSONObject;
    [HttpGet] function GetComplaintMemos(const CfsId: string): TJSONObject;
    [HttpGet] function GetComplaintHistory(const ComplaintId: string): TJSONObject;
    [HttpGet] function GetComplaintContacts(const ComplaintId: string): TJSONObject;
    [HttpGet] function GetComplaintWarnings(const ComplaintId: string): TJSONObject;
    [HttpGet] function GetUnitDetails(const UnitId: string): TJSONObject;
    [HttpGet] function GetUnitLogs(const UnitId: string): TJSONObject;


  end;

implementation


end.
