unit Auth.Database;

interface

uses
  System.SysUtils, System.Classes, IniFiles, Vcl.Forms, MemDS,
  Data.DB, DBAccess, Uni, UniProvider, PostgreSQLUniProvider, OracleUniProvider;

type
  TAuthDatabase = class(TDataModule)
    uq: TUniQuery;
    uqMisc: TUniQuery;
    PostgreSQLUniProvider1: TPostgreSQLUniProvider;
    uquser_id: TLargeintField;
    uqusername: TStringField;
    uqpassword: TMemoField;
    uqdate_created: TStringField;
    uqadmin: TBooleanField;
    uqemail: TMemoField;
    uqphone_number: TStringField;
    uqfull_name: TStringField;
    uqactive: TBooleanField;
    OracleUniProvider1: TOracleUniProvider;
    ucBooking: TUniConnection;
    uqUserPref: TUniQuery;
    uqBooking: TUniQuery;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetLoginAuditEntry( userStr: string );
  end;

var
  AuthDatabase: TAuthDatabase;

implementation

uses
  System.JSON,
  Common.Config,
  Common.Logging,
  uLibrary;

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TAuthDatabase.DataModuleCreate(Sender: TObject);
var
  iniFile: TIniFile;
begin
  iniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  try
    ucBooking.Server := IniFile.ReadString('EMB Database', 'Server', 'EMBOOKING');
    ucBooking.Username := IniFile.ReadString('EMB Database', 'Username', 'emBooking');
    ucBooking.Password := IniFile.ReadString('EMB Database', 'Password', 'embook01');

    try
      Logger.Log(2, '');
      Logger.Log(2, 'Connecting to emBooking Database...');
      if not ucBooking.Connected then
      ucBooking.Connect;
    except
      on E: Exception do
      begin
        Logger.Log(2, Format('Failed to connect to database: %s', [E.Message]));
      end;
    end;

    Logger.Log(1, '');
    Logger.Log(1, 'Loading Twilio settings...');

    var twilioSID := iniFile.ReadString('Twilio', 'AccountSID', '');
    if twilioSID.IsEmpty then
      Logger.Log(1, 'Twilio->AccountSID: Entry not found')
    else
      Logger.Log(1, 'Twilio->AccountSID Found');

    var twilioAuth := iniFile.ReadString('Twilio', 'AuthHeader', '');
    if twilioAuth.IsEmpty then
      Logger.Log(1, 'Twilio->AuthHeader: Entry not found')
    else
      Logger.Log(1, 'Twilio->AuthHeader Found');

  finally
    iniFile.Free;
  end;
end;


procedure TAuthDatabase.DataModuleDestroy(Sender: TObject);
begin
  ucBooking.Connected := false;
end;

procedure TAuthDatabase.SetLoginAuditEntry( userStr: string );
var
  auditMasterId: string;
  userInfo: TStringList;
  entry: string;
  username: string;
  fullname: string;
  agency: string;
  userid: string;
  personnelid: string;
  admin: boolean;
  i: Integer;
begin
  Logger.Log( 3, 'TAuthDatabase.SetLoginAuditEntry - start' );

  userInfo := TStringList.Create;
  try
    userInfo.Delimiter := '&';
    userInfo.StrictDelimiter := True;
    userInfo.DelimitedText := userStr;
    username := userInfo.Values['username'];
    fullname := userInfo.Values['fullname'];
    agency := userInfo.Values['agency'];
    userid := userInfo.Values['userId'];
    personnelid := userInfo.Values['personnelid'];

    if ServerConfig.auditEnabled then
    begin
      auditMasterId := GetNextSeqVal( uqMisc, 'SEQ_AUDIT_MASTERID' );
      SetMasterAuditEntry( uq, auditMasterId, 'BKG', '', agency, personnelid, fullname, 'Login', '', 'webCharms' );
    end
    else
    begin
      Logger.Log( 3, 'SetSearchAuditEntry->SetMasterAuditEntry - auditEnabled = false' );
    end;
  finally
    userInfo.Free;
  end;
end;


end.
