// Uses Twilio.Data.Module for the rest api calls. Simply for testing querys.
// Visual aspect is for testing purposes only and has no affect on the client.
// Authors:
// Cameron Hayes
// Elias Serraf
// Mac ...
unit Data;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, AdvUtil, Data.DB, Vcl.Grids, AdvObj,
  BaseGrid, AdvGrid, DBAdvGrid, MemDS, DBAccess, Uni, Vcl.StdCtrls, Vcl.Mask,
  vcl.wwdbedit, vcl.wwdotdot, vcl.wwdbcomb, REST.Client, REST.Types, System.JSON,
  System.Generics.Collections, AdvEdit, vcl.wwdblook, vcl.wwdbdatetimepicker,
  System.Hash;

type
  TFData = class(TForm)
    dsCalls: TDataSource;
    btnFind: TButton;
    Memo1: TMemo;
    btnGetCalls: TButton;
    txtPhoneNum: TAdvEdit;
    DBAdvGrid1: TDBAdvGrid;
    DBAdvGrid2: TDBAdvGrid;
    dsRecordings: TDataSource;
    wwlcStore: TwwDBLookupCombo;
    dtpCallsDate1: TwwDBDateTimePicker;
    FullUpdate: TButton;
    lblStartDate: TLabel;
    lblLocation: TLabel;
    dtpCallsDate2: TwwDBDateTimePicker;
    Label1: TLabel;
    edtUsername: TEdit;
    edtPassword: TEdit;
    lblHash: TLabel;
    btnAddUser: TButton;
    lblHash2: TLabel;
    uqUsers: TUniQuery;
    cbAdmin: TCheckBox;
    uqUsersuser_id: TLargeintField;
    uqUsersusername: TStringField;
    uqUserspassword: TMemoField;
    uqUsersdate_created: TStringField;
    uqUsersadmin: TBooleanField;
    edtFullName: TEdit;
    edtPhoneNumber: TEdit;
    edtEmailAddress: TEdit;
    uqUsersemail: TMemoField;
    uqUsersphone_number: TStringField;
    uqUsersfull_name: TStringField;
    uqUsersactive: TBooleanField;
    procedure btnFindClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnGetCallsClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FullUpdateClick(Sender: TObject);
    procedure wwlcStoreCloseUp(Sender: TObject; LookupTable,
      FillTable: TDataSet; modified: Boolean);
    procedure btnAddUserClick(Sender: TObject);
    procedure addUser();
  private
    { Private declarations }
    accountSID: string;
    authHeader: string;
  public
    { Public declarations }
  end;

var
  FData: TFData;

implementation

{$R *.dfm}

uses Api.Database, Twilio.Data.Module, uLibrary;

procedure TFData.FormCreate(Sender: TObject);
begin
  TwilioDataModule := TTwilioDataModule.Create(Self);
end;


procedure TFData.FormDestroy(Sender: TObject);
begin
  TwilioDataModule.Free;
end;

procedure TFData.FullUpdateClick(Sender: TObject);
var
count: string;
begin
  count := TwilioDataModule.FullUpdate();
  Memo1.Lines.Add(count);
end;

procedure TFData.wwlcStoreCloseUp(Sender: TObject; LookupTable,
  FillTable: TDataSet; modified: Boolean);
begin
  if wwlcStore.Text = '' then
    txtPhoneNum.Text := ''
  else
    txtPhoneNum.Text := wwlcStore.LookupValue;
end;

procedure TFData.btnGetCallsClick(Sender: TObject);
// Gets 50 calls and adds them to the database if they havent seen an earlier call
begin
  TwilioDataModule.GetCalls(txtPhoneNum.Text, 50, 0 );
end;

procedure TFData.btnAddUserClick(Sender: TObject);
var
dateCreated: TDateTime;
hashString: string;
SQL: string;
begin
  addUser();
end;

procedure TFData.addUser();
var
dateCreated: TDateTime;
hashString: string;
SQL: string;
username: string;
begin
  dateCreated := now;
  hashString :=  DateTimeToStr(dateCreated) + edtPassword.Text;
  lblHash.Caption := THashSHA2.GetHashString(
    hashString,
    THashSHA2.TSHA2Version.SHA512).ToUpper;
  lblHash2.Caption := IntToStr(length(DateTimeToStr(dateCreated)));
  username := edtUsername.Text;
  username := username.ToLower;
  SQL := 'select * from envoy.users where username = ' + QuotedStr(username);
  uqUsers.Close;
  uqUsers.SQL.Text := sql;
  uqUsers.Open;
  if uqUsers.IsEmpty then
  begin
    uqUsers.Insert;

    uqUsersusername.AsString := username;
    uqUserspassword.AsString := THashSHA2.GetHashString(hashString,
                                THashSHA2.TSHA2Version.SHA512).ToUpper;
    uqUsersdate_created.AsString := DateTimeToStr(dateCreated);
    uqUsersadmin.AsBoolean := cbAdmin.Checked;
    uqUsersphone_number.AsString := edtPhoneNumber.Text;
    uqUsersemail.AsString := edtEmailAddress.Text;
    uqUsersfull_name.AsString := edtFullName.Text;

    uqUsers.Post;
    lblHash2.Caption := 'Added';
  end
  else
    lblHash2.Caption := 'Username already taken';


end;

procedure TFData.btnFindClick(Sender: TObject);
// Retrieves calls from a specific number from the database.
// SQL: SQL statement to retrieve calls from the database
// whereSQL: where section of the SQL that is built in the function
var
  SQL: string;
  whereSQL: string;
begin
  //TwilioDataModule.ShowCalls(txtPhoneNum.Text);

  whereSQL := 'where ';

  if wwlcStore.Text <> '' then
    whereSQL := whereSQL + 'to_formatted = ' + QuotedStr(txtPhoneNum.Text);

  if dtpCallsDate1.Text <> '' then
    if whereSQL = 'where ' then
      whereSQL := whereSQL + 'date_created > ' + QuotedStr(dtpCallsDate1.Text)
    else
      whereSQL := whereSQL + 'AND date_created > ' + QuotedStr(dtpCallsDate1.Text);

  if dtpCallsDate2.Text <> '' then
    if whereSQL = 'where ' then
      whereSQL := whereSQL + 'date_created <= ' + QuotedStr(dtpCallsDate2.Text)
    else
      whereSQL := whereSQL + 'AND date_created <= ' + QuotedStr(dtpCallsDate2.Text);

  if whereSQL = 'where ' then
    whereSQL := '';

  SQL := 'select * from envoy.calls '+ whereSQL + ' order by date_created desc';

  Memo1.Lines.Add(SQL);

  doQuery(TwilioDataModule.uqCalls, SQL);
  DBAdvGrid1.AutoSizeColumns(true);
end;

end.
