unit App.Server.Module;

interface

uses
  System.SysUtils, System.Classes, System.Generics.Collections,
  Sparkle.Comp.Server, Sparkle.Comp.StaticServer, Sparkle.Comp.HttpSysDispatcher,
  Sparkle.Module.Static, Sparkle.Comp.CompressMiddleware,
  Sparkle.HttpServer.Module, Sparkle.HttpServer.Context,
  Sparkle.Comp.LoggingMiddleware;

type
  TAppServerModule = class(TDataModule)
    SparkleHttpSysDispatcher: TSparkleHttpSysDispatcher;
    SparkleStaticServer: TSparkleStaticServer;
    SparkleStaticServerCompress: TSparkleCompressMiddleware;
    SparkleStaticServerLogging: TSparkleLoggingMiddleware;
  private
    { Private declarations }
  public
    { Public declarations }
    procedure StartAppServer(ABaseUrl: string);
  end;

const
  SERVER_PATH_SEGMENT = 'app';

var
  AppServerModule: TAppServerModule;

implementation

uses
  Sparkle.Middleware.Compress,
  Common.Logging,
  Common.Config;

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

{ TAppServerModule }

procedure TAppServerModule.StartAppServer(ABaseUrl: string);
var
  url: string;
begin
  url := ABaseUrl;
  if not url.EndsWith('/') then
    url := url + '/';
  url := url + SERVER_PATH_SEGMENT;

  SparkleStaticServer.BaseUrl := url;
  SparkleStaticServer.RootDir := serverConfig.webAppFolder;

  SparkleHttpSysDispatcher.Start;
  Logger.Log(1, Format('App server module listening at "%s", rootDir: %s', [url, serverConfig.webAppFolder]));
end;


end.
