unit Common.Ini;

interface

uses
  System.SysUtils, System.IniFiles, Vcl.Forms;

type
  TIniEntries = class
  private
    // [Settings]
    FMemoLogLevel: Integer;
    FMemoLogLevelFromIni: Boolean;
    FFileLogLevel: Integer;
    FFileLogLevelFromIni: Boolean;
    FLogFileNum: Integer;
    FLogFileNumFromIni: Boolean;
    FWebClientVersion: string;
    FWebClientVersionFromIni: Boolean;

    // [Database]

  public
    constructor Create;

    // [Settings]
    property MemoLogLevel: Integer read FMemoLogLevel;
    property MemoLogLevelFromIni: Boolean read FMemoLogLevelFromIni;
    property FileLogLevel: Integer read FFileLogLevel;
    property FileLogLevelFromIni: Boolean read FFileLogLevelFromIni;
    property LogFileNum: Integer read FLogFileNum;
    property LogFileNumFromIni: Boolean read FLogFileNumFromIni;

    property WebClientVersion: string read FWebClientVersion;
    property WebClientVersionFromIni: Boolean read FWebClientVersionFromIni;

    // [Database]

  end;

procedure LoadIniEntries;

var
  IniEntries: TIniEntries;

implementation

procedure LoadIniEntries;
begin
  if Assigned(IniEntries) then
    IniEntries.Free;
  IniEntries := TIniEntries.Create;
end;

{ TIniEntries }

constructor TIniEntries.Create;
var
  iniFile: TIniFile;
begin
  iniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  try
    // [Settings]
    FMemoLogLevel := iniFile.ReadInteger('Settings', 'MemoLogLevel', 3);
    FMemoLogLevelFromIni := iniFile.ValueExists('Settings', 'MemoLogLevel');

    FFileLogLevel := iniFile.ReadInteger('Settings', 'FileLogLevel', 3);
    FFileLogLevelFromIni := iniFile.ValueExists('Settings', 'FileLogLevel');

    FLogFileNum := iniFile.ReadInteger('Settings', 'LogFileNum', 0);
    FLogFileNumFromIni := iniFile.ValueExists('Settings', 'LogFileNum');

    FWebClientVersion := iniFile.ReadString('Settings', 'webClientVersion', '');
    FWebClientVersionFromIni := iniFile.ValueExists('Settings', 'webClientVersion');

    // [Database]

  finally
    iniFile.Free;
  end;
end;

end.

