unit View.ComplaintDetails;

interface

uses
  System.SysUtils, System.Classes, JS, Web,
  WEBLib.Graphics, WEBLib.Controls, WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls,
  WEBLib.Grids, WEBLib.DBCtrls;

type
  TFViewComplaintDetails = class(TWebForm)
    WebDBTableControl1: TWebDBTableControl;
  private
    FComplaintId: string;
  public
    class function CreateForm(AElementID, ComplaintId: string): TWebForm;
    procedure InitializeForm;
  end;

var
  FViewComplaintDetails: TFViewComplaintDetails;

implementation

{$R *.dfm}

class function TFViewComplaintDetails.CreateForm(AElementID, ComplaintId: string): TWebForm;

  procedure AfterCreate(AForm: TObject);
  begin
    with TFViewComplaintDetails(AForm) do
    begin
      FComplaintId := ComplaintId;
      InitializeForm; // kick off loading / UI binding here
    end;
  end;

begin
  Application.CreateForm(TFViewComplaintDetails, AElementID, Result, @AfterCreate);
end;

procedure TFViewComplaintDetails.InitializeForm;
begin
  // TODO:
  // - call your XData endpoint with FComplaintId
  // - bind fields / populate controls
  // - handle spinner / errors as you do elsewhere
end;

end.


//unit View.ComplaintDetails;
//
//interface
//
//uses
//  System.SysUtils, System.Classes, JS, Web,
//  WEBLib.Graphics, WEBLib.Controls, WEBLib.Forms, WEBLib.Dialogs,
//  WEBLib.StdCtrls, WEBLib.WebCtrls, WEBLib.ExtCtrls,
//  WEBLib.DB, Data.DB,
//  XData.Web.Client, XData.Web.JsonDataset, XData.Web.Dataset,
//  View.Main, View.Complaints, Vcl.Controls, WEBLib.Grids, WEBLib.DBCtrls;
//
//type
//  TFViewComplaintDetails = class(TWebForm)
//    // Header controls (ElementID -> HTML ids in snake_case)
//    btnCloseComplaintDetails: TWebButton;     // ElementID = 'btn_close_complaint_details'
//    lblComplaintNumber: TWebLabel;            // 'lbl_complaint_number'
//    lblPriority: TWebLabel;                   // 'lbl_priority'
//    lblStatus: TWebLabel;                     // 'lbl_status'
//    lblDispatchCode: TWebLabel;               // 'lbl_dispatch_code'
//    lblDispatchDistrict: TWebLabel;           // 'lbl_dispatch_district'
//    lblAddress: TWebLabel;                    // 'lbl_address'
//
//    // Action buttons (optional events later)
//    btnHistory: TWebButton;                   // 'btn_history'
//    btnWarnings: TWebButton;                  // 'btn_warnings'
//    btnContacts: TWebButton;                  // 'btn_contacts'
//    btnCMP: TWebButton;                       // 'btn_cmp'
//    btnE911: TWebButton;                      // 'btn_e911'
//    btnREM: TWebButton;                       // 'btn_rem'
//    btnUNT: TWebButton;                       // 'btn_unt'
//
//    // Data-aware table
//    tblComplaintDetails: TWebDBListControl;   // ElementID = 'tbl_complaint_details'
//    xdwcComplaintDetails: TXDataWebClient;
//    xdwdsxComplaintDetails: TXDataWebDataSet; // (your requested name)
//    wdsComplaintDetails: TWebDataSource;
//
//  private
//    FComplaintId: string;
//
//    [async] procedure LoadHeaderAsync;
//    [async] procedure LoadRowsAsync;
//
//  public
//    class function CreateForm(AElementID, ComplaintId: string): TWebForm;
//    procedure InitializeForm;
//  end;
//
//implementation
//
//{$R *.dfm}
//
//class function TFViewComplaintDetails.CreateForm(AElementID, ComplaintId: string): TWebForm;
//
//  procedure AfterCreate(AForm: TObject);
//  begin
//    with TFViewComplaintDetails(AForm) do
//    begin
//      FComplaintId := ComplaintId;
//      InitializeForm;
//    end;
//  end;
//
//begin
//  Application.CreateForm(TFViewComplaintDetails, AElementID, Result, @AfterCreate);
//end;
//
//procedure TFViewComplaintDetails.InitializeForm;
//begin
//  // Close button navigates back via Main (keeps host container ownership clean)
//  btnCloseComplaintDetails.OnClick :=
//    procedure(Sender: TObject)
//    begin
//      if Assigned(FViewMain) then
//      begin
////        FViewMain.SetActiveNavButton('view.main.btncomplaints');
//        FViewMain.ShowForm(TFViewComplaints);
//      end;
//    end;
//
//  // Data-aware wiring (design-time also OK; keeping here for clarity)
//  wdsComplaintDetails.DataSet := xdwdsxComplaintDetails;
//  tblComplaintDetails.DataSource := wdsComplaintDetails;
//
//  // Expecting ItemTemplate at design-time:
//  // <tr><td>(%MemoType%)</td><td>(%Timestamp%)</td><td>(%Remarks%)</td></tr>
//
//  // Kick off loads
//  LoadHeaderAsync;
//  LoadRowsAsync;
//end;
//
//[async] procedure TFViewComplaintDetails.LoadHeaderAsync;
//var
//  resp: TXDataClientResponse;
//  obj: TJSObject;
//begin
//  try
//    // TODO:Adjust endpoint and args to match your server (array param is common in XData)
//    resp := await(xdwcComplaintDetails.RawInvokeAsync('IApiService.GetComplaintDetailsHeader', [FComplaintId]));
//    obj := TJSObject(resp.Result);
//
//    // If the server returns { data: {...} }, unwrap:
//    if obj['data'] <> nil then
//      obj := TJSObject(obj['data']);
//
//    lblComplaintNumber.Caption := string(obj['ComplaintNumber']   ?? FComplaintId);
//    lblPriority.Caption := string(obj['Priority']          ?? '');
//    lblStatus.Caption := string(obj['Status']            ?? '');
//    lblDispatchCode.Caption := string(obj['DispatchCodeDesc']  ?? '');
//    lblDispatchDistrict.Caption := string(obj['DispatchDistrict']  ?? '');
//    lblAddress.Caption := string(obj['Address']           ?? '');
//  except
//    on E: Exception do
//      Console.Log('Header load error: ' + E.Message);
//  end;
//end;
//
//[async] procedure TFViewComplaintDetails.LoadRowsAsync;
//var
//  resp: TXDataClientResponse;
//  root: TJSObject;
//begin
//  try
//    // Adjust endpoint name/params to your API
//    resp := await(xdwcComplaintDetails.RawInvokeAsync('IApiService.GetComplaintDetailsRows', [FComplaintId]));
//    root := TJSObject(resp.Result);
//
//    // Expecting { data: [ { MemoType, Timestamp, Remarks }, ... ] }
//    xdwdsxComplaintDetails.Close;
//    xdwdsxComplaintDetails.SetJsonData(root['data']);
//    xdwdsxComplaintDetails.Open;
//  except
//    on E: Exception do
//      Console.Log('Rows load error: ' + E.Message);
//  end;
//end;
//
//end.

