unit Auth.Service;

interface

uses
  XData.Service.Common,
  Aurelius.Mapping.Attributes,
  System.Generics.Collections,
  System.JSON;

const
  AUTH_MODEL = 'Auth';

type
  TAgencyItem = class
  public
    agency: String;
    constructor Create( AAgency : String );
  end;

  TAgenciesList = class
  public
    count: integer;
    returned: integer;
    data: TList<TAgencyItem>;
  end;

  TAgencyConfigItem = class
  public
    id: integer;
    agency: String;
    name: String;
  end;

  TAgencyConfigList = class
  public
    count: integer;
    returned: integer;
    data: TList<TAgencyConfigItem>;
  end;

  [ServiceContract, Model(AUTH_MODEL)]
  IAuthService = interface(IInvokable)
  ['{D2290B28-964C-4155-A83A-DAE87C4C7FE7}']
    function Login(const user, password, agency: string): string;
    [HttpGet] function GetAgenciesList(): TAgenciesList;
    [HttpGet] function GetAgencyConfigList: TAgencyConfigList;
    function VerifyVersion(ClientVersion: string): TJSONObject;
  end;

implementation

{ TAgencyItem }

constructor TAgencyItem.Create(AAgency: String);
begin
  agency := AAgency;
end;

end.

constructor TAgencyItem.Create(AAgency: String);
begin
  agency := AAgency;
end;
end.
