// Delete this
unit View.Admin;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls, Vcl.StdCtrls, WEBLib.StdCtrls,
  XData.Web.Client, WEBLib.ExtCtrls, DB, XData.Web.JsonDataset,
  XData.Web.Dataset, XData.Web.Connection, Vcl.Forms;

type
  TFViewAdmin = class(TWebForm)
    lblInfo: TWebLabel;
    edtAddUsername: TWebEdit;
    edtPassword: TWebEdit;
    btnAddUser: TWebButton;
    XDataWebClient1: TXDataWebClient;
    lblResult: TWebLabel;
    WebLabel1: TWebLabel;
    WebLabel3: TWebLabel;
    WebLabel2: TWebLabel;
    WebLabel4: TWebLabel;
    WebLabel5: TWebLabel;
    WebLabel6: TWebLabel;
    WebLabel7: TWebLabel;
    edtUsername: TWebEdit;
    edtUserId: TWebEdit;
    edtFullName: TWebEdit;
    edtAgency: TWebEdit;
    chkAdminUser: TWebCheckBox;
    edtBadgeNum: TWebEdit;
    edtPersonnelId: TWebEdit;
    procedure btnAddUserClick(Sender: TObject);
    procedure WebFormShow(Sender: TObject);
    [async] procedure AddUser();
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FViewAdmin: TFViewAdmin;

implementation

uses
  XData.Model.Classes,
  ConnectionModule,
  Auth.Service;

{$R *.dfm}

procedure TFViewAdmin.WebFormShow(Sender: TObject);
begin
  console.log('');
  edtUsername.Text := JS.toString(AuthService.TokenPayload.Properties['user_name']);
  edtFullName.Text := JS.toString(AuthService.TokenPayload.Properties['user_fullname']);
  edtAgency.Text := JS.toString(AuthService.TokenPayload.Properties['user_agency']);
  edtBadgeNum.Text := JS.toString(AuthService.TokenPayload.Properties['user_badge']);
  edtUserId.Text := JS.toString(AuthService.TokenPayload.Properties['user_id']);
  edtPersonnelId.Text := JS.toString(AuthService.TokenPayload.Properties['user_personnelid']);

  //edtJwt.Text := TJSJSON.stringify(AuthService.TokenPayload);
  chkAdminUser.Checked := JS.toBoolean(AuthService.TokenPayload.Properties['user_admin']);
end;

procedure TFViewAdmin.btnAddUserClick(Sender: TObject);
begin
  AddUser();
end;

procedure TFViewAdmin.AddUser();
var
  xdcResponse: TXDataClientResponse;
  responseString: TJSObject;
begin
  xdcResponse := await(XDataWebClient1.RawInvokeAsync('ILookupService.AddUser',
        [edtAddUsername.Text, edtPassword.Text]));
  responseString :=  TJSObject(xdcResponse.Result);
  lblResult.Caption := string(responseString['value']);
end;


end.