unit View.Login;

interface

uses
  System.SysUtils, System.Classes, WEBLib.Graphics, WEBLib.Controls, WEBLib.Forms, WEBLib.Dialogs,
  Vcl.Controls, Vcl.StdCtrls, WEBLib.StdCtrls, WEBLib.JSON,
  JS, XData.Web.Connection, WEBLib.ExtCtrls,
  App.Types, ConnectionModule, XData.Web.Client;

type
  TFViewLogin = class(TWebForm)
    WebLabel1: TWebLabel;
    edtUsername: TWebEdit;
    edtPassword: TWebEdit;
    btnLogin: TWebButton;
    pnlMessage: TWebPanel;
    lblMessage: TWebLabel;
    btnCloseNotification: TWebButton;
    XDataWebClient: TXDataWebClient;
    lucbAgency: TWebLookupComboBox;
    procedure btnLoginClick(Sender: TObject);
    procedure btnCloseNotificationClick(Sender: TObject);
    procedure WebFormCreate(Sender: TObject);
  private
    FLoginProc: TSuccessProc;
    FMessage: string;
    procedure ShowNotification(Notification: string);
    procedure HideNotification;
    procedure GetAgencyConfigList;
  public
    class procedure Display(LoginProc: TSuccessProc); overload;
    class procedure Display(LoginProc: TSuccessProc; AMsg: string); overload;
  end;

var
  FViewLogin: TFViewLogin;

implementation

uses
  Auth.Service,
  View.ErrorPage;

{$R *.dfm}

class procedure TFViewLogin.Display(LoginProc: TSuccessProc);
begin
  TFViewLogin.Display(LoginProc, '');
end;

class procedure TFViewLogin.Display(LoginProc: TSuccessProc; AMsg: string);

  procedure FormCreate(AForm: TObject);
  begin
    TFViewLogin(AForm).FMessage := AMsg;
  end;

begin
  if Assigned(FViewLogin) then
    FViewLogin.Free;
  FViewLogin := TFViewLogin.CreateNew(@FormCreate);
  FViewLogin.FLoginProc := LoginProc;
end;


procedure TFViewLogin.WebFormCreate(Sender: TObject);
begin
//  lblAppTitle.Caption := 'EM Systems - webCharms App ver 0.9.2.22';
  GetAgencyConfigList();
  if FMessage <> '' then
    ShowNotification(FMessage)
  else
    HideNotification;
end;


procedure TFViewLogin.btnLoginClick(Sender: TObject);

  procedure LoginSuccess;
  begin
    FLoginProc;
  end;

  procedure LoginError(AMsg: string);
  begin
    ShowNotification('Login Error: ' + AMsg);
  end;

begin
  AuthService.Login(
    edtUsername.Text, edtPassword.Text, lucbAgency.Value,
    @LoginSuccess,
    @LoginError
  );
end;


procedure TFViewLogin.GetAgencyConfigList;

  procedure OnLoad(Response: TXDataClientResponse);
  var
    jsResponse: TJSObject;
    count: Integer;
    returned: Integer;
    jsArray: TJSArray;
    jsObject: TJSObject;
    agency: string;
    name: string;
    i: Integer;
  begin
    jsResponse := TJSObject(Response.Result);
    count := Integer(jsResponse['count']);
    returned := Integer(jsResponse['returned']);

    jsArray := TJSArray(TJSObject(Response.Result)['data']);
    lucbAgency.LookupValues.Clear;
    for i := 0 to jsArray.Length - 1 do
    begin
      jsObject := TJSObject( jsArray[i] );
      agency := string( jsObject['agency'] );
      name := string( jsObject['name'] );
      lucbAgency.LookupValues.AddPair( agency, agency + ' - ' + name );
    end;
  end;

  procedure OnError(Error: TXDataClientError);
  begin
    ShowNotification('GetAgencyConfigList: ' + Format('%s: %s', [Error.ErrorCode, Error.ErrorMessage]));
  end;

begin
  XDataWebClient.RawInvoke(
    'IAuthService.GetAgencyConfigList', [],
    @OnLoad, @OnError
  );
end;


procedure TFViewLogin.ShowNotification(Notification: string);
begin
  if Notification <> '' then
  begin
    lblMessage.Caption := Notification;
    pnlMessage.ElementHandle.hidden := False;
  end;
end;


procedure TFViewLogin.HideNotification;
begin
  pnlMessage.ElementHandle.hidden := True;
end;


procedure TFViewLogin.btnCloseNotificationClick(Sender: TObject);
begin
  HideNotification;
end;

end.
