unit Site.Footer;

interface

uses
  System.SysUtils, WEBLib.WebTools, WEBLib.Controls, JS, Web;

procedure InjectFooter;
procedure SetFooterVersion(const versionText: string);

implementation

const
  // Note: keep this in ONE place. Edit footer here, all pages update.
  FooterHtml =
    '<footer class="bg-dark text-light">' +
    '  <div class="container-main py-4">' +
    '    <div class="row gy-3 align-items-start text-center text-lg-start">' +
    '      <div class="col-lg-4 d-flex justify-content-center justify-content-lg-start">' +
    '        <a href="#FHome" class="navbar-brand m-0">' +
    '          <img src="images/EM_Logo_2c66a0.png" alt="EM_Logo" style="height: 30px;">' +
    '        </a>' +
    '      </div>' +
    '      <div class="col-lg-4">' +
    '        <ul class="list-unstyled mb-0 small">' +
    '          <li class="mb-1"><a href="#FHome" id="homefooter" class="link-light text-decoration-none">Home</a></li>' +
    '          <li class="mb-1"><a href="#FAboutUs" id="aboutusfooter" class="link-light text-decoration-none">About Us</a></li>' +
    '          <li><a href="#FContactUs" id="contactusfooter" class="link-light text-decoration-none">Contact Us</a></li>' +
    '        </ul>' +
    '      </div>' +
    '      <div class="col-lg-4">' +
    '        <address class="mb-0 small opacity-75">' +
    '          4043 Maple Rd, Suite 211<br>' +
    '          Amherst, NY 14226<br>' +
    '          (716) 836-4910' +
    '        </address>' +
    '      </div>' +
    '    </div>' +
    '    <div class="border-top border-secondary mt-3 pt-3">' +
    '      <div class="d-flex flex-column flex-sm-row justify-content-center align-items-center gap-2 text-center small opacity-75">' +
    '        <div> 2011-2026 EM Systems Inc</div>' +
    '        <span class="d-none d-sm-inline"></span>' +
    '        <span id="lbl_version"></span>' +
    '      </div>' +
    '    </div>' +
    '  </div>' +
    '</footer>';

procedure InjectFooter;
var
  el: TJSHTMLElement;
begin
  el := TJSHTMLElement(document.getElementById('site_footer'));
  if Assigned(el) then
    el.innerHTML := FooterHtml;
end;

procedure SetFooterVersion(const versionText: string);
var
  el: TJSHTMLElement;
begin
  el := TJSHTMLElement(document.getElementById('lbl_version'));
  if Assigned(el) then
    el.textContent := versionText;
end;

end.
